set quoted_identifier on
GO
use "NorthwindCS"
go
SET DATEFORMAT mdy
go
if exists (select * from sysobjects where id = object_id('dbo.Employee Sales by Country') and sysstat & 0xf = 4)
	drop procedure "dbo"."Employee Sales by Country"
GO
if exists (select * from sysobjects where id = object_id('dbo.Sales by Year') and sysstat & 0xf = 4)
	drop procedure "dbo"."Sales by Year"
GO
if exists (select * from sysobjects where id = object_id('dbo.Ten Most Expensive Products') and sysstat & 0xf = 4)
	drop procedure "dbo"."Ten Most Expensive Products"
GO
if exists (select * from sysobjects where id = object_id('dbo.Category Sales for 1997') and sysstat & 0xf = 2)
	drop view "dbo"."Category Sales for 1997"
GO
if exists (select * from sysobjects where id = object_id('dbo.Sales by Category') and sysstat & 0xf = 2)
	drop view "dbo"."Sales by Category"
GO
if exists (select * from sysobjects where id = object_id('dbo.Sales Totals by Amount') and sysstat & 0xf = 2)
	drop view "dbo"."Sales Totals by Amount"
GO
if exists (select * from sysobjects where id = object_id('dbo.Summary of Sales by Quarter') and sysstat & 0xf = 2)
	drop view "dbo"."Summary of Sales by Quarter"
GO
if exists (select * from sysobjects where id = object_id('dbo.Summary of Sales by Year') and sysstat & 0xf = 2)
	drop view "dbo"."Summary of Sales by Year"
GO
if exists (select * from sysobjects where id = object_id('dbo.Invoices') and sysstat & 0xf = 2)
	drop view "dbo"."Invoices"
GO
if exists (select * from sysobjects where id = object_id('dbo.Order Details Extended') and sysstat & 0xf = 2)
	drop view "dbo"."Order Details Extended"
GO
if exists (select * from sysobjects where id = object_id('dbo.Order Subtotals') and sysstat & 0xf = 2)
	drop view "dbo"."Order Subtotals"
GO
if exists (select * from sysobjects where id = object_id('dbo.Product Sales for 1997') and sysstat & 0xf = 2)
	drop view "dbo"."Product Sales for 1997"
GO
if exists (select * from sysobjects where id = object_id('dbo.Alphabetical List of Products') and sysstat & 0xf = 2)
	drop view "dbo"."Alphabetical List of Products"
GO
if exists (select * from sysobjects where id = object_id('dbo.Current Product List') and sysstat & 0xf = 2)
	drop view "dbo"."Current Product List"
GO
if exists (select * from sysobjects where id = object_id('dbo.Orders Qry') and sysstat & 0xf = 2)
	drop view "dbo"."Orders Qry"
GO
if exists (select * from sysobjects where id = object_id('dbo.Products Above Average Price') and sysstat & 0xf = 2)
	drop view "dbo"."Products Above Average Price"
GO
if exists (select * from sysobjects where id = object_id('dbo.Products by Category') and sysstat & 0xf = 2)
	drop view "dbo"."Products by Category"
GO
if exists (select * from sysobjects where id = object_id('dbo.Quarterly Orders') and sysstat & 0xf = 2)
	drop view "dbo"."Quarterly Orders"
GO
if exists (select * from sysobjects where id = object_id('dbo.Customer and Suppliers by City') and sysstat & 0xf = 2)
	drop view "dbo"."Customer and Suppliers by City"
GO
if exists (select * from sysobjects where id = object_id('dbo.Order Details') and sysstat & 0xf = 3)
	drop table "dbo"."Order Details"
GO
if exists (select * from sysobjects where id = object_id('dbo.Orders') and sysstat & 0xf = 3)
	drop table "dbo"."Orders"
GO
if exists (select * from sysobjects where id = object_id('dbo.Products') and sysstat & 0xf = 3)
	drop table "dbo"."Products"
GO
if exists (select * from sysobjects where id = object_id('dbo.Categories') and sysstat & 0xf = 3)
	drop table "dbo"."Categories"
GO
if exists (select * from sysobjects where id = object_id('dbo.Customers') and sysstat & 0xf = 3)
	drop table "dbo"."Customers"
GO
if exists (select * from sysobjects where id = object_id('dbo.dtproperties') and sysstat & 0xf = 3)
	drop table "dbo"."dtproperties"
GO
if exists (select * from sysobjects where id = object_id('dbo.Employees') and sysstat & 0xf = 3)
	drop table "dbo"."Employees"
GO
if exists (select * from sysobjects where id = object_id('dbo.Shippers') and sysstat & 0xf = 3)
	drop table "dbo"."Shippers"
GO
if exists (select * from sysobjects where id = object_id('dbo.Suppliers') and sysstat & 0xf = 3)
	drop table "dbo"."Suppliers"
GO

CREATE TABLE "Categories" (
	"CategoryID" "int" IDENTITY (1, 1) NOT NULL ,
	"CategoryName" varchar (15) NOT NULL ,
	"Description" "text" NULL ,
	"Picture" "image" NULL ,
	CONSTRAINT "PK_Categories" PRIMARY KEY  CLUSTERED 
	(
		"CategoryID"
	)
)
GO
 CREATE  UNIQUE  INDEX "CategoryName" ON "dbo"."Categories"("CategoryName")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Categories"  TO "public"
GO
CREATE TABLE "Customers" (
	"CustomerID" varchar (5) NOT NULL ,
	"CompanyName" varchar (40) NOT NULL ,
	"ContactName" varchar (30) NULL ,
	"ContactTitle" varchar (30) NULL ,
	"Address" varchar (60) NULL ,
	"City" varchar (15) NULL ,
	"Region" varchar (15) NULL ,
	"PostalCode" varchar (10) NULL ,
	"Country" varchar (15) NULL ,
	"Phone" varchar (24) NULL ,
	"Fax" varchar (24) NULL ,
	CONSTRAINT "PK_Customers" PRIMARY KEY  CLUSTERED 
	(
		"CustomerID"
	)
)
GO
 CREATE  INDEX "City" ON "dbo"."Customers"("City")
GO
 CREATE  INDEX "CompanyName" ON "dbo"."Customers"("CompanyName")
GO
 CREATE  INDEX "PostalCode" ON "dbo"."Customers"("PostalCode")
GO
 CREATE  INDEX "Region" ON "dbo"."Customers"("Region")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Customers"  TO "public"
GO
CREATE TABLE "dtproperties" (
	"id" "int" IDENTITY (1, 1) NOT NULL ,
	"objectid" "int" NULL ,
	"property" varchar (64) NOT NULL ,
	"value" varchar (255) NULL ,
	"lvalue" "image" NULL ,
	"version" "int" NOT NULL CONSTRAINT "DF__dtpropert__versi__7CEE9502" DEFAULT (0),
	CONSTRAINT "pk_dtproperties" PRIMARY KEY  CLUSTERED 
	(
		"id",
		"property"
	)
)
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dtproperties"  TO "public"
GO
declare @version7 binary
declare @version8 binary

declare @sql8 int
declare @sql7 int

select @sql7 = 0x07000000
select @sql8 = 0x08000000

select @version7 = convert(binary(4),(@sql7 & @@microsoftversion))
select @version8 = convert(binary(4),(@sql8 & @@microsoftversion))

if @version8 = 0x08 or @version7 = 0x07
begin
exec sp_MS_marksystemobject 'dbo.dtproperties'
end
GO

CREATE TABLE "Employees" (
	"EmployeeID" "int" IDENTITY (1, 1) NOT NULL ,
	"LastName" varchar (20) NOT NULL ,
	"FirstName" varchar (10) NOT NULL ,
	"Title" varchar (30) NULL ,
	"TitleOfCourtesy" varchar (25) NULL ,
	"BirthDate" "datetime" NULL ,
	"HireDate" "datetime" NULL ,
	"Address" varchar (60) NULL ,
	"City" varchar (15) NULL ,
	"Region" varchar (15) NULL ,
	"PostalCode" varchar (10) NULL ,
	"Country" varchar (15) NULL ,
	"HomePhone" varchar (24) NULL ,
	"Extension" varchar (4) NULL ,
	"Photo" varchar (255) NULL ,
	"Notes" "text" NULL ,
	"ReportsTo" "int" NULL ,
	CONSTRAINT "PK_Employees" PRIMARY KEY  CLUSTERED 
	(
		"EmployeeID"
	),
	CONSTRAINT "FK_Employees_Employees" FOREIGN KEY 
	(
		"ReportsTo"
	) REFERENCES "dbo"."Employees" (
		"EmployeeID"
	),
	CONSTRAINT "CK_BirthDate" CHECK (BirthDate < getdate())
	
)
GO
 CREATE  INDEX "LastName" ON "dbo"."Employees"("LastName")
GO
 CREATE  INDEX "PostalCode" ON "dbo"."Employees"("PostalCode")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Employees"  TO "public"
GO
CREATE TABLE "Shippers" (
	"ShipperID" "int" IDENTITY (1, 1) NOT NULL ,
	"CompanyName" varchar (40) NOT NULL ,
	"Phone" varchar (24) NULL ,
	CONSTRAINT "PK_Shippers" PRIMARY KEY  CLUSTERED 
	(
		"ShipperID"
	)
)
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Shippers"  TO "public"
GO
CREATE TABLE "Suppliers" (
	"SupplierID" "int" IDENTITY (1, 1) NOT NULL ,
	"CompanyName" varchar (40) NOT NULL ,
	"ContactName" varchar (30) NULL ,
	"ContactTitle" varchar (30) NULL ,
	"Address" varchar (60) NULL ,
	"City" varchar (15) NULL ,
	"Region" varchar (15) NULL ,
	"PostalCode" varchar (10) NULL ,
	"Country" varchar (15) NULL ,
	"Phone" varchar (24) NULL ,
	"Fax" varchar (24) NULL ,
	"HomePage" "text" NULL ,
	CONSTRAINT "PK_Suppliers" PRIMARY KEY  CLUSTERED 
	(
		"SupplierID"
	)
)
GO
 CREATE  INDEX "CompanyName" ON "dbo"."Suppliers"("CompanyName")
GO
 CREATE  INDEX "PostalCode" ON "dbo"."Suppliers"("PostalCode")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Suppliers"  TO "public"
GO
CREATE TABLE "Orders" (
	"OrderID" "int" IDENTITY (1, 1) NOT NULL ,
	"CustomerID" varchar (5) NULL ,
	"EmployeeID" "int" NULL ,
	"OrderDate" "datetime" NULL ,
	"RequiredDate" "datetime" NULL ,
	"ShippedDate" "datetime" NULL ,
	"ShipVia" "int" NULL ,
	"Freight" "money" NULL CONSTRAINT "DF__Temporary__Freig__23494814" DEFAULT (0),
	"ShipName" varchar (40) NULL ,
	"ShipAddress" varchar (60) NULL ,
	"ShipCity" varchar (15) NULL ,
	"ShipRegion" varchar (15) NULL ,
	"ShipPostalCode" varchar (10) NULL ,
	"ShipCountry" varchar (15) NULL ,
	CONSTRAINT "PK_Orders" PRIMARY KEY  CLUSTERED 
	(
		"OrderID"
	),
	CONSTRAINT "FK_Orders_Customers" FOREIGN KEY 
	(
		"CustomerID"
	) REFERENCES "dbo"."Customers" (
		"CustomerID"
	),
	CONSTRAINT "FK_Orders_Employees" FOREIGN KEY 
	(
		"EmployeeID"
	) REFERENCES "dbo"."Employees" (
		"EmployeeID"
	),
	CONSTRAINT "FK_Orders_Shippers" FOREIGN KEY 
	(
		"ShipVia"
	) REFERENCES "dbo"."Shippers" (
		"ShipperID"
	)
)
GO
 CREATE  INDEX "CustomerID" ON "dbo"."Orders"("CustomerID")
GO
 CREATE  INDEX "EmployeeID" ON "dbo"."Orders"("EmployeeID")
GO
 CREATE  INDEX "OrderDate" ON "dbo"."Orders"("OrderDate")
GO
 CREATE  INDEX "ShippedDate" ON "dbo"."Orders"("ShippedDate")
GO
 CREATE  INDEX "ShippersOrders" ON "dbo"."Orders"("ShipVia")
GO
 CREATE  INDEX "ShipPostalCode" ON "dbo"."Orders"("ShipPostalCode")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Orders"  TO "public"
GO
CREATE TABLE "Products" (
	"ProductID" "int" IDENTITY (1, 1) NOT NULL ,
	"ProductName" varchar (40) NOT NULL ,
	"SupplierID" "int" NULL ,
	"CategoryID" "int" NULL ,
	"QuantityPerUnit" varchar (20) NULL ,
	"UnitPrice" "money" NULL CONSTRAINT "DF__Temporary__UnitP__2CD2B24E" DEFAULT (0),
	"UnitsInStock" "smallint" NULL CONSTRAINT "DF__Temporary__Units__2DC6D687" DEFAULT (0),
	"UnitsOnOrder" "smallint" NULL CONSTRAINT "DF__Temporary__Units__2EBAFAC0" DEFAULT (0),
	"ReorderLevel" "smallint" NULL CONSTRAINT "DF__Temporary__Reord__2FAF1EF9" DEFAULT (0),
	"Discontinued" "bit" NOT NULL CONSTRAINT "DF__Temporary__Disco__30A34332" DEFAULT (0),
	CONSTRAINT "PK_Products" PRIMARY KEY  CLUSTERED 
	(
		"ProductID"
	),
	CONSTRAINT "FK_Products_Categories" FOREIGN KEY 
	(
		"CategoryID"
	) REFERENCES "dbo"."Categories" (
		"CategoryID"
	),
	CONSTRAINT "FK_Products_Suppliers" FOREIGN KEY 
	(
		"SupplierID"
	) REFERENCES "dbo"."Suppliers" (
		"SupplierID"
	),
	CONSTRAINT "CK_Products_UnitPrice" CHECK (UnitPrice >= 0),
	CONSTRAINT "CK_ReorderLevel" CHECK (ReorderLevel >= 0),
	CONSTRAINT "CK_UnitsInStock" CHECK (UnitsInStock >= 0),
	CONSTRAINT "CK_UnitsOnOrder" CHECK (UnitsOnOrder >= 0)
)
GO
 CREATE  INDEX "CategoryID" ON "dbo"."Products"("CategoryID")
GO
 CREATE  INDEX "ProductName" ON "dbo"."Products"("ProductName")
GO
 CREATE  INDEX "SupplierID" ON "dbo"."Products"("SupplierID")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Products"  TO "public"
GO
CREATE TABLE "Order Details" (
	"OrderID" "int" NOT NULL ,
	"ProductID" "int" NOT NULL ,
	"UnitPrice" "money" NOT NULL CONSTRAINT "DF__Temporary__UnitP__39388933" DEFAULT (0),
	"Quantity" "smallint" NOT NULL CONSTRAINT "DF__Temporary__Quant__3A2CAD6C" DEFAULT (1),
	"Discount" "real" NOT NULL CONSTRAINT "DF__Temporary__Disco__3B20D1A5" DEFAULT (0),
	CONSTRAINT "PK_Order_Details" PRIMARY KEY  CLUSTERED 
	(
		"OrderID",
		"ProductID"
	),
	CONSTRAINT "FK_Order_Details_Orders" FOREIGN KEY 
	(
		"OrderID"
	) REFERENCES "dbo"."Orders" (
		"OrderID"
	),
	CONSTRAINT "PK_Order_Details_Products" FOREIGN KEY 
	(
		"ProductID"
	) REFERENCES "dbo"."Products" (
		"ProductID"
	),
	CONSTRAINT "CK_Discount" CHECK (Discount >= 0 and (Discount <= 1)),
	CONSTRAINT "CK_Quantity" CHECK (Quantity > 0),
	CONSTRAINT "CK_UnitPrice" CHECK (UnitPrice >= 0)
)
GO
 CREATE  INDEX "ProductID" ON "dbo"."Order Details"("ProductID")
GO
GRANT  REFERENCES ,  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "Order Details"  TO "public"
GO
CREATE VIEW dbo."Customer and Suppliers by City"
AS
SELECT City, CompanyName, ContactName, 
    'Customers' AS Relationship
FROM Customers
UNION
SELECT City, CompanyName, ContactName, 'Suppliers'
FROM Suppliers
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Customer and Suppliers by City"  TO "public"
GO
CREATE VIEW dbo."Alphabetical List of Products"
AS
SELECT    dbo.Products.ProductID, dbo.Products.ProductName, dbo.Products.SupplierID, dbo.Products.CategoryID, dbo.Products.QuantityPerUnit, 
          dbo.Products.UnitPrice, dbo.Products.UnitsInStock, dbo.Products.UnitsOnOrder, dbo.Products.ReorderLevel, dbo.Products.Discontinued, 
          dbo.Categories.CategoryName
FROM      dbo.Categories INNER JOIN
          dbo.Products ON dbo.Categories.CategoryID = dbo.Products.CategoryID
WHERE     (dbo.Products.Discontinued = 0)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Alphabetical List of Products"  TO "public"
GO
CREATE VIEW dbo."Current Product List"
AS
SELECT ProductID, ProductName
FROM Products Product_List
WHERE (Discontinued = 0)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Current Product List"  TO "public"
GO
CREATE VIEW dbo."Orders Qry"
AS
SELECT Orders.OrderID, Orders.CustomerID, Orders.EmployeeID, 
    Orders.OrderDate, Orders.RequiredDate, Orders.ShippedDate, 
    Orders.ShipVia, Orders.Freight, Orders.ShipName, 
    Orders.ShipAddress, Orders.ShipCity, Orders.ShipRegion, 
    Orders.ShipPostalCode, Orders.ShipCountry, 
    Customers.CompanyName, Customers.Address, 
    Customers.City, Customers.Region, Customers.PostalCode, 
    Customers.Country
FROM Customers INNER JOIN
    Orders ON Customers.CustomerID = Orders.CustomerID
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Orders Qry"  TO "public"
GO
CREATE VIEW dbo."Products Above Average Price"
AS
SELECT Products.ProductName, Products.UnitPrice
FROM Products
WHERE (Products.UnitPrice) >
        (SELECT AVG(UnitPrice)
      FROM Products)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Products Above Average Price"  TO "public"
GO
CREATE VIEW dbo."Products by Category"
AS
SELECT Categories.CategoryName, Products.ProductName, 
    Products.QuantityPerUnit, Products.UnitsInStock, 
    Products.Discontinued
FROM Categories INNER JOIN
    Products ON 
    Categories.CategoryID = Products.CategoryID
WHERE (Products.Discontinued <> 1)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Products by Category"  TO "public"
GO
CREATE VIEW dbo."Quarterly Orders"
AS
SELECT DISTINCT 
    Customers.CustomerID, Customers.CompanyName, 
    Customers.City, Customers.Country
FROM Customers RIGHT OUTER JOIN
    Orders ON 
    Customers.CustomerID = Orders.CustomerID
WHERE (Orders.OrderDate BETWEEN '19970101' AND '19971231')
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Quarterly Orders"  TO "public"
GO
CREATE VIEW dbo.Invoices
AS
SELECT Orders.ShipName, Orders.ShipAddress, Orders.ShipCity, 
    Orders.ShipRegion, Orders.ShipPostalCode, 
    Orders.ShipCountry, Orders.CustomerID, 
    Customers.CompanyName AS CustomerName, 
    Customers.Address, Customers.City, Customers.Region, 
    Customers.PostalCode, Customers.Country, 
    Employees.FirstName + ' ' + Employees.LastName AS Salesperson,
     Orders.OrderID, Orders.OrderDate, Orders.RequiredDate, 
    Orders.ShippedDate, 
    Shippers.CompanyName AS ShipperName, 
    "Order Details".ProductID, Products.ProductName, 
    "Order Details".UnitPrice, "Order Details".Quantity, 
    "Order Details".Discount, CONVERT(money, 
    "Order Details".UnitPrice * Quantity * (1 - Discount) / 100) 
    * 100 AS ExtendedPrice, Orders.Freight
FROM Shippers INNER JOIN
    Products INNER JOIN
    Employees INNER JOIN
    Customers INNER JOIN
    Orders ON Customers.CustomerID = Orders.CustomerID ON 
    Employees.EmployeeID = Orders.EmployeeID INNER JOIN
    "Order Details" ON 
    Orders.OrderID = "Order Details".OrderID ON 
    Products.ProductID = "Order Details".ProductID ON 
    Shippers.ShipperID = Orders.ShipVia
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Invoices"  TO "public"
GO
CREATE VIEW dbo."Order Details Extended"
AS
SELECT "Order Details".OrderID, "Order Details".ProductID, 
    Products.ProductName, "Order Details".UnitPrice, 
    "Order Details".Quantity, "Order Details".Discount, 
    CONVERT(money, 
    "Order Details".UnitPrice * Quantity * (1 - Discount) / 100) 
    * 100 AS ExtendedPrice, Products.ProductID AS Expr1
FROM Products INNER JOIN
    "Order Details" ON 
    Products.ProductID = "Order Details".ProductID
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Order Details Extended"  TO "public"
GO
CREATE VIEW dbo."Order Subtotals"
AS
SELECT OrderID, SUM(CONVERT(money, 
    UnitPrice * Quantity * (1 - Discount) / 100) * 100) 
    AS Subtotal
FROM "Order Details"
GROUP BY OrderID
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Order Subtotals"  TO "public"
GO
CREATE VIEW dbo."Product Sales for 1997"
AS
SELECT Categories.CategoryName, Products.ProductName, 
    SUM(CONVERT(money, 
    "Order Details".UnitPrice * "Order Details".Quantity * (1 - "Order Details".Discount)
     / 100) * 100) AS ProductSales, 'Qtr ' + DATENAME(qq, 
    ShippedDate) AS ShippedQuarter
FROM (Categories INNER JOIN
    Products ON Categories.CategoryID = Products.CategoryID) 
    INNER JOIN
    (Orders INNER JOIN
    "Order Details" ON Orders.OrderID = "Order Details".OrderID) 
    ON Products.ProductID = "Order Details".ProductID
WHERE Orders.ShippedDate BETWEEN '19970101' AND 
    '19971231'
GROUP BY Categories.CategoryName, Products.ProductName, 
    'Qtr ' + DATENAME(qq, ShippedDate)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Product Sales for 1997"  TO "public"
GO
CREATE VIEW dbo."Category Sales for 1997"
AS
SELECT "Product Sales for 1997".CategoryName, 
    SUM("Product Sales for 1997".ProductSales) 
    AS CategorySales
FROM "Product Sales for 1997"
GROUP BY "Product Sales for 1997".CategoryName
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Category Sales for 1997"  TO "public"
GO
CREATE VIEW dbo."Sales by Category"
AS
SELECT Categories.CategoryID, Categories.CategoryName, 
    Products.ProductName, 
    SUM("Order Details Extended".ExtendedPrice) 
    AS ProductSales
FROM Categories INNER JOIN
    (Products INNER JOIN
    (Orders INNER JOIN
    "Order Details Extended" ON 
    Orders.OrderID = "Order Details Extended".OrderID) ON 
    Products.ProductID = "Order Details Extended".ProductID) ON 
    Categories.CategoryID = Products.CategoryID
WHERE Orders.OrderDate BETWEEN '19970101' AND 
    '19971231'
GROUP BY Categories.CategoryID, Categories.CategoryName, 
    Products.ProductName
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Sales by Category"  TO "public"
GO
CREATE VIEW dbo."Sales Totals by Amount"
AS
SELECT "Order Subtotals".Subtotal AS SaleAmount, Orders.OrderID, 
    Customers.CompanyName, Orders.ShippedDate
FROM Customers INNER JOIN
    (Orders INNER JOIN
    "Order Subtotals" ON 
    Orders.OrderID = "Order Subtotals".OrderID) ON 
    Customers.CustomerID = Orders.CustomerID
WHERE ("Order Subtotals".Subtotal > 2500) AND 
    (Orders.ShippedDate BETWEEN '19970101' AND '19971231')
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Sales Totals by Amount"  TO "public"
GO
CREATE VIEW dbo."Summary of Sales by Quarter"
AS
SELECT Orders.ShippedDate, Orders.OrderID, 
    "Order Subtotals".Subtotal
FROM Orders INNER JOIN
    "Order Subtotals" ON 
    Orders.OrderID = "Order Subtotals".OrderID
WHERE Orders.ShippedDate IS NOT NULL
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Summary of Sales by Quarter"  TO "public"
GO
CREATE VIEW dbo."Summary of Sales by Year"
AS
SELECT Orders.ShippedDate, Orders.OrderID, 
    "Order Subtotals".Subtotal
FROM Orders INNER JOIN
    "Order Subtotals" ON 
    Orders.OrderID = "Order Subtotals".OrderID
WHERE (Orders.ShippedDate IS NOT NULL)
GO
GRANT  SELECT ,  INSERT ,  DELETE ,  UPDATE  ON "dbo"."Summary of Sales by Year"  TO "public"
GO
Create Procedure "Ten Most Expensive Products"
AS
SET ROWCOUNT 10
SELECT Products.ProductName AS TenMostExpensiveProducts, Products.UnitPrice
FROM Products
ORDER BY Products.UnitPrice DESC
GO
Create Procedure "Employee Sales by Country"
@Beginning_Date datetime, @Ending_Date datetime
AS
SELECT Employees.Country, Employees.LastName, Employees.FirstName, Orders.ShippedDate, Orders.OrderID, "Order Subtotals".Subtotal AS SaleAmount
FROM Employees INNER JOIN (Orders INNER JOIN "Order Subtotals" ON Orders.OrderID = "Order Subtotals".OrderID) ON Employees.EmployeeID = Orders.EmployeeID
WHERE Orders.ShippedDate Between @Beginning_Date And @Ending_Date
GO
Create Procedure "Sales by Year"
@Beginning_Date datetime, @Ending_Date datetime
AS
SELECT  Orders.ShippedDate, Orders.OrderID, "Order Subtotals".Subtotal, DATENAME(yy,ShippedDate) AS Year
FROM Orders INNER JOIN "Order Subtotals" ON Orders.OrderID = "Order Subtotals".OrderID
WHERE Orders.ShippedDate Is Not Null And Orders.ShippedDate Between @Beginning_Date And @Ending_Date
GO
GRANT  EXECUTE  ON "dbo"."Ten Most Expensive Products"  TO "public"
GO
GRANT  EXECUTE  ON "dbo"."Employee Sales by Country"  TO "public"
GO
GRANT  EXECUTE  ON "dbo"."Sales by Year"  TO "public"
GO

set quoted_identifier on
go
set identity_insert "Categories" on
go
ALTER TABLE "Categories" NOCHECK CONSTRAINT ALL
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(1,'Beverages','Soft drinks, coffees, teas, beers, and ales',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(2,'Condiments','Sweet and savory sauces, relishes, spreads, and seasonings',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(3,'Confections','Desserts, candies, and sweet breads',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(4,'Dairy Products','Cheeses',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(5,'Grains/Cereals','Breads, crackers, pasta, and cereal',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(6,'Meat/Poultry','Prepared meats',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(7,'Produce','Dried fruit and bean curd',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)
go
INSERT "Categories"("CategoryID","CategoryName","Description","Picture") VALUES(8,'Seafood','Seaweed and fish',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)
go
go
set identity_insert "Categories" off
go
ALTER TABLE "Categories" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
ALTER TABLE "Customers" NOCHECK CONSTRAINT ALL
go
INSERT "Customers" VALUES('ALFKI','Alfreds Futterkiste','Maria Anders','Sales Representative','Obere Str. 57','Berlin',NULL,'12209','Germany','030-0074321','030-0076545')
INSERT "Customers" VALUES('ANATR','Ana Trujillo Emparedados y helados','Ana Trujillo','Owner','Avda. de la Constitucin 2222','Mxico D.F.',NULL,'05021','Mexico','(5) 555-4729','(5) 555-3745')
INSERT "Customers" VALUES('ANTON','Antonio Moreno Taquera','Antonio Moreno','Owner','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico','(5) 555-3932',NULL)
INSERT "Customers" VALUES('AROUT','Around the Horn','Thomas Hardy','Sales Representative','120 Hanover Sq.','London',NULL,'WA1 1DP','UK','(171) 555-7788','(171) 555-6750')
INSERT "Customers" VALUES('BERGS','Berglunds snabbkp','Christina Berglund','Order Administrator','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden','0921-12 34 65','0921-12 34 67')
INSERT "Customers" VALUES('BLAUS','Blauer See Delikatessen','Hanna Moos','Sales Representative','Forsterstr. 57','Mannheim',NULL,'68306','Germany','0621-08460','0621-08924')
INSERT "Customers" VALUES('BLONP','Blondel pre et fils','Frdrique Citeaux','Marketing Manager','24, place Klber','Strasbourg',NULL,'67000','France','88.60.15.31','88.60.15.32')
INSERT "Customers" VALUES('BOLID','Blido Comidas preparadas','Martn Sommer','Owner','C/ Araquil, 67','Madrid',NULL,'28023','Spain','(91) 555 22 82','(91) 555 91 99')
INSERT "Customers" VALUES('BONAP','Bon app''','Laurence Lebihan','Owner','12, rue des Bouchers','Marseille',NULL,'13008','France','91.24.45.40','91.24.45.41')
INSERT "Customers" VALUES('BOTTM','Bottom-Dollar Markets','Elizabeth Lincoln','Accounting Manager','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada','(604) 555-4729','(604) 555-3745')
go
INSERT "Customers" VALUES('BSBEV','B''s Beverages','Victoria Ashworth','Sales Representative','Fauntleroy Circus','London',NULL,'EC2 5NT','UK','(171) 555-1212',NULL)
INSERT "Customers" VALUES('CACTU','Cactus Comidas para llevar','Patricio Simpson','Sales Agent','Cerrito 333','Buenos Aires',NULL,'1010','Argentina','(1) 135-5555','(1) 135-4892')
INSERT "Customers" VALUES('CENTC','Centro comercial Moctezuma','Francisco Chang','Marketing Manager','Sierras de Granada 9993','Mxico D.F.',NULL,'05022','Mexico','(5) 555-3392','(5) 555-7293')
INSERT "Customers" VALUES('CHOPS','Chop-suey Chinese','Yang Wang','Owner','Hauptstr. 29','Bern',NULL,'3012','Switzerland','0452-076545',NULL)
INSERT "Customers" VALUES('COMMI','Comrcio Mineiro','Pedro Afonso','Sales Associate','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil','(11) 555-7647',NULL)
INSERT "Customers" VALUES('CONSH','Consolidated Holdings','Elizabeth Brown','Sales Representative','Berkeley Gardens
12  Brewery ','London',NULL,'WX1 6LT','UK','(171) 555-2282','(171) 555-9199')
INSERT "Customers" VALUES('DRACD','Drachenblut Delikatessen','Sven Ottlieb','Order Administrator','Walserweg 21','Aachen',NULL,'52066','Germany','0241-039123','0241-059428')
INSERT "Customers" VALUES('DUMON','Du monde entier','Janine Labrune','Owner','67, rue des Cinquante Otages','Nantes',NULL,'44000','France','40.67.88.88','40.67.89.89')
INSERT "Customers" VALUES('EASTC','Eastern Connection','Ann Devon','Sales Agent','35 King George','London',NULL,'WX3 6FW','UK','(171) 555-0297','(171) 555-3373')
INSERT "Customers" VALUES('ERNSH','Ernst Handel','Roland Mendel','Sales Manager','Kirchgasse 6','Graz',NULL,'8010','Austria','7675-3425','7675-3426')
go
INSERT "Customers" VALUES('FAMIA','Familia Arquibaldo','Aria Cruz','Marketing Assistant','Rua Ors, 92','So Paulo','SP','05442-030','Brazil','(11) 555-9857',NULL)
INSERT "Customers" VALUES('FISSA','FISSA Fabrica Inter. Salchichas S.A.','Diego Roel','Accounting Manager','C/ Moralzarzal, 86','Madrid',NULL,'28034','Spain','(91) 555 94 44','(91) 555 55 93')
INSERT "Customers" VALUES('FOLIG','Folies gourmandes','Martine Coquard','Assistant Sales Agent','184, chausse de Tournai','Lille',NULL,'59000','France','20.16.10.16','20.16.10.17')
INSERT "Customers" VALUES('FOLKO','Folk och f HB','Maria Larsson','Owner','kergatan 24','Brcke',NULL,'S-844 67','Sweden','0695-34 67 21',NULL)
INSERT "Customers" VALUES('FRANK','Frankenversand','Peter Franken','Marketing Manager','Berliner Platz 43','Mnchen',NULL,'80805','Germany','089-0877310','089-0877451')
INSERT "Customers" VALUES('FRANR','France restauration','Carine Schmitt','Marketing Manager','54, rue Royale','Nantes',NULL,'44000','France','40.32.21.21','40.32.21.20')
INSERT "Customers" VALUES('FRANS','Franchi S.p.A.','Paolo Accorti','Sales Representative','Via Monte Bianco 34','Torino',NULL,'10100','Italy','011-4988260','011-4988261')
INSERT "Customers" VALUES('FURIB','Furia Bacalhau e Frutos do Mar','Lino Rodriguez ','Sales Manager','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal','(1) 354-2534','(1) 354-2535')
INSERT "Customers" VALUES('GALED','Galera del gastrnomo','Eduardo Saavedra','Marketing Manager','Rambla de Catalua, 23','Barcelona',NULL,'08022','Spain','(93) 203 4560','(93) 203 4561')
INSERT "Customers" VALUES('GODOS','Godos Cocina Tpica','Jos Pedro Freyre','Sales Manager','C/ Romero, 33','Sevilla',NULL,'41101','Spain','(95) 555 82 82',NULL)
go
INSERT "Customers" VALUES('GOURL','Gourmet Lanchonetes','Andr Fonseca','Sales Associate','Av. Brasil, 442','Campinas','SP','04876-786','Brazil','(11) 555-9482',NULL)
INSERT "Customers" VALUES('GREAL','Great Lakes Food Market','Howard Snyder','Marketing Manager','2732 Baker Blvd.','Eugene','OR','97403','USA','(503) 555-7555',NULL)
INSERT "Customers" VALUES('GROSR','GROSELLA-Restaurante','Manuel Pereira','Owner','5 Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela','(2) 283-2951','(2) 283-3397')
INSERT "Customers" VALUES('HANAR','Hanari Carnes','Mario Pontes','Accounting Manager','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil','(21) 555-0091','(21) 555-8765')
INSERT "Customers" VALUES('HILAA','HILARIN-Abastos','Carlos Hernndez','Sales Representative','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela','(5) 555-1340','(5) 555-1948')
INSERT "Customers" VALUES('HUNGC','Hungry Coyote Import Store','Yoshi Latimer','Sales Representative','City Center Plaza
516 Main St.','Elgin','OR','97827','USA','(503) 555-6874','(503) 555-2376')
INSERT "Customers" VALUES('HUNGO','Hungry Owl All-Night Grocers','Patricia McKenna','Sales Associate','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland','2967 542','2967 3333')
INSERT "Customers" VALUES('ISLAT','Island Trading','Helen Bennett','Marketing Manager','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK','(198) 555-8888',NULL)
INSERT "Customers" VALUES('KOENE','Kniglich Essen','Philip Cramer','Sales Associate','Maubelstr. 90','Brandenburg',NULL,'14776','Germany','0555-09876',NULL)
INSERT "Customers" VALUES('LACOR','La corne d''abondance','Daniel Tonini','Sales Representative','67, avenue de l''Europe','Versailles',NULL,'78000','France','30.59.84.10','30.59.85.11')
go
INSERT "Customers" VALUES('LAMAI','La maison d''Asie','Annette Roulet','Sales Manager','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France','61.77.61.10','61.77.61.11')
INSERT "Customers" VALUES('LAUGB','Laughing Bacchus Wine Cellars','Yoshi Tannamuri','Marketing Assistant','1900 Oak St.','Vancouver','BC','V3F 2K1','Canada','(604) 555-3392','(604) 555-7293')
INSERT "Customers" VALUES('LAZYK','Lazy K Kountry Store','John Steel','Marketing Manager','12 Orchestra Terrace','Walla Walla','WA','99362','USA','(509) 555-7969','(509) 555-6221')
INSERT "Customers" VALUES('LEHMS','Lehmanns Marktstand','Renate Messner','Sales Representative','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany','069-0245984','069-0245874')
INSERT "Customers" VALUES('LETSS','Let''s Stop N Shop','Jaime Yorres','Owner','87 Polk St.
Suite 5','San Francisco','CA','94117','USA','(415) 555-5938',NULL)
INSERT "Customers" VALUES('LILAS','LILA-Supermercado','Carlos Gonzlez','Accounting Manager','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela','(9) 331-6954','(9) 331-7256')
INSERT "Customers" VALUES('LINOD','LINO-Delicateses','Felipe Izquierdo','Owner','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela','(8) 34-56-12','(8) 34-93-93')
INSERT "Customers" VALUES('LONEP','Lonesome Pine Restaurant','Fran Wilson','Sales Manager','89 Chiaroscuro Rd.','Portland','OR','97219','USA','(503) 555-9573','(503) 555-9646')
INSERT "Customers" VALUES('MAGAA','Magazzini Alimentari Riuniti','Giovanni Rovelli','Marketing Manager','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy','035-640230','035-640231')
INSERT "Customers" VALUES('MAISD','Maison Dewey','Catherine Dewey','Sales Agent','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium','(02) 201 24 67','(02) 201 24 68')
go
INSERT "Customers" VALUES('MEREP','Mre Paillarde','Jean Fresnire','Marketing Assistant','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada','(514) 555-8054','(514) 555-8055')
INSERT "Customers" VALUES('MORGK','Morgenstern Gesundkost','Alexander Feuer','Marketing Assistant','Heerstr. 22','Leipzig',NULL,'04179','Germany','0342-023176',NULL)
INSERT "Customers" VALUES('NORTS','North/South','Simon Crowther','Sales Associate','South House
300 Queensbridge','London',NULL,'SW7 1RZ','UK','(171) 555-7733','(171) 555-2530')
INSERT "Customers" VALUES('OCEAN','Ocano Atlntico Ltda.','Yvonne Moncada','Sales Agent','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina','(1) 135-5333','(1) 135-5535')
INSERT "Customers" VALUES('OLDWO','Old World Delicatessen','Rene Phillips','Sales Representative','2743 Bering St.','Anchorage','AK','99508','USA','(907) 555-7584','(907) 555-2880')
INSERT "Customers" VALUES('OTTIK','Ottilies Kseladen','Henriette Pfalzheim','Owner','Mehrheimerstr. 369','Kln',NULL,'50739','Germany','0221-0644327','0221-0765721')
INSERT "Customers" VALUES('PARIS','Paris spcialits','Marie Bertrand','Owner','265, boulevard Charonne','Paris',NULL,'75012','France','(1) 42.34.22.66','(1) 42.34.22.77')
INSERT "Customers" VALUES('PERIC','Pericles Comidas clsicas','Guillermo Fernndez','Sales Representative','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico','(5) 552-3745','(5) 545-3745')
INSERT "Customers" VALUES('PICCO','Piccolo und mehr','Georg Pipps','Sales Manager','Geislweg 14','Salzburg',NULL,'5020','Austria','6562-9722','6562-9723')
INSERT "Customers" VALUES('PRINI','Princesa Isabel Vinhos','Isabel de Castro','Sales Representative','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal','(1) 356-5634',NULL)
go
INSERT "Customers" VALUES('QUEDE','Que Delcia','Bernardo Batista','Accounting Manager','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil','(21) 555-4252','(21) 555-4545')
INSERT "Customers" VALUES('QUEEN','Queen Cozinha','Lcia Carvalho','Marketing Assistant','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil','(11) 555-1189',NULL)
INSERT "Customers" VALUES('QUICK','QUICK-Stop','Horst Kloss','Accounting Manager','Taucherstrae 10','Cunewalde',NULL,'01307','Germany','0372-035188',NULL)
INSERT "Customers" VALUES('RANCH','Rancho grande','Sergio Gutirrez','Sales Representative','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina','(1) 123-5555','(1) 123-5556')
INSERT "Customers" VALUES('RATTC','Rattlesnake Canyon Grocery','Paula Wilson','Assistant Sales Representative','2817 Milton Dr.','Albuquerque','NM','87110','USA','(505) 555-5939','(505) 555-3620')
INSERT "Customers" VALUES('REGGC','Reggiani Caseifici','Maurizio Moroni','Sales Associate','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy','0522-556721','0522-556722')
INSERT "Customers" VALUES('RICAR','Ricardo Adocicados','Janete Limeira','Assistant Sales Agent','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil','(21) 555-3412',NULL)
INSERT "Customers" VALUES('RICSU','Richter Supermarkt','Michael Holz','Sales Manager','Grenzacherweg 237','Genve',NULL,'1203','Switzerland','0897-034214',NULL)
INSERT "Customers" VALUES('ROMEY','Romero y tomillo','Alejandra Camino','Accounting Manager','Gran Va, 1','Madrid',NULL,'28001','Spain','(91) 745 6200','(91) 745 6210')
INSERT "Customers" VALUES('SANTG','Sant Gourmet','Jonas Bergulfsen','Owner','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway','07-98 92 35','07-98 92 47')
go
INSERT "Customers" VALUES('SAVEA','Save-a-lot Markets','Jose Pavarotti','Sales Representative','187 Suffolk Ln.','Boise','ID','83720','USA','(208) 555-8097',NULL)
INSERT "Customers" VALUES('SEVES','Seven Seas Imports','Hari Kumar','Sales Manager','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK','(171) 555-1717','(171) 555-5646')
INSERT "Customers" VALUES('SIMOB','Simons bistro','Jytte Petersen','Owner','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark','31 12 34 56','31 13 35 57')
INSERT "Customers" VALUES('SPECD','Spcialits du monde','Dominique Perrier','Marketing Manager','25, rue Lauriston','Paris',NULL,'75016','France','(1) 47.55.60.10','(1) 47.55.60.20')
INSERT "Customers" VALUES('SPLIR','Split Rail Beer & Ale','Art Braunschweiger','Sales Manager','P.O. Box 555','Lander','WY','82520','USA','(307) 555-4680','(307) 555-6525')
INSERT "Customers" VALUES('SUPRD','Suprmes dlices','Pascale Cartrain','Accounting Manager','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium','(071) 23 67 22 20','(071) 23 67 22 21')
INSERT "Customers" VALUES('THEBI','The Big Cheese','Liz Nixon','Marketing Manager','89 Jefferson Way
Suite 2','Portland','OR','97201','USA','(503) 555-3612',NULL)
INSERT "Customers" VALUES('THECR','The Cracker Box','Liu Wong','Marketing Assistant','55 Grizzly Peak Rd.','Butte','MT','59801','USA','(406) 555-5834','(406) 555-8083')
INSERT "Customers" VALUES('TOMSP','Toms Spezialitten','Karin Josephs','Marketing Manager','Luisenstr. 48','Mnster',NULL,'44087','Germany','0251-031259','0251-035695')
INSERT "Customers" VALUES('TORTU','Tortuga Restaurante','Miguel Angel Paolino','Owner','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico','(5) 555-2933',NULL)
go
INSERT "Customers" VALUES('TRADH','Tradio Hipermercados','Anabela Domingues','Sales Representative','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil','(11) 555-2167','(11) 555-2168')
INSERT "Customers" VALUES('TRAIH','Trail''s Head Gourmet Provisioners','Helvetius Nagy','Sales Associate','722 DaVinci Blvd.','Kirkland','WA','98034','USA','(206) 555-8257','(206) 555-2174')
INSERT "Customers" VALUES('VAFFE','Vaffeljernet','Palle Ibsen','Sales Manager','Smagslget 45','rhus',NULL,'8200','Denmark','86 21 32 43','86 22 33 44')
INSERT "Customers" VALUES('VICTE','Victuailles en stock','Mary Saveley','Sales Agent','2, rue du Commerce','Lyon',NULL,'69004','France','78.32.54.86','78.32.54.87')
INSERT "Customers" VALUES('VINET','Vins et alcools Chevalier','Paul Henriot','Accounting Manager','59 rue de l''Abbaye','Reims',NULL,'51100','France','26.47.15.10','26.47.15.11')
INSERT "Customers" VALUES('WANDK','Die Wandernde Kuh','Rita Mller','Sales Representative','Adenauerallee 900','Stuttgart',NULL,'70563','Germany','0711-020361','0711-035428')
INSERT "Customers" VALUES('WARTH','Wartian Herkku','Pirkko Koskitalo','Accounting Manager','Torikatu 38','Oulu',NULL,'90110','Finland','981-443655','981-443655')
INSERT "Customers" VALUES('WELLI','Wellington Importadora','Paula Parente','Sales Manager','Rua do Mercado, 12','Resende','SP','08737-363','Brazil','(14) 555-8122',NULL)
INSERT "Customers" VALUES('WHITC','White Clover Markets','Karl Jablonski','Owner','305 - 14th Ave. S.
Suite 3B','Seattle','WA','98128','USA','(206) 555-4112','(206) 555-4115')
INSERT "Customers" VALUES('WILMK','Wilman Kala','Matti Karttunen','Owner/Marketing Assistant','Keskuskatu 45','Helsinki',NULL,'21240','Finland','90-224 8858','90-224 8858')
go
INSERT "Customers" VALUES('WOLZA','Wolski  Zajazd','Zbyszek Piestrzeniewicz','Owner','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland','(26) 642-7012','(26) 642-7012')
go
ALTER TABLE "Customers" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "dtproperties" on
go
ALTER TABLE "dtproperties" NOCHECK CONSTRAINT ALL
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(1,1,'DtgSchemaOBJECT',NULL,NULL,0)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(2,1,'DtgSchemaGUID','{EA3E6268-D998-11CE-9454-00AA00A3F36E}',NULL,0)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(3,1,'DtgSchemaNAME','Relationships',NULL,0)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(4,1,'DtgDSRefBYTES','838',NULL,2)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(5,1,'DtgDSRefDATA',NULL,0xDBE6B0E91C81D011AD5100A0C90F573900000200309C3BF72818BE01020200001048050000000000000000000000000000000000AA010000500072006F00760069006400650072003D00530051004C004F004C004500440042002E0031003B0055007300650072002000490044003D00730061003B0049006E0069007400690061006C00200043006100740061006C006F0067003D004E006F00720074006800770069006E006400430053003B004400610074006100200053006F0075007200630065003D005000450054004500520048005500530046003B004C006F00630061006C00650020004900640065006E007400690066006900650072003D0031003000330033003B0043006F006E006E006500630074002000540069006D0065006F00750074003D00310035003B005500730065002000500072006F00630065006400750072006500200066006F007200200050007200650070006100720065003D0031003B004100750074006F0020005400720061006E0073006C006100740065003D0054007200750065003B005000610063006B00650074002000530069007A0065003D0034003000390036003B0057006F0072006B00730074006100740069006F006E002000490044003D005000450054004500520048005500530045000000008005001C000000520065006C006100740069006F006E00730068006900700073000000000226001400000053007500700070006C006900650072007300000008000000640062006F0000000002260016000000430061007400650067006F007200690065007300000008000000640062006F0000000002260012000000500072006F0064007500630074007300000008000000640062006F000000000226001C0000004F0072006400650072002000440065007400610069006C007300000008000000640062006F000000000226001400000045006D0070006C006F007900650065007300000008000000640062006F000000000226000E0000004F0072006400650072007300000008000000640062006F000000000226001400000043007500730074006F006D00650072007300000008000000640062006F000000000224001200000053006800690070007000650072007300000008000000640062006F000000,2)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(6,1,'DtgSchemaBYTES','14848',NULL,2)
go
INSERT "dtproperties"("id","objectid","property","value","lvalue","version") VALUES(7,1,'DtgSchemaDATA',NULL,0xD0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000000200000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFF16000000FEFFFFFF0400000005000000060000001500000008000000090000000A0000000B0000000C0000000D0000000E0000000F0000001000000011000000120000001300000014000000FEFFFFFF17000000FEFFFFFF18000000190000001A0000001B000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF0200000000000000000000000000000000000000000000000000000000000000101245F72818BE010300000040120000000000006600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004000201FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000F2070000000000006F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040002010100000004000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000007000000A21B000000000000010043006F006D0070004F0062006A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012000201FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000002000000061000000000000000100000002000000030000000400000005000000060000000700000008000000090000000A0000000B0000000C0000000D0000000E0000000F000000100000001100000012000000130000001400000015000000160000001700000018000000190000001A0000001B0000001C0000001D0000001E0000001F000000FEFFFFFF21000000FEFFFFFF230000002400000025000000260000002700000028000000290000002A0000002B0000002C0000002D0000002E0000002F00000030000000310000003200000033000000340000003500000036000000370000003800000039000000FEFFFFFFFEFFFFFF3C0000003D0000003E0000003F000000400000004100000042000000430000004400000045000000460000004700000048000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000428000A0E100C05000080180000000F00FFFF18000000007D00006C69000013430000167D00005E540000DE805B10F195D011B0A000AA00BDCB5C000008003000000000020000030000003C006B0000000900000000000000D9E6B0E91C81D011AD5100A0C90F57397686A891C88BCE119BFD00AA0062BEBF7586A891C88BCE119BFD00AA0062BEBF00002800430000000000000053444DD2011FD1118E63006097D2DF48E89985508ADFD111A2D0006097C4DE2400002800430000000000000051444DD2011FD1118E63006097D2DF48E66BB69F5CB2CF11BAA800AA00A2043018000000080700000098010000007800A509000009000080170000006A0000000180000049000080436F6E74726F6C3233007300481F00007108000052656C6174696F6E736869702027464B5F456D706C6F796565735F456D706C6F7965657327206265747765656E2027456D706C6F796565732720616E642027456D706C6F796565732700000000007000A50900000900008015000000520000000180000041000080436F6E74726F6C3231007300714400004416000052656C6174696F6E736869702027464B5F4F72646572735F536869707065727327206265747765656E202753686970706572732720616E6420274F726465727327706C6F00007800A5090000090000800F00000052000000018000004B000080436F6E74726F6C3135007300DE3200005802000052656C6174696F6E736869702027464B5F4F726465725F44657461696C735F4F726465727327206265747765656E20274F72646572732720616E6420274F726465722044657461696C73270000007000A5090000090000800D000000520000000180000043000080436F6E74726F6C3133007300DE320000E40C000052656C6174696F6E736869702027464B5F4F72646572735F456D706C6F7965657327206265747765656E2027456D706C6F796565732720616E6420274F7264657273274400007800A5090000080000800900000052000000018000004F000080436F6E74726F6C394A2100001A04000052656C6174696F6E736869702027504B5F4F726465725F44657461696C735F50726F647563747327206265747765656E202750726F64756374732720616E6420274F726465722044657461696C7327FF00007000A50900000800008006000000520000000180000047000080436F6E74726F6C36B60F00004605000052656C6174696F6E736869702027464B5F50726F64756374735F537570706C6965727327206265747765656E2027537570706C696572732720616E64202750726F6475637473274400007400A50900000800008004000000620000000180000049000080436F6E74726F6C343C0F0000BE12000052656C6174696F6E736869702027464B5F50726F64756374735F43617465676F7269657327206265747765656E202743617465676F726965732720616E64202750726F647563747327000A0000007000A50900000900008012000000520000000180000043000080436F6E74726F6C3138007300714400001A04000052656C6174696F6E736869702027464B5F4F72646572735F437573746F6D65727327206265747765656E2027437573746F6D6572732720616E6420274F7264657273276400002C00B50100000900008005000000310000005F000000028000004444534C6162656C35007300051400004018000000002C00B50100000900008007000000310000005D000000028000004444534C6162656C37007300E21000002107000000002C00B50100000A0000800A0000003100000065000000028000004444534C6162656C3130730076220000F505000000002C00B50100000A0000800E0000003100000059000000028000004444534C6162656C313473000A340000BF0E000000002C00B50100000A000080100000003100000061000000028000004444534C6162656C31367300B72600003304000000002C00B50100000A000080130000003100000059000000028000004444534C6162656C31397300273A0000F505000000002C00B50100000A000080160000003100000057000000028000004444534C6162656C32327300643B00001F18000000002C00B50100000A00008018000000310000005F000000028000004444534C6162656C32347300742000004707000000003800A50900000800008008000000C8020000008000000D000080536368477269643854240000960000004F726465722044657461696C7300610000003400A5090000090000800C000000BA020000008000000600008053636847726964313261696CE8350000960000004F7264657273643100003800A50900000900008011000000C0020000008000000900008053636847726964313761696C7C47000096000000437573746F6D65727361696C00003400A50900000900008014000000BE020000008000000800008053636847726964323061696C7C470000DA160000536869707065727300003000A50900000800008003000000BE02000000800000080000805363684772696433C01200009600000050726F647563747300003400A50900000800008001000000C0020000008000000900008053636847726964312C01000096000000537570706C6965727361696C00003400A50900000800008002000000C2020000008000000A00008053636847726964322C0100003219000043617465676F72696573696C00003800A5090000090000800B000000C0020000008000000900008053636847726964313173696C542400007A0D0000456D706C6F7965657373696C00000000000000000000222C000005000B0047240000AD0E000074200000AD0E0000742000009D090000802500009D090000802500007A0D00000000000002000000C0C0C0000000000000000000000000000000000001000000C8F9A9079432190023210000A30B00009B0F0000A701000028000000000002000B007C470000701700009D450000701700000000000002000000C0C0C0000000000000000000000000000000000001000000E8631B0094321900643B00001F180000180C0000A701000028000000000002000B00E8350000840300000A340000840300000000000002000000C0C0C0000000000000000000000000000000000001000000E0AC160094321900B726000033040000310F0000A701000028000000000002000B000A340000100E0000E8350000100E00000000000002000000C0C0C0000000000000000000000000000000000001000000F8501600943219000A340000BF0E0000550D0000A701000028000000000002000B00762200004605000054240000460500000000000002000000C0C0C000000000000000000000000000000000000100000020EF97079432190076220000F505000054100000A701000028000000000002000B00E210000072060000C0120000720600000000000002000000C0C0C0000000000000000000000000000000000001000000703F180094321900E210000021070000700D0000A701000028000000000004000B0068100000321900006810000091170000561300009117000056130000EA1300000000000002000000C0C0C000000000000000000000000000000000000100000020CF9C07943219009411000040180000930E0000A701000028000000000002000B007C470000460500009D450000460500000000000002000000C0C0C000000000000000000000000000000000000100000020C2960794321900273A0000F5050000550D0000A701000028000000000002020000930E0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61160046004B005F00500072006F00640075006300740073005F00430061007400650067006F00720069006500730002020000700D0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61150046004B005F00500072006F00640075006300740073005F0053007500700070006C0069006500720073000202000054100000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61190050004B005F004F0072006400650072005F00440065007400610069006C0073005F00500072006F006400750063007400730002020000550D0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61130046004B005F004F00720064006500720073005F0045006D0070006C006F00790065006500730002020000310F0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61170046004B005F004F0072006400650072005F00440065007400610069006C0073005F004F007200640065007200730002020000550D0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61130046004B005F004F00720064006500720073005F0043007500730074006F006D0065007200730002020000180C0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61120046004B005F004F00720064006500720073005F0053006800690070007000650072007300020200009B0F0000A7010000020000000000050000800800008001000000150001000000900144420100065461686F6D61160046004B005F0045006D0070006C006F0079006500650073005F0045006D0070006C006F0079006500650073002143341208000000B60F00000F0B00007856341207000000140100004F0072006400650072002000440065007400610069006C007300000000000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000FFFF3E000000FFFF0000000000008100000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFF00000000000082000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000840000000100000000000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C000005100000000000002D010000070000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F00000F0B000000000000050000000500000002000000020000001C010000720600000000000001000000B60F00000F0B000000000000050000000500000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000006000000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F0000000E0000004F0072006400650072002000440065007400610069006C00730000002143341208000000B50F0000F11900007856341207000000140100004F0072006400650072007300000000000000000000000000000000000000000000000000000001008100FFFF000000000000000085000000010000000000000000000000000000000000000000000000000000000000000000000000340100000000000000000000860000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008700000000000000000000000000000000000000000000000000000000000000000000000000000078010000FFFF0000000000008900000000000000000000000000000000000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C0000F1190000000000002D0100000D0000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B50F0000F1190000000000000E0000000C00000002000000020000001C010000720600000000000001000000B60F0000A2160000000000000E0000000C00000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005200000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F000000070000004F007200640065007200730000002143341208000000B60F0000FB14000078563412070000001401000043007500730074006F006D00650072007300000000000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000FFFF3E000000FFFF0000000000008100000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFF000000000000820000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008400000001000000000000000000000000000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C0000F1190000000000002D0100000D0000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F0000FB140000000000000B0000000B00000002000000020000001C010000720600000000000001000000B60F0000FB140000000000000B0000000B00000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005800000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F0000000A00000043007500730074006F006D0065007200730000002143341208000000B60F0000C00700007856341207000000140100005300680069007000700065007200730000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004800210000000000F8021400F80214000000000000000000000000000000000000000000000000000B00000000000000000000000000000085000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C000005100000000000002D010000070000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F0000C007000000000000030000000300000002000000020000001C010000720600000000000001000000B60F0000C007000000000000030000000300000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005600000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F000000090000005300680069007000700065007200730000002143341208000000B60F000054130000785634120700000014010000500072006F0064007500630074007300000000000000000000000000000000000000000000000000000000000B0000000000000000000000000000008400000001000000000000000000000000000000000000000000000000000000000000000B0001008100FFFF00000000000000007C00000000000000000000000000000000000000000000000000000000000000000000000B00000000000000FFFF0000000000000F00000000000000000000000000000000000000000000000000000000000000000000000B000000000000000000000000000000CC0000000000000001000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C00004A180000000000002D0100000C0000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F000054130000000000000A0000000A00000002000000020000001C010000720600000000000001000000B60F000054130000000000000A0000000A00000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005600000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F00000009000000500072006F006400750063007400730000002143341208000000B60F0000A216000078563412070000001401000053007500700070006C0069006500720073000000BB00BC00BD00BE00BF00C000C100C200C300C400C500C600C700C800C900CA00CB00CC00CD00CE00CF00D000D100D200D300D400D500D600D700D800D900DA00DB00DC00DD00DE00DF00E000E100E200E300E400E500E600E700E800E900EA00EB00EC00ED00EE00EF00F000F100F200F300F400F500F600F700F800F900FA00FB00FC00FD00FE00FF0050003000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300030003000300030003000500070006000800060002000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C0000F1190000000000002D0100000D0000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F0000A2160000000000000C0000000C00000002000000020000001C010000720600000000000001000000B60F0000A2160000000000000C0000000C00000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005800000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F0000000A00000053007500700070006C00690065007200730000002143341208000000B60F000068090000785634120700000014010000430061007400650067006F0072006900650073000000000000000000000000000000000000000000000000000B0000000000000000000000000000008400000001000000000000000000000000000000000000000000000000000000000000000B0001008100FFFF00000000000000007C00000000000000000000000000000000000000000000000000000000000000000000000B00000000000000FFFF0000000000000F00000000000000000000000000000000000000000000000000000000000000000000000B000000000000000000000000000000CC0000000000000001000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C000005100000000000002D010000070000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F00006809000000000000040000000400000002000000020000001C010000720600000000000001000000B60F00006809000000000000040000000400000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005A00000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F0000000B000000430061007400650067006F00720069006500730000002143341208000000B60F0000011F000078563412070000001401000045006D0070006C006F0079006500650073000000000000000000000000000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000FFFF3E000000FFFF0000000000008100000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFF00000000000082000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000840000000100000000000000000000000000000000000000F000000060FFFFFF0100000005000000500000002C0000002C0000002C000000580000000000000000000000222C0000F1190000000000002D0100000D0000000B000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A302000065040000910500000000000001000000B60F0000011F000000000000110000000C00000002000000020000001C010000720600000000000001000000B60F0000A216000000000000110000000C00000002000000020000001C010000720600000100000000000000B60F0000CA02000000000000000000000000000002000000020000001C010000720600000000000000000000222C0000F119000000000000000000000D0000000D000000070000001C010000720600004605000058020000EE0200000D0200008403000065040000A30200006504000091050000B00400009E07000078563412040000005800000001000000010000000A0000000000000001000000020000000300000004000000050000000600000007000000080000000900000004000000640062006F0000000A00000045006D0070006C006F0079006500650073000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100FEFF030A0000FFFFFFFF00000000000000000000000000000000190000004D6963726F736F667420466F726D7320322E3020466F726D0010000000456D626564646564204F626A6563740000000000F439B271000000000000000000000000000000000000000000000000000000000000000000000000000000000000000C00000000000000000000000100260000007300630068005F006C006100620065006C0073005F00760069007300690062006C0065000000010000000B0000000600000000000000000000000000000000000000640000000000000000000000000000000000000000000000000020A2970760C5140000000000000000000000000000000000D00200000000A0901800401A920700000000000000000000000000000000D0020000000090E2710C78CE960700000000000000000000000000000000D0020000000098E5710CA0E7710C000000003E0000000101140001000000640062006F00000046004B005F00500072006F00640075006300740073005F00430061007400650067006F00720069006500730000000200000000000000C00200000000E0B9180020CF9C07A0E7710C000000000000000000000000A5030000010000001B650C20AFA907000000003C0000000101140001000000640062006F00000046004B005F00500072006F00640075006300740073005F0053007500700300440064007300530074007200650061006D000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000160002000300000005000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000022000000CC0500000000000053006300680065006D00610020005500440056002000440065006600610075006C0074000000000000000000000000000000000000000000000000000000000026000201FFFFFFFF06000000FFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000003A0000001200000000000000440053005200450046002D0053004300480045004D0041002D0043004F004E00540045004E0054005300000000000000000000000000000000000000000000002C000200FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000003B00000046030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070006C00690065007200730000000200000000000000C00200000000B8D51E00703F180020AFA907000000000000000000000000A5030000010000408B9707001F970700000000000000000000000000000000D00200000000D8288F0C1832A10700000000440000000101140001000000640062006F00000050004B005F004F0072006400650072005F00440065007400610069006C0073005F00500072006F006400750063007400730000000200000000000000C0020000000088BC180020EF97071832A107000000000000000000000000A5030000010000D0961B00C0274C1000000000000000000000000000000000D0020000000040CB9607E033710C00000000000000000000000000000000D00200000000305B190018FF180000000000380000000101140001000000640062006F00000046004B005F004F00720064006500720073005F0045006D0070006C006F00790065006500730000000200000000000000C002000000003033A107F850160018FF1800000000000000000000000000A5030000010000A83D9507403E180000000000400000000101140001000000640062006F00000046004B005F004F0072006400650072005F00440065007400610069006C0073005F004F007200640065007200730000000200000000000000C00200000000C813590CE0AC1600403E1800000000000000000000000000A5030000010000C800160008665A0C00000000000000000000000000000000D00200000000284460101096160000000000380000000100140001000000640062006F00000046004B005F004F00720064006500720073005F0043007500730074006F006D0065007200730000000200000000000000C00200000000303D4C1020C2960710961600000000000000000000000000A503000001000058328B0C70861C0000000000000000000000000000000000D0020000000068911A0088C7140000000000360000000100140001000000640062006F00000046004B005F004F00720064006500720073005F005300680069007000700065007200730000000200000000000000C00200000000C0101900E8631B0088C71400000000000000000000000000A5030000010000581C1B00286F1C00000000003E0000000101140001000000640062006F00000046004B005F0045006D0070006C006F0079006500650073005F0045006D0070006C006F00790065006500730000000200000000000000C0020000000000881800C8F9A907286F1C00000000000000000000000000A50300000100002800000098E5710CA090180090E2710C3200000001000000001B650C20A2970790E2710C4700000046000000D8288F0C90E2710C408B97074300000042000000305B1900D0961B0040CB96073500000060000000A83D950740CB9607408B97073C0000003D00000028446010C800160040CB9607420000004300000068911A0058328B0C40CB96073400000081000000581C1B00D0961B00D0961B00360000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010003000000000000000B0000000A00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000DBE6B0E91C81D011AD5100A0C90F573900000200309C3BF72818BE01020200001048050000000000000000000000000000000000AA010000500072006F00760069006400650072003D00530051004C004F004C004500440042002E0031003B0055007300650072002000490044003D00730061003B0049006E0069007400690061006C00200043006100740061006C006F0067003D004E006F00720074006800770069006E006400430053003B004400610074006100200053006F0075007200630065003D005000450054004500520048005500530046003B004C006F00630061006C00650020004900640065006E007400690066006900650072003D0031003000330033003B0043006F006E006E006500630074002000540069006D0065006F00750074003D00310035003B005500730065002000500072006F00630065006400750072006500200066006F007200200050007200650070006100720065003D0031003B004100750074006F0020005400720061006E0073006C006100740065003D0054007200750065003B005000610063006B00650074002000530069007A0065003D0034003000390036003B0057006F0072006B00730074006100740069006F006E002000490044003D005000450054004500520048005500530045000000008005001C000000520065006C006100740069006F006E00730068006900700073000000000226001400000053007500700070006C006900650072007300000008000000640062006F0000000002260016000000430061007400650067006F007200690065007300000008000000640062006F0000000002260012000000500072006F0064007500630074007300000008000000640062006F000000000226001C0000004F0072006400650072002000440065007400610069006C007300000008000000640062006F000000000226001400000045006D0070006C006F007900650065007300000008000000640062006F000000000226000E0000004F0072006400650072007300000008000000640062006F000000000226001400000043007500730074006F006D00650072007300000008000000640062006F000000000224001200000053006800690070007000650072007300000008000000640062006F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,2)
go
go
set identity_insert "dtproperties" off
go
ALTER TABLE "dtproperties" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "Employees" on
go
ALTER TABLE "Employees" NOCHECK CONSTRAINT ALL
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(1,'Davolio','Nancy','Sales Representative','Ms.','12/08/1968','05/01/1992','507 - 20th Ave. E.
Apt. 2A','Seattle','WA','98122','USA','(206) 555-9857','5467','EmpID1.bmp','Education includes a BA in psychology from Colorado State University.  She also completed "The Art of the Cold Call."  Nancy is a member of Toastmasters International.',2)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(2,'Fuller','Andrew','Vice President, Sales','Dr.','02/19/1952','08/14/1992','908 W. Capital Way','Tacoma','WA','98401','USA','(206) 555-9482','3457','EmpID2.bmp','Andrew received his BTS commercial and a Ph.D. in international marketing from the University of Dallas.  He is fluent in French and Italian and reads German.  He joined the company as a sales representative, was promoted to sales manager and was then named vice president of sales.  Andrew is a member of the Sales Management Roundtable, the Seattle Chamber of Commerce, and the Pacific Rim Importers Association.',NULL)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(3,'Leverling','Janet','Sales Representative','Ms.','08/30/1963','04/01/1992','722 Moss Bay Blvd.','Kirkland','WA','98033','USA','(206) 555-3412','3355','EmpID3.bmp','Janet has a BS degree in chemistry from Boston College).  She has also completed a certificate program in food retailing management.  Janet was hired as a sales associate and was promoted to sales representative.',2)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(4,'Peacock','Margaret','Sales Representative','Mrs.','09/19/1958','05/03/1993','4110 Old Redmond Rd.','Redmond','WA','98052','USA','(206) 555-8122','5176','EmpID4.bmp','Margaret holds a BA in English literature from Concordia College and an MA from the American Institute of Culinary Arts. She was temporarily assigned to the London office before returning to her permanent post in Seattle.',2)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(5,'Buchanan','Steven','Sales Manager','Mr.','03/04/1955','10/17/1993','14 Garrett Hill','London',NULL,'SW1 8JR','UK','(71) 555-4848','3453','EmpID5.bmp','Steven Buchanan graduated from St. Andrews University, Scotland, with a BSC degree.  Upon joining the company as a sales representative, he spent 6 months in an orientation program at the Seattle office and then returned to his permanent post in London, where he was promoted to sales manager.  Mr. Buchanan has completed the courses "Successful Telemarketing" and "International Sales Management."  He is fluent in French.',2)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(6,'Suyama','Michael','Sales Representative','Mr.','07/02/1963','10/17/1993','Coventry House
Miner Rd.','London',NULL,'EC2 7JR','UK','(71) 555-7773','428','EmpID6.bmp','Michael is a graduate of Sussex University (MA, economics) and the University of California at Los Angeles (MBA, marketing).  He has also taken the courses "Multi-Cultural Selling" and "Time Management for the Sales Professional."  He is fluent in Japanese and can read and write French, Portuguese, and Spanish.',5)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(7,'King','Robert','Sales Representative','Mr.','05/29/1960','01/02/1994','Edgeham Hollow
Winchester Way','London',NULL,'RG1 9SP','UK','(71) 555-5598','465','EmpID7.bmp','Robert King served in the Peace Corps and traveled extensively before completing his degree in English at the University of Michigan and then joining the company.  After completing a course entitled "Selling in Europe," he was transferred to the London office.',5)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(8,'Callahan','Laura','Inside Sales Coordinator','Ms.','01/09/1958','03/05/1994','4726 - 11th Ave. N.E.','Seattle','WA','98105','USA','(206) 555-1189','2344','EmpID8.bmp','Laura received a BA in psychology from the University of Washington.  She has also completed a course in business French.  She reads and writes French.',2)
go
INSERT "Employees"("EmployeeID","LastName","FirstName","Title","TitleOfCourtesy","BirthDate","HireDate","Address","City","Region","PostalCode","Country","HomePhone","Extension","Photo","Notes","ReportsTo") VALUES(9,'Dodsworth','Anne','Sales Representative','Ms.','07/02/1969','11/15/1994','7 Houndstooth Rd.','London',NULL,'WG2 7LT','UK','(71) 555-4444','452','EmpID9.bmp','Anne has a BA degree in English from St. Lawrence College.  She is fluent in French and German.',5)
go
go
set identity_insert "Employees" off
go
ALTER TABLE "Employees" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
ALTER TABLE "Order Details" NOCHECK CONSTRAINT ALL
go
INSERT "Order Details" VALUES(10248,11,14,12,0)
INSERT "Order Details" VALUES(10248,42,9.8,10,0)
INSERT "Order Details" VALUES(10248,72,34.8,5,0)
INSERT "Order Details" VALUES(10249,14,18.6,9,0)
INSERT "Order Details" VALUES(10249,51,42.4,40,0)
INSERT "Order Details" VALUES(10250,41,7.7,10,0)
INSERT "Order Details" VALUES(10250,51,42.4,35,0.15)
INSERT "Order Details" VALUES(10250,65,16.8,15,0.15)
INSERT "Order Details" VALUES(10251,22,16.8,6,0.05)
INSERT "Order Details" VALUES(10251,57,15.6,15,0.05)
go
INSERT "Order Details" VALUES(10251,65,16.8,20,0)
INSERT "Order Details" VALUES(10252,20,64.8,40,0.05)
INSERT "Order Details" VALUES(10252,33,2,25,0.05)
INSERT "Order Details" VALUES(10252,60,27.2,40,0)
INSERT "Order Details" VALUES(10253,31,10,20,0)
INSERT "Order Details" VALUES(10253,39,14.4,42,0)
INSERT "Order Details" VALUES(10253,49,16,40,0)
INSERT "Order Details" VALUES(10254,24,3.6,15,0.15)
INSERT "Order Details" VALUES(10254,55,19.2,21,0.15)
INSERT "Order Details" VALUES(10254,74,8,21,0)
go
INSERT "Order Details" VALUES(10255,2,15.2,20,0)
INSERT "Order Details" VALUES(10255,16,13.9,35,0)
INSERT "Order Details" VALUES(10255,36,15.2,25,0)
INSERT "Order Details" VALUES(10255,59,44,30,0)
INSERT "Order Details" VALUES(10256,53,26.2,15,0)
INSERT "Order Details" VALUES(10256,77,10.4,12,0)
INSERT "Order Details" VALUES(10257,27,35.1,25,0)
INSERT "Order Details" VALUES(10257,39,14.4,6,0)
INSERT "Order Details" VALUES(10257,77,10.4,15,0)
INSERT "Order Details" VALUES(10258,2,15.2,50,0.2)
go
INSERT "Order Details" VALUES(10258,5,17,65,0.2)
INSERT "Order Details" VALUES(10258,32,25.6,6,0.2)
INSERT "Order Details" VALUES(10259,21,8,10,0)
INSERT "Order Details" VALUES(10259,37,20.8,1,0)
INSERT "Order Details" VALUES(10260,41,7.7,16,0.25)
INSERT "Order Details" VALUES(10260,57,15.6,50,0)
INSERT "Order Details" VALUES(10260,62,39.4,15,0.25)
INSERT "Order Details" VALUES(10260,70,12,21,0.25)
INSERT "Order Details" VALUES(10261,21,8,20,0)
INSERT "Order Details" VALUES(10261,35,14.4,20,0)
go
INSERT "Order Details" VALUES(10262,5,17,12,0.2)
INSERT "Order Details" VALUES(10262,7,24,15,0)
INSERT "Order Details" VALUES(10262,56,30.4,2,0)
INSERT "Order Details" VALUES(10263,16,13.9,60,0.25)
INSERT "Order Details" VALUES(10263,24,3.6,28,0)
INSERT "Order Details" VALUES(10263,30,20.7,60,0.25)
INSERT "Order Details" VALUES(10263,74,8,36,0.25)
INSERT "Order Details" VALUES(10264,2,15.2,35,0)
INSERT "Order Details" VALUES(10264,41,7.7,25,0.15)
INSERT "Order Details" VALUES(10265,17,31.2,30,0)
go
INSERT "Order Details" VALUES(10265,70,12,20,0)
INSERT "Order Details" VALUES(10266,12,30.4,12,0.05)
INSERT "Order Details" VALUES(10267,40,14.7,50,0)
INSERT "Order Details" VALUES(10267,59,44,70,0.15)
INSERT "Order Details" VALUES(10267,76,14.4,15,0.15)
INSERT "Order Details" VALUES(10268,29,99,10,0)
INSERT "Order Details" VALUES(10268,72,27.8,4,0)
INSERT "Order Details" VALUES(10269,33,2,60,0.05)
INSERT "Order Details" VALUES(10269,72,27.8,20,0.05)
INSERT "Order Details" VALUES(10270,36,15.2,30,0)
go
INSERT "Order Details" VALUES(10270,43,36.8,25,0)
INSERT "Order Details" VALUES(10271,33,2,24,0)
INSERT "Order Details" VALUES(10272,20,64.8,6,0)
INSERT "Order Details" VALUES(10272,31,10,40,0)
INSERT "Order Details" VALUES(10272,72,27.8,24,0)
INSERT "Order Details" VALUES(10273,10,24.8,24,0.05)
INSERT "Order Details" VALUES(10273,31,10,15,0.05)
INSERT "Order Details" VALUES(10273,33,2,20,0)
INSERT "Order Details" VALUES(10273,40,14.7,60,0.05)
INSERT "Order Details" VALUES(10273,76,14.4,33,0.05)
go
INSERT "Order Details" VALUES(10274,71,17.2,20,0)
INSERT "Order Details" VALUES(10274,72,27.8,7,0)
INSERT "Order Details" VALUES(10275,24,3.6,12,0.05)
INSERT "Order Details" VALUES(10275,59,44,6,0.05)
INSERT "Order Details" VALUES(10276,10,24.8,15,0)
INSERT "Order Details" VALUES(10276,13,4.8,10,0)
INSERT "Order Details" VALUES(10277,28,36.4,20,0)
INSERT "Order Details" VALUES(10277,62,39.4,12,0)
INSERT "Order Details" VALUES(10278,44,15.5,16,0)
INSERT "Order Details" VALUES(10278,59,44,15,0)
go
INSERT "Order Details" VALUES(10278,63,35.1,8,0)
INSERT "Order Details" VALUES(10278,73,12,25,0)
INSERT "Order Details" VALUES(10279,17,31.2,15,0.25)
INSERT "Order Details" VALUES(10280,24,3.6,12,0)
INSERT "Order Details" VALUES(10280,55,19.2,20,0)
INSERT "Order Details" VALUES(10280,75,6.2,30,0)
INSERT "Order Details" VALUES(10281,19,7.3,1,0)
INSERT "Order Details" VALUES(10281,24,3.6,6,0)
INSERT "Order Details" VALUES(10281,35,14.4,4,0)
INSERT "Order Details" VALUES(10282,30,20.7,6,0)
go
INSERT "Order Details" VALUES(10282,57,15.6,2,0)
INSERT "Order Details" VALUES(10283,15,12.4,20,0)
INSERT "Order Details" VALUES(10283,19,7.3,18,0)
INSERT "Order Details" VALUES(10283,60,27.2,35,0)
INSERT "Order Details" VALUES(10283,72,27.8,3,0)
INSERT "Order Details" VALUES(10284,27,35.1,15,0.25)
INSERT "Order Details" VALUES(10284,44,15.5,21,0)
INSERT "Order Details" VALUES(10284,60,27.2,20,0.25)
INSERT "Order Details" VALUES(10284,67,11.2,5,0.25)
INSERT "Order Details" VALUES(10285,1,14.4,45,0.2)
go
INSERT "Order Details" VALUES(10285,40,14.7,40,0.2)
INSERT "Order Details" VALUES(10285,53,26.2,36,0.2)
INSERT "Order Details" VALUES(10286,35,14.4,100,0)
INSERT "Order Details" VALUES(10286,62,39.4,40,0)
INSERT "Order Details" VALUES(10287,16,13.9,40,0.15)
INSERT "Order Details" VALUES(10287,34,11.2,20,0)
INSERT "Order Details" VALUES(10287,46,9.6,15,0.15)
INSERT "Order Details" VALUES(10288,54,5.9,10,0.1)
INSERT "Order Details" VALUES(10288,68,10,3,0.1)
INSERT "Order Details" VALUES(10289,3,8,30,0)
go
INSERT "Order Details" VALUES(10289,64,26.6,9,0)
INSERT "Order Details" VALUES(10290,5,17,20,0)
INSERT "Order Details" VALUES(10290,29,99,15,0)
INSERT "Order Details" VALUES(10290,49,16,15,0)
INSERT "Order Details" VALUES(10290,77,10.4,10,0)
INSERT "Order Details" VALUES(10291,13,4.8,20,0.1)
INSERT "Order Details" VALUES(10291,44,15.5,24,0.1)
INSERT "Order Details" VALUES(10291,51,42.4,2,0.1)
INSERT "Order Details" VALUES(10292,20,64.8,20,0)
INSERT "Order Details" VALUES(10293,18,50,12,0)
go
INSERT "Order Details" VALUES(10293,24,3.6,10,0)
INSERT "Order Details" VALUES(10293,63,35.1,5,0)
INSERT "Order Details" VALUES(10293,75,6.2,6,0)
INSERT "Order Details" VALUES(10294,1,14.4,18,0)
INSERT "Order Details" VALUES(10294,17,31.2,15,0)
INSERT "Order Details" VALUES(10294,43,36.8,15,0)
INSERT "Order Details" VALUES(10294,60,27.2,21,0)
INSERT "Order Details" VALUES(10294,75,6.2,6,0)
INSERT "Order Details" VALUES(10295,56,30.4,4,0)
INSERT "Order Details" VALUES(10296,11,16.8,12,0)
go
INSERT "Order Details" VALUES(10296,16,13.9,30,0)
INSERT "Order Details" VALUES(10296,69,28.8,15,0)
INSERT "Order Details" VALUES(10297,39,14.4,60,0)
INSERT "Order Details" VALUES(10297,72,27.8,20,0)
INSERT "Order Details" VALUES(10298,2,15.2,40,0)
INSERT "Order Details" VALUES(10298,36,15.2,40,0.25)
INSERT "Order Details" VALUES(10298,59,44,30,0.25)
INSERT "Order Details" VALUES(10298,62,39.4,15,0)
INSERT "Order Details" VALUES(10299,19,7.3,15,0)
INSERT "Order Details" VALUES(10299,70,12,20,0)
go
INSERT "Order Details" VALUES(10300,66,13.6,30,0)
INSERT "Order Details" VALUES(10300,68,10,20,0)
INSERT "Order Details" VALUES(10301,40,14.7,10,0)
INSERT "Order Details" VALUES(10301,56,30.4,20,0)
INSERT "Order Details" VALUES(10302,17,31.2,40,0)
INSERT "Order Details" VALUES(10302,28,36.4,28,0)
INSERT "Order Details" VALUES(10302,43,36.8,12,0)
INSERT "Order Details" VALUES(10303,40,14.7,40,0.1)
INSERT "Order Details" VALUES(10303,65,16.8,30,0.1)
INSERT "Order Details" VALUES(10303,68,10,15,0.1)
go
INSERT "Order Details" VALUES(10304,49,16,30,0)
INSERT "Order Details" VALUES(10304,59,44,10,0)
INSERT "Order Details" VALUES(10304,71,17.2,2,0)
INSERT "Order Details" VALUES(10305,18,50,25,0.1)
INSERT "Order Details" VALUES(10305,29,99,25,0.1)
INSERT "Order Details" VALUES(10305,39,14.4,30,0.1)
INSERT "Order Details" VALUES(10306,30,20.7,10,0)
INSERT "Order Details" VALUES(10306,53,26.2,10,0)
INSERT "Order Details" VALUES(10306,54,5.9,5,0)
INSERT "Order Details" VALUES(10307,62,39.4,10,0)
go
INSERT "Order Details" VALUES(10307,68,10,3,0)
INSERT "Order Details" VALUES(10308,69,28.8,1,0)
INSERT "Order Details" VALUES(10308,70,12,5,0)
INSERT "Order Details" VALUES(10309,4,17.6,20,0)
INSERT "Order Details" VALUES(10309,6,20,30,0)
INSERT "Order Details" VALUES(10309,42,11.2,2,0)
INSERT "Order Details" VALUES(10309,43,36.8,20,0)
INSERT "Order Details" VALUES(10309,71,17.2,3,0)
INSERT "Order Details" VALUES(10310,16,13.9,10,0)
INSERT "Order Details" VALUES(10310,62,39.4,5,0)
go
INSERT "Order Details" VALUES(10311,42,11.2,6,0)
INSERT "Order Details" VALUES(10311,69,28.8,7,0)
INSERT "Order Details" VALUES(10312,28,36.4,4,0)
INSERT "Order Details" VALUES(10312,43,36.8,24,0)
INSERT "Order Details" VALUES(10312,53,26.2,20,0)
INSERT "Order Details" VALUES(10312,75,6.2,10,0)
INSERT "Order Details" VALUES(10313,36,15.2,12,0)
INSERT "Order Details" VALUES(10314,32,25.6,40,0.1)
INSERT "Order Details" VALUES(10314,58,10.6,30,0.1)
INSERT "Order Details" VALUES(10314,62,39.4,25,0.1)
go
INSERT "Order Details" VALUES(10315,34,11.2,14,0)
INSERT "Order Details" VALUES(10315,70,12,30,0)
INSERT "Order Details" VALUES(10316,41,7.7,10,0)
INSERT "Order Details" VALUES(10316,62,39.4,70,0)
INSERT "Order Details" VALUES(10317,1,14.4,20,0)
INSERT "Order Details" VALUES(10318,41,7.7,20,0)
INSERT "Order Details" VALUES(10318,76,14.4,6,0)
INSERT "Order Details" VALUES(10319,17,31.2,8,0)
INSERT "Order Details" VALUES(10319,28,36.4,14,0)
INSERT "Order Details" VALUES(10319,76,14.4,30,0)
go
INSERT "Order Details" VALUES(10320,71,17.2,30,0)
INSERT "Order Details" VALUES(10321,35,14.4,10,0)
INSERT "Order Details" VALUES(10322,52,5.6,20,0)
INSERT "Order Details" VALUES(10323,15,12.4,5,0)
INSERT "Order Details" VALUES(10323,25,11.2,4,0)
INSERT "Order Details" VALUES(10323,39,14.4,4,0)
INSERT "Order Details" VALUES(10324,16,13.9,21,0.15)
INSERT "Order Details" VALUES(10324,35,14.4,70,0.15)
INSERT "Order Details" VALUES(10324,46,9.6,30,0)
INSERT "Order Details" VALUES(10324,59,44,40,0.15)
go
INSERT "Order Details" VALUES(10324,63,35.1,80,0.15)
INSERT "Order Details" VALUES(10325,6,20,6,0)
INSERT "Order Details" VALUES(10325,13,4.8,12,0)
INSERT "Order Details" VALUES(10325,14,18.6,9,0)
INSERT "Order Details" VALUES(10325,31,10,4,0)
INSERT "Order Details" VALUES(10325,72,27.8,40,0)
INSERT "Order Details" VALUES(10326,4,17.6,24,0)
INSERT "Order Details" VALUES(10326,57,15.6,16,0)
INSERT "Order Details" VALUES(10326,75,6.2,50,0)
INSERT "Order Details" VALUES(10327,2,15.2,25,0.2)
go
INSERT "Order Details" VALUES(10327,11,16.8,50,0.2)
INSERT "Order Details" VALUES(10327,30,20.7,35,0.2)
INSERT "Order Details" VALUES(10327,58,10.6,30,0.2)
INSERT "Order Details" VALUES(10328,59,44,9,0)
INSERT "Order Details" VALUES(10328,65,16.8,40,0)
INSERT "Order Details" VALUES(10328,68,10,10,0)
INSERT "Order Details" VALUES(10329,19,7.3,10,0.05)
INSERT "Order Details" VALUES(10329,30,20.7,8,0.05)
INSERT "Order Details" VALUES(10329,38,210.8,20,0.05)
INSERT "Order Details" VALUES(10329,56,30.4,12,0.05)
go
INSERT "Order Details" VALUES(10330,26,24.9,50,0.15)
INSERT "Order Details" VALUES(10330,72,27.8,25,0.15)
INSERT "Order Details" VALUES(10331,54,5.9,15,0)
INSERT "Order Details" VALUES(10332,18,50,40,0.2)
INSERT "Order Details" VALUES(10332,42,11.2,10,0.2)
INSERT "Order Details" VALUES(10332,47,7.6,16,0.2)
INSERT "Order Details" VALUES(10333,14,18.6,10,0)
INSERT "Order Details" VALUES(10333,21,8,10,0.1)
INSERT "Order Details" VALUES(10333,71,17.2,40,0.1)
INSERT "Order Details" VALUES(10334,52,5.6,8,0)
go
INSERT "Order Details" VALUES(10334,68,10,10,0)
INSERT "Order Details" VALUES(10335,2,15.2,7,0.2)
INSERT "Order Details" VALUES(10335,31,10,25,0.2)
INSERT "Order Details" VALUES(10335,32,25.6,6,0.2)
INSERT "Order Details" VALUES(10335,51,42.4,48,0.2)
INSERT "Order Details" VALUES(10336,4,17.6,18,0.1)
INSERT "Order Details" VALUES(10337,23,7.2,40,0)
INSERT "Order Details" VALUES(10337,26,24.9,24,0)
INSERT "Order Details" VALUES(10337,36,15.2,20,0)
INSERT "Order Details" VALUES(10337,37,20.8,28,0)
go
INSERT "Order Details" VALUES(10337,72,27.8,25,0)
INSERT "Order Details" VALUES(10338,17,31.2,20,0)
INSERT "Order Details" VALUES(10338,30,20.7,15,0)
INSERT "Order Details" VALUES(10339,4,17.6,10,0)
INSERT "Order Details" VALUES(10339,17,31.2,70,0.05)
INSERT "Order Details" VALUES(10339,62,39.4,28,0)
INSERT "Order Details" VALUES(10340,18,50,20,0.05)
INSERT "Order Details" VALUES(10340,41,7.7,12,0.05)
INSERT "Order Details" VALUES(10340,43,36.8,40,0.05)
INSERT "Order Details" VALUES(10341,33,2,8,0)
go
INSERT "Order Details" VALUES(10341,59,44,9,0.15)
INSERT "Order Details" VALUES(10342,2,15.2,24,0.2)
INSERT "Order Details" VALUES(10342,31,10,56,0.2)
INSERT "Order Details" VALUES(10342,36,15.2,40,0.2)
INSERT "Order Details" VALUES(10342,55,19.2,40,0.2)
INSERT "Order Details" VALUES(10343,64,26.6,50,0)
INSERT "Order Details" VALUES(10343,68,10,4,0.05)
INSERT "Order Details" VALUES(10343,76,14.4,15,0)
INSERT "Order Details" VALUES(10344,4,17.6,35,0)
INSERT "Order Details" VALUES(10344,8,32,70,0.25)
go
INSERT "Order Details" VALUES(10345,8,32,70,0)
INSERT "Order Details" VALUES(10345,19,7.3,80,0)
INSERT "Order Details" VALUES(10345,42,11.2,9,0)
INSERT "Order Details" VALUES(10346,17,31.2,36,0.1)
INSERT "Order Details" VALUES(10346,56,30.4,20,0)
INSERT "Order Details" VALUES(10347,25,11.2,10,0)
INSERT "Order Details" VALUES(10347,39,14.4,50,0.15)
INSERT "Order Details" VALUES(10347,40,14.7,4,0)
INSERT "Order Details" VALUES(10347,75,6.2,6,0.15)
INSERT "Order Details" VALUES(10348,1,14.4,15,0.15)
go
INSERT "Order Details" VALUES(10348,23,7.2,25,0)
INSERT "Order Details" VALUES(10349,54,5.9,24,0)
INSERT "Order Details" VALUES(10350,50,13,15,0.1)
INSERT "Order Details" VALUES(10350,69,28.8,18,0.1)
INSERT "Order Details" VALUES(10351,38,210.8,20,0.05)
INSERT "Order Details" VALUES(10351,41,7.7,13,0)
INSERT "Order Details" VALUES(10351,44,15.5,77,0.05)
INSERT "Order Details" VALUES(10351,65,16.8,10,0.05)
INSERT "Order Details" VALUES(10352,24,3.6,10,0)
INSERT "Order Details" VALUES(10352,54,5.9,20,0.15)
go
INSERT "Order Details" VALUES(10353,11,16.8,12,0.2)
INSERT "Order Details" VALUES(10353,38,210.8,50,0.2)
INSERT "Order Details" VALUES(10354,1,14.4,12,0)
INSERT "Order Details" VALUES(10354,29,99,4,0)
INSERT "Order Details" VALUES(10355,24,3.6,25,0)
INSERT "Order Details" VALUES(10355,57,15.6,25,0)
INSERT "Order Details" VALUES(10356,31,10,30,0)
INSERT "Order Details" VALUES(10356,55,19.2,12,0)
INSERT "Order Details" VALUES(10356,69,28.8,20,0)
INSERT "Order Details" VALUES(10357,10,24.8,30,0.2)
go
INSERT "Order Details" VALUES(10357,26,24.9,16,0)
INSERT "Order Details" VALUES(10357,60,27.2,8,0.2)
INSERT "Order Details" VALUES(10358,24,3.6,10,0.05)
INSERT "Order Details" VALUES(10358,34,11.2,10,0.05)
INSERT "Order Details" VALUES(10358,36,15.2,20,0.05)
INSERT "Order Details" VALUES(10359,16,13.9,56,0.05)
INSERT "Order Details" VALUES(10359,31,10,70,0.05)
INSERT "Order Details" VALUES(10359,60,27.2,80,0.05)
INSERT "Order Details" VALUES(10360,28,36.4,30,0)
INSERT "Order Details" VALUES(10360,29,99,35,0)
go
INSERT "Order Details" VALUES(10360,38,210.8,10,0)
INSERT "Order Details" VALUES(10360,49,16,35,0)
INSERT "Order Details" VALUES(10360,54,5.9,28,0)
INSERT "Order Details" VALUES(10361,39,14.4,54,0.1)
INSERT "Order Details" VALUES(10361,60,27.2,55,0.1)
INSERT "Order Details" VALUES(10362,25,11.2,50,0)
INSERT "Order Details" VALUES(10362,51,42.4,20,0)
INSERT "Order Details" VALUES(10362,54,5.9,24,0)
INSERT "Order Details" VALUES(10363,31,10,20,0)
INSERT "Order Details" VALUES(10363,75,6.2,12,0)
go
INSERT "Order Details" VALUES(10363,76,14.4,12,0)
INSERT "Order Details" VALUES(10364,69,28.8,30,0)
INSERT "Order Details" VALUES(10364,71,17.2,5,0)
INSERT "Order Details" VALUES(10365,11,16.8,24,0)
INSERT "Order Details" VALUES(10366,65,16.8,5,0)
INSERT "Order Details" VALUES(10366,77,10.4,5,0)
INSERT "Order Details" VALUES(10367,34,11.2,36,0)
INSERT "Order Details" VALUES(10367,54,5.9,18,0)
INSERT "Order Details" VALUES(10367,65,16.8,15,0)
INSERT "Order Details" VALUES(10367,77,10.4,7,0)
go
INSERT "Order Details" VALUES(10368,21,8,5,0.1)
INSERT "Order Details" VALUES(10368,28,36.4,13,0.1)
INSERT "Order Details" VALUES(10368,57,15.6,25,0)
INSERT "Order Details" VALUES(10368,64,26.6,35,0.1)
INSERT "Order Details" VALUES(10369,29,99,20,0)
INSERT "Order Details" VALUES(10369,56,30.4,18,0.25)
INSERT "Order Details" VALUES(10370,1,14.4,15,0.15)
INSERT "Order Details" VALUES(10370,64,26.6,30,0)
INSERT "Order Details" VALUES(10370,74,8,20,0.15)
INSERT "Order Details" VALUES(10371,36,15.2,6,0.2)
go
INSERT "Order Details" VALUES(10372,20,64.8,12,0.25)
INSERT "Order Details" VALUES(10372,38,210.8,40,0.25)
INSERT "Order Details" VALUES(10372,60,27.2,70,0.25)
INSERT "Order Details" VALUES(10372,72,27.8,42,0.25)
INSERT "Order Details" VALUES(10373,58,10.6,80,0.2)
INSERT "Order Details" VALUES(10373,71,17.2,50,0.2)
INSERT "Order Details" VALUES(10374,31,10,30,0)
INSERT "Order Details" VALUES(10374,58,10.6,15,0)
INSERT "Order Details" VALUES(10375,14,18.6,15,0)
INSERT "Order Details" VALUES(10375,54,5.9,10,0)
go
INSERT "Order Details" VALUES(10376,31,10,42,0.05)
INSERT "Order Details" VALUES(10377,28,36.4,20,0.15)
INSERT "Order Details" VALUES(10377,39,14.4,20,0.15)
INSERT "Order Details" VALUES(10378,71,17.2,6,0)
INSERT "Order Details" VALUES(10379,41,7.7,8,0.1)
INSERT "Order Details" VALUES(10379,63,35.1,16,0.1)
INSERT "Order Details" VALUES(10379,65,16.8,20,0.1)
INSERT "Order Details" VALUES(10380,30,20.7,18,0.1)
INSERT "Order Details" VALUES(10380,53,26.2,20,0.1)
INSERT "Order Details" VALUES(10380,60,27.2,6,0.1)
go
INSERT "Order Details" VALUES(10380,70,12,30,0)
INSERT "Order Details" VALUES(10381,74,8,14,0)
INSERT "Order Details" VALUES(10382,5,17,32,0)
INSERT "Order Details" VALUES(10382,18,50,9,0)
INSERT "Order Details" VALUES(10382,29,99,14,0)
INSERT "Order Details" VALUES(10382,33,2,60,0)
INSERT "Order Details" VALUES(10382,74,8,50,0)
INSERT "Order Details" VALUES(10383,13,4.8,20,0)
INSERT "Order Details" VALUES(10383,50,13,15,0)
INSERT "Order Details" VALUES(10383,56,30.4,20,0)
go
INSERT "Order Details" VALUES(10384,20,64.8,28,0)
INSERT "Order Details" VALUES(10384,60,27.2,15,0)
INSERT "Order Details" VALUES(10385,7,24,10,0.2)
INSERT "Order Details" VALUES(10385,60,27.2,20,0.2)
INSERT "Order Details" VALUES(10385,68,10,8,0.2)
INSERT "Order Details" VALUES(10386,24,3.6,15,0)
INSERT "Order Details" VALUES(10386,34,11.2,10,0)
INSERT "Order Details" VALUES(10387,24,3.6,15,0)
INSERT "Order Details" VALUES(10387,28,36.4,6,0)
INSERT "Order Details" VALUES(10387,59,44,12,0)
go
INSERT "Order Details" VALUES(10387,71,17.2,15,0)
INSERT "Order Details" VALUES(10388,45,7.6,15,0.2)
INSERT "Order Details" VALUES(10388,52,5.6,20,0.2)
INSERT "Order Details" VALUES(10388,53,26.2,40,0)
INSERT "Order Details" VALUES(10389,10,24.8,16,0)
INSERT "Order Details" VALUES(10389,55,19.2,15,0)
INSERT "Order Details" VALUES(10389,62,39.4,20,0)
INSERT "Order Details" VALUES(10389,70,12,30,0)
INSERT "Order Details" VALUES(10390,31,10,60,0.1)
INSERT "Order Details" VALUES(10390,35,14.4,40,0.1)
go
INSERT "Order Details" VALUES(10390,46,9.6,45,0)
INSERT "Order Details" VALUES(10390,72,27.8,24,0.1)
INSERT "Order Details" VALUES(10391,13,4.8,18,0)
INSERT "Order Details" VALUES(10392,69,28.8,50,0)
INSERT "Order Details" VALUES(10393,2,15.2,25,0.25)
INSERT "Order Details" VALUES(10393,14,18.6,42,0.25)
INSERT "Order Details" VALUES(10393,25,11.2,7,0.25)
INSERT "Order Details" VALUES(10393,26,24.9,70,0.25)
INSERT "Order Details" VALUES(10393,31,10,32,0)
INSERT "Order Details" VALUES(10394,13,4.8,10,0)
go
INSERT "Order Details" VALUES(10394,62,39.4,10,0)
INSERT "Order Details" VALUES(10395,46,9.6,28,0.1)
INSERT "Order Details" VALUES(10395,53,26.2,70,0.1)
INSERT "Order Details" VALUES(10395,69,28.8,8,0)
INSERT "Order Details" VALUES(10396,23,7.2,40,0)
INSERT "Order Details" VALUES(10396,71,17.2,60,0)
INSERT "Order Details" VALUES(10396,72,27.8,21,0)
INSERT "Order Details" VALUES(10397,21,8,10,0.15)
INSERT "Order Details" VALUES(10397,51,42.4,18,0.15)
INSERT "Order Details" VALUES(10398,35,14.4,30,0)
go
INSERT "Order Details" VALUES(10398,55,19.2,120,0.1)
INSERT "Order Details" VALUES(10399,68,10,60,0)
INSERT "Order Details" VALUES(10399,71,17.2,30,0)
INSERT "Order Details" VALUES(10399,76,14.4,35,0)
INSERT "Order Details" VALUES(10399,77,10.4,14,0)
INSERT "Order Details" VALUES(10400,29,99,21,0)
INSERT "Order Details" VALUES(10400,35,14.4,35,0)
INSERT "Order Details" VALUES(10400,49,16,30,0)
INSERT "Order Details" VALUES(10401,30,20.7,18,0)
INSERT "Order Details" VALUES(10401,56,30.4,70,0)
go
INSERT "Order Details" VALUES(10401,65,16.8,20,0)
INSERT "Order Details" VALUES(10401,71,17.2,60,0)
INSERT "Order Details" VALUES(10402,23,7.2,60,0)
INSERT "Order Details" VALUES(10402,63,35.1,65,0)
INSERT "Order Details" VALUES(10403,16,13.9,21,0.15)
INSERT "Order Details" VALUES(10403,48,10.2,70,0.15)
INSERT "Order Details" VALUES(10404,26,24.9,30,0.05)
INSERT "Order Details" VALUES(10404,42,11.2,40,0.05)
INSERT "Order Details" VALUES(10404,49,16,30,0.05)
INSERT "Order Details" VALUES(10405,3,8,50,0)
go
INSERT "Order Details" VALUES(10406,1,14.4,10,0)
INSERT "Order Details" VALUES(10406,21,8,30,0.1)
INSERT "Order Details" VALUES(10406,28,36.4,42,0.1)
INSERT "Order Details" VALUES(10406,36,15.2,5,0.1)
INSERT "Order Details" VALUES(10406,40,14.7,2,0.1)
INSERT "Order Details" VALUES(10407,11,16.8,30,0)
INSERT "Order Details" VALUES(10407,69,28.8,15,0)
INSERT "Order Details" VALUES(10407,71,17.2,15,0)
INSERT "Order Details" VALUES(10408,37,20.8,10,0)
INSERT "Order Details" VALUES(10408,54,5.9,6,0)
go
INSERT "Order Details" VALUES(10408,62,39.4,35,0)
INSERT "Order Details" VALUES(10409,14,18.6,12,0)
INSERT "Order Details" VALUES(10409,21,8,12,0)
INSERT "Order Details" VALUES(10410,33,2,49,0)
INSERT "Order Details" VALUES(10410,59,44,16,0)
INSERT "Order Details" VALUES(10411,41,7.7,25,0.2)
INSERT "Order Details" VALUES(10411,44,15.5,40,0.2)
INSERT "Order Details" VALUES(10411,59,44,9,0.2)
INSERT "Order Details" VALUES(10412,14,18.6,20,0.1)
INSERT "Order Details" VALUES(10413,1,14.4,24,0)
go
INSERT "Order Details" VALUES(10413,62,39.4,40,0)
INSERT "Order Details" VALUES(10413,76,14.4,14,0)
INSERT "Order Details" VALUES(10414,19,7.3,18,0.05)
INSERT "Order Details" VALUES(10414,33,2,50,0)
INSERT "Order Details" VALUES(10415,17,31.2,2,0)
INSERT "Order Details" VALUES(10415,33,2,20,0)
INSERT "Order Details" VALUES(10416,19,7.3,20,0)
INSERT "Order Details" VALUES(10416,53,26.2,10,0)
INSERT "Order Details" VALUES(10416,57,15.6,20,0)
INSERT "Order Details" VALUES(10417,38,210.8,50,0)
go
INSERT "Order Details" VALUES(10417,46,9.6,2,0.25)
INSERT "Order Details" VALUES(10417,68,10,36,0.25)
INSERT "Order Details" VALUES(10417,77,10.4,35,0)
INSERT "Order Details" VALUES(10418,2,15.2,60,0)
INSERT "Order Details" VALUES(10418,47,7.6,55,0)
INSERT "Order Details" VALUES(10418,61,22.8,16,0)
INSERT "Order Details" VALUES(10418,74,8,15,0)
INSERT "Order Details" VALUES(10419,60,27.2,60,0.05)
INSERT "Order Details" VALUES(10419,69,28.8,20,0.05)
INSERT "Order Details" VALUES(10420,9,77.6,20,0.1)
go
INSERT "Order Details" VALUES(10420,13,4.8,2,0.1)
INSERT "Order Details" VALUES(10420,70,12,8,0.1)
INSERT "Order Details" VALUES(10420,73,12,20,0.1)
INSERT "Order Details" VALUES(10421,19,7.3,4,0.15)
INSERT "Order Details" VALUES(10421,26,24.9,30,0)
INSERT "Order Details" VALUES(10421,53,26.2,15,0.15)
INSERT "Order Details" VALUES(10421,77,10.4,10,0.15)
INSERT "Order Details" VALUES(10422,26,24.9,2,0)
INSERT "Order Details" VALUES(10423,31,10,14,0)
INSERT "Order Details" VALUES(10423,59,44,20,0)
go
INSERT "Order Details" VALUES(10424,35,14.4,60,0.2)
INSERT "Order Details" VALUES(10424,38,210.8,49,0.2)
INSERT "Order Details" VALUES(10424,68,10,30,0.2)
INSERT "Order Details" VALUES(10425,55,19.2,10,0.25)
INSERT "Order Details" VALUES(10425,76,14.4,20,0.25)
INSERT "Order Details" VALUES(10426,56,30.4,5,0)
INSERT "Order Details" VALUES(10426,64,26.6,7,0)
INSERT "Order Details" VALUES(10427,14,18.6,35,0)
INSERT "Order Details" VALUES(10428,46,9.6,20,0)
INSERT "Order Details" VALUES(10429,50,13,40,0)
go
INSERT "Order Details" VALUES(10429,63,35.1,35,0.25)
INSERT "Order Details" VALUES(10430,17,31.2,45,0.2)
INSERT "Order Details" VALUES(10430,21,8,50,0)
INSERT "Order Details" VALUES(10430,56,30.4,30,0)
INSERT "Order Details" VALUES(10430,59,44,70,0.2)
INSERT "Order Details" VALUES(10431,17,31.2,50,0.25)
INSERT "Order Details" VALUES(10431,40,14.7,50,0.25)
INSERT "Order Details" VALUES(10431,47,7.6,30,0.25)
INSERT "Order Details" VALUES(10432,26,24.9,10,0)
INSERT "Order Details" VALUES(10432,54,5.9,40,0)
go
INSERT "Order Details" VALUES(10433,56,30.4,28,0)
INSERT "Order Details" VALUES(10434,11,16.8,6,0)
INSERT "Order Details" VALUES(10434,76,14.4,18,0.15)
INSERT "Order Details" VALUES(10435,2,15.2,10,0)
INSERT "Order Details" VALUES(10435,22,16.8,12,0)
INSERT "Order Details" VALUES(10435,72,27.8,10,0)
INSERT "Order Details" VALUES(10436,46,9.6,5,0)
INSERT "Order Details" VALUES(10436,56,30.4,40,0.1)
INSERT "Order Details" VALUES(10436,64,26.6,30,0.1)
INSERT "Order Details" VALUES(10436,75,6.2,24,0.1)
go
INSERT "Order Details" VALUES(10437,53,26.2,15,0)
INSERT "Order Details" VALUES(10438,19,7.3,15,0.2)
INSERT "Order Details" VALUES(10438,34,11.2,20,0.2)
INSERT "Order Details" VALUES(10438,57,15.6,15,0.2)
INSERT "Order Details" VALUES(10439,12,30.4,15,0)
INSERT "Order Details" VALUES(10439,16,13.9,16,0)
INSERT "Order Details" VALUES(10439,64,26.6,6,0)
INSERT "Order Details" VALUES(10439,74,8,30,0)
INSERT "Order Details" VALUES(10440,2,15.2,45,0.15)
INSERT "Order Details" VALUES(10440,16,13.9,49,0.15)
go
INSERT "Order Details" VALUES(10440,29,99,24,0.15)
INSERT "Order Details" VALUES(10440,61,22.8,90,0.15)
INSERT "Order Details" VALUES(10441,27,35.1,50,0)
INSERT "Order Details" VALUES(10442,11,16.8,30,0)
INSERT "Order Details" VALUES(10442,54,5.9,80,0)
INSERT "Order Details" VALUES(10442,66,13.6,60,0)
INSERT "Order Details" VALUES(10443,11,16.8,6,0.2)
INSERT "Order Details" VALUES(10443,28,36.4,12,0)
INSERT "Order Details" VALUES(10444,17,31.2,10,0)
INSERT "Order Details" VALUES(10444,26,24.9,15,0)
go
INSERT "Order Details" VALUES(10444,35,14.4,8,0)
INSERT "Order Details" VALUES(10444,41,7.7,30,0)
INSERT "Order Details" VALUES(10445,39,14.4,6,0)
INSERT "Order Details" VALUES(10445,54,5.9,15,0)
INSERT "Order Details" VALUES(10446,19,7.3,12,0.1)
INSERT "Order Details" VALUES(10446,24,3.6,20,0.1)
INSERT "Order Details" VALUES(10446,31,10,3,0.1)
INSERT "Order Details" VALUES(10446,52,5.6,15,0.1)
INSERT "Order Details" VALUES(10447,19,7.3,40,0)
INSERT "Order Details" VALUES(10447,65,16.8,35,0)
go
INSERT "Order Details" VALUES(10447,71,17.2,2,0)
INSERT "Order Details" VALUES(10448,26,24.9,6,0)
INSERT "Order Details" VALUES(10448,40,14.7,20,0)
INSERT "Order Details" VALUES(10449,10,24.8,14,0)
INSERT "Order Details" VALUES(10449,52,5.6,20,0)
INSERT "Order Details" VALUES(10449,62,39.4,35,0)
INSERT "Order Details" VALUES(10450,10,24.8,20,0.2)
INSERT "Order Details" VALUES(10450,54,5.9,6,0.2)
INSERT "Order Details" VALUES(10451,55,19.2,120,0.1)
INSERT "Order Details" VALUES(10451,64,26.6,35,0.1)
go
INSERT "Order Details" VALUES(10451,65,16.8,28,0.1)
INSERT "Order Details" VALUES(10451,77,10.4,55,0.1)
INSERT "Order Details" VALUES(10452,28,36.4,15,0)
INSERT "Order Details" VALUES(10452,44,15.5,100,0.05)
INSERT "Order Details" VALUES(10453,48,10.2,15,0.1)
INSERT "Order Details" VALUES(10453,70,12,25,0.1)
INSERT "Order Details" VALUES(10454,16,13.9,20,0.2)
INSERT "Order Details" VALUES(10454,33,2,20,0.2)
INSERT "Order Details" VALUES(10454,46,9.6,10,0.2)
INSERT "Order Details" VALUES(10455,39,14.4,20,0)
go
INSERT "Order Details" VALUES(10455,53,26.2,50,0)
INSERT "Order Details" VALUES(10455,61,22.8,25,0)
INSERT "Order Details" VALUES(10455,71,17.2,30,0)
INSERT "Order Details" VALUES(10456,21,8,40,0.15)
INSERT "Order Details" VALUES(10456,49,16,21,0.15)
INSERT "Order Details" VALUES(10457,59,44,36,0)
INSERT "Order Details" VALUES(10458,26,24.9,30,0)
INSERT "Order Details" VALUES(10458,28,36.4,30,0)
INSERT "Order Details" VALUES(10458,43,36.8,20,0)
INSERT "Order Details" VALUES(10458,56,30.4,15,0)
go
INSERT "Order Details" VALUES(10458,71,17.2,50,0)
INSERT "Order Details" VALUES(10459,7,24,16,0.05)
INSERT "Order Details" VALUES(10459,46,9.6,20,0.05)
INSERT "Order Details" VALUES(10459,72,27.8,40,0)
INSERT "Order Details" VALUES(10460,68,10,21,0.25)
INSERT "Order Details" VALUES(10460,75,6.2,4,0.25)
INSERT "Order Details" VALUES(10461,21,8,40,0.25)
INSERT "Order Details" VALUES(10461,30,20.7,28,0.25)
INSERT "Order Details" VALUES(10461,55,19.2,60,0.25)
INSERT "Order Details" VALUES(10462,13,4.8,1,0)
go
INSERT "Order Details" VALUES(10462,23,7.2,21,0)
INSERT "Order Details" VALUES(10463,19,7.3,21,0)
INSERT "Order Details" VALUES(10463,42,11.2,50,0)
INSERT "Order Details" VALUES(10464,4,17.6,16,0.2)
INSERT "Order Details" VALUES(10464,43,36.8,3,0)
INSERT "Order Details" VALUES(10464,56,30.4,30,0.2)
INSERT "Order Details" VALUES(10464,60,27.2,20,0)
INSERT "Order Details" VALUES(10465,24,3.6,25,0)
INSERT "Order Details" VALUES(10465,29,99,18,0.1)
INSERT "Order Details" VALUES(10465,40,14.7,20,0)
go
INSERT "Order Details" VALUES(10465,45,7.6,30,0.1)
INSERT "Order Details" VALUES(10465,50,13,25,0)
INSERT "Order Details" VALUES(10466,11,16.8,10,0)
INSERT "Order Details" VALUES(10466,46,9.6,5,0)
INSERT "Order Details" VALUES(10467,24,3.6,28,0)
INSERT "Order Details" VALUES(10467,25,11.2,12,0)
INSERT "Order Details" VALUES(10468,30,20.7,8,0)
INSERT "Order Details" VALUES(10468,43,36.8,15,0)
INSERT "Order Details" VALUES(10469,2,15.2,40,0.15)
INSERT "Order Details" VALUES(10469,16,13.9,35,0.15)
go
INSERT "Order Details" VALUES(10469,44,15.5,2,0.15)
INSERT "Order Details" VALUES(10470,18,50,30,0)
INSERT "Order Details" VALUES(10470,23,7.2,15,0)
INSERT "Order Details" VALUES(10470,64,26.6,8,0)
INSERT "Order Details" VALUES(10471,7,24,30,0)
INSERT "Order Details" VALUES(10471,56,30.4,20,0)
INSERT "Order Details" VALUES(10472,24,3.6,80,0.05)
INSERT "Order Details" VALUES(10472,51,42.4,18,0)
INSERT "Order Details" VALUES(10473,33,2,12,0)
INSERT "Order Details" VALUES(10473,71,17.2,12,0)
go
INSERT "Order Details" VALUES(10474,14,18.6,12,0)
INSERT "Order Details" VALUES(10474,28,36.4,18,0)
INSERT "Order Details" VALUES(10474,40,14.7,21,0)
INSERT "Order Details" VALUES(10474,75,6.2,10,0)
INSERT "Order Details" VALUES(10475,31,10,35,0.15)
INSERT "Order Details" VALUES(10475,66,13.6,60,0.15)
INSERT "Order Details" VALUES(10475,76,14.4,42,0.15)
INSERT "Order Details" VALUES(10476,55,19.2,2,0.05)
INSERT "Order Details" VALUES(10476,70,12,12,0)
INSERT "Order Details" VALUES(10477,1,14.4,15,0)
go
INSERT "Order Details" VALUES(10477,21,8,21,0.25)
INSERT "Order Details" VALUES(10477,39,14.4,20,0.25)
INSERT "Order Details" VALUES(10478,10,24.8,20,0.05)
INSERT "Order Details" VALUES(10479,38,210.8,30,0)
INSERT "Order Details" VALUES(10479,53,26.2,28,0)
INSERT "Order Details" VALUES(10479,59,44,60,0)
INSERT "Order Details" VALUES(10479,64,26.6,30,0)
INSERT "Order Details" VALUES(10480,47,7.6,30,0)
INSERT "Order Details" VALUES(10480,59,44,12,0)
INSERT "Order Details" VALUES(10481,49,16,24,0)
go
INSERT "Order Details" VALUES(10481,60,27.2,40,0)
INSERT "Order Details" VALUES(10482,40,14.7,10,0)
INSERT "Order Details" VALUES(10483,34,11.2,35,0.05)
INSERT "Order Details" VALUES(10483,77,10.4,30,0.05)
INSERT "Order Details" VALUES(10484,21,8,14,0)
INSERT "Order Details" VALUES(10484,40,14.7,10,0)
INSERT "Order Details" VALUES(10484,51,42.4,3,0)
INSERT "Order Details" VALUES(10485,2,15.2,20,0.1)
INSERT "Order Details" VALUES(10485,3,8,20,0.1)
INSERT "Order Details" VALUES(10485,55,19.2,30,0.1)
go
INSERT "Order Details" VALUES(10485,70,12,60,0.1)
INSERT "Order Details" VALUES(10486,11,16.8,5,0)
INSERT "Order Details" VALUES(10486,51,42.4,25,0)
INSERT "Order Details" VALUES(10486,74,8,16,0)
INSERT "Order Details" VALUES(10487,19,7.3,5,0)
INSERT "Order Details" VALUES(10487,26,24.9,30,0)
INSERT "Order Details" VALUES(10487,54,5.9,24,0.25)
INSERT "Order Details" VALUES(10488,59,44,30,0)
INSERT "Order Details" VALUES(10488,73,12,20,0.2)
INSERT "Order Details" VALUES(10489,11,16.8,15,0.25)
go
INSERT "Order Details" VALUES(10489,16,13.9,18,0)
INSERT "Order Details" VALUES(10490,59,44,60,0)
INSERT "Order Details" VALUES(10490,68,10,30,0)
INSERT "Order Details" VALUES(10490,75,6.2,36,0)
INSERT "Order Details" VALUES(10491,44,15.5,15,0.15)
INSERT "Order Details" VALUES(10491,77,10.4,7,0.15)
INSERT "Order Details" VALUES(10492,25,11.2,60,0.05)
INSERT "Order Details" VALUES(10492,42,11.2,20,0.05)
INSERT "Order Details" VALUES(10493,65,16.8,15,0.1)
INSERT "Order Details" VALUES(10493,66,13.6,10,0.1)
go
INSERT "Order Details" VALUES(10493,69,28.8,10,0.1)
INSERT "Order Details" VALUES(10494,56,30.4,30,0)
INSERT "Order Details" VALUES(10495,23,7.2,10,0)
INSERT "Order Details" VALUES(10495,41,7.7,20,0)
INSERT "Order Details" VALUES(10495,77,10.4,5,0)
INSERT "Order Details" VALUES(10496,31,10,20,0.05)
INSERT "Order Details" VALUES(10497,56,30.4,14,0)
INSERT "Order Details" VALUES(10497,72,27.8,25,0)
INSERT "Order Details" VALUES(10497,77,10.4,25,0)
INSERT "Order Details" VALUES(10498,24,4.5,14,0)
go
INSERT "Order Details" VALUES(10498,40,18.4,5,0)
INSERT "Order Details" VALUES(10498,42,14,30,0)
INSERT "Order Details" VALUES(10499,28,45.6,20,0)
INSERT "Order Details" VALUES(10499,49,20,25,0)
INSERT "Order Details" VALUES(10500,15,15.5,12,0.05)
INSERT "Order Details" VALUES(10500,28,45.6,8,0.05)
INSERT "Order Details" VALUES(10501,54,7.45,20,0)
INSERT "Order Details" VALUES(10502,45,9.5,21,0)
INSERT "Order Details" VALUES(10502,53,32.8,6,0)
INSERT "Order Details" VALUES(10502,67,14,30,0)
go
INSERT "Order Details" VALUES(10503,14,23.25,70,0)
INSERT "Order Details" VALUES(10503,65,21.05,20,0)
INSERT "Order Details" VALUES(10504,2,19,12,0)
INSERT "Order Details" VALUES(10504,21,10,12,0)
INSERT "Order Details" VALUES(10504,53,32.8,10,0)
INSERT "Order Details" VALUES(10504,61,28.5,25,0)
INSERT "Order Details" VALUES(10505,62,49.3,3,0)
INSERT "Order Details" VALUES(10506,25,14,18,0.1)
INSERT "Order Details" VALUES(10506,70,15,14,0.1)
INSERT "Order Details" VALUES(10507,43,46,15,0.15)
go
INSERT "Order Details" VALUES(10507,48,12.75,15,0.15)
INSERT "Order Details" VALUES(10508,13,6,10,0)
INSERT "Order Details" VALUES(10508,39,18,10,0)
INSERT "Order Details" VALUES(10509,28,45.6,3,0)
INSERT "Order Details" VALUES(10510,29,123.79,36,0)
INSERT "Order Details" VALUES(10510,75,7.75,36,0.1)
INSERT "Order Details" VALUES(10511,4,22,50,0.15)
INSERT "Order Details" VALUES(10511,7,30,50,0.15)
INSERT "Order Details" VALUES(10511,8,40,10,0.15)
INSERT "Order Details" VALUES(10512,24,4.5,10,0.15)
go
INSERT "Order Details" VALUES(10512,46,12,9,0.15)
INSERT "Order Details" VALUES(10512,47,9.5,6,0.15)
INSERT "Order Details" VALUES(10512,60,34,12,0.15)
INSERT "Order Details" VALUES(10513,21,10,40,0.2)
INSERT "Order Details" VALUES(10513,32,32,50,0.2)
INSERT "Order Details" VALUES(10513,61,28.5,15,0.2)
INSERT "Order Details" VALUES(10514,20,81,39,0)
INSERT "Order Details" VALUES(10514,28,45.6,35,0)
INSERT "Order Details" VALUES(10514,56,38,70,0)
INSERT "Order Details" VALUES(10514,65,21.05,39,0)
go
INSERT "Order Details" VALUES(10514,75,7.75,50,0)
INSERT "Order Details" VALUES(10515,9,97,16,0.15)
INSERT "Order Details" VALUES(10515,16,17.45,50,0)
INSERT "Order Details" VALUES(10515,27,43.9,120,0)
INSERT "Order Details" VALUES(10515,33,2.5,16,0.15)
INSERT "Order Details" VALUES(10515,60,34,84,0.15)
INSERT "Order Details" VALUES(10516,18,62.5,25,0.1)
INSERT "Order Details" VALUES(10516,41,9.65,80,0.1)
INSERT "Order Details" VALUES(10516,42,14,20,0)
INSERT "Order Details" VALUES(10517,52,7,6,0)
go
INSERT "Order Details" VALUES(10517,59,55,4,0)
INSERT "Order Details" VALUES(10517,70,15,6,0)
INSERT "Order Details" VALUES(10518,24,4.5,5,0)
INSERT "Order Details" VALUES(10518,38,263.5,15,0)
INSERT "Order Details" VALUES(10518,44,19.45,9,0)
INSERT "Order Details" VALUES(10519,10,31,16,0.05)
INSERT "Order Details" VALUES(10519,56,38,40,0)
INSERT "Order Details" VALUES(10519,60,34,10,0.05)
INSERT "Order Details" VALUES(10520,24,4.5,8,0)
INSERT "Order Details" VALUES(10520,53,32.8,5,0)
go
INSERT "Order Details" VALUES(10521,35,18,3,0)
INSERT "Order Details" VALUES(10521,41,9.65,10,0)
INSERT "Order Details" VALUES(10521,68,12.5,6,0)
INSERT "Order Details" VALUES(10522,1,18,40,0.2)
INSERT "Order Details" VALUES(10522,8,40,24,0)
INSERT "Order Details" VALUES(10522,30,25.89,20,0.2)
INSERT "Order Details" VALUES(10522,40,18.4,25,0.2)
INSERT "Order Details" VALUES(10523,17,39,25,0.1)
INSERT "Order Details" VALUES(10523,20,81,15,0.1)
INSERT "Order Details" VALUES(10523,37,26,18,0.1)
go
INSERT "Order Details" VALUES(10523,41,9.65,6,0.1)
INSERT "Order Details" VALUES(10524,10,31,2,0)
INSERT "Order Details" VALUES(10524,30,25.89,10,0)
INSERT "Order Details" VALUES(10524,43,46,60,0)
INSERT "Order Details" VALUES(10524,54,7.45,15,0)
INSERT "Order Details" VALUES(10525,36,19,30,0)
INSERT "Order Details" VALUES(10525,40,18.4,15,0.1)
INSERT "Order Details" VALUES(10526,1,18,8,0.15)
INSERT "Order Details" VALUES(10526,13,6,10,0)
INSERT "Order Details" VALUES(10526,56,38,30,0.15)
go
INSERT "Order Details" VALUES(10527,4,22,50,0.1)
INSERT "Order Details" VALUES(10527,36,19,30,0.1)
INSERT "Order Details" VALUES(10528,11,21,3,0)
INSERT "Order Details" VALUES(10528,33,2.5,8,0.2)
INSERT "Order Details" VALUES(10528,72,34.8,9,0)
INSERT "Order Details" VALUES(10529,55,24,14,0)
INSERT "Order Details" VALUES(10529,68,12.5,20,0)
INSERT "Order Details" VALUES(10529,69,36,10,0)
INSERT "Order Details" VALUES(10530,17,39,40,0)
INSERT "Order Details" VALUES(10530,43,46,25,0)
go
INSERT "Order Details" VALUES(10530,61,28.5,20,0)
INSERT "Order Details" VALUES(10530,76,18,50,0)
INSERT "Order Details" VALUES(10531,59,55,2,0)
INSERT "Order Details" VALUES(10532,30,25.89,15,0)
INSERT "Order Details" VALUES(10532,66,17,24,0)
INSERT "Order Details" VALUES(10533,4,22,50,0.05)
INSERT "Order Details" VALUES(10533,72,34.8,24,0)
INSERT "Order Details" VALUES(10533,73,15,24,0.05)
INSERT "Order Details" VALUES(10534,30,25.89,10,0)
INSERT "Order Details" VALUES(10534,40,18.4,10,0.2)
go
INSERT "Order Details" VALUES(10534,54,7.45,10,0.2)
INSERT "Order Details" VALUES(10535,11,21,50,0.1)
INSERT "Order Details" VALUES(10535,40,18.4,10,0.1)
INSERT "Order Details" VALUES(10535,57,19.5,5,0.1)
INSERT "Order Details" VALUES(10535,59,55,15,0.1)
INSERT "Order Details" VALUES(10536,12,38,15,0.25)
INSERT "Order Details" VALUES(10536,31,12.5,20,0)
INSERT "Order Details" VALUES(10536,33,2.5,30,0)
INSERT "Order Details" VALUES(10536,60,34,35,0.25)
INSERT "Order Details" VALUES(10537,31,12.5,30,0)
go
INSERT "Order Details" VALUES(10537,51,53,6,0)
INSERT "Order Details" VALUES(10537,58,13.25,20,0)
INSERT "Order Details" VALUES(10537,72,34.8,21,0)
INSERT "Order Details" VALUES(10537,73,15,9,0)
INSERT "Order Details" VALUES(10538,70,15,7,0)
INSERT "Order Details" VALUES(10538,72,34.8,1,0)
INSERT "Order Details" VALUES(10539,13,6,8,0)
INSERT "Order Details" VALUES(10539,21,10,15,0)
INSERT "Order Details" VALUES(10539,33,2.5,15,0)
INSERT "Order Details" VALUES(10539,49,20,6,0)
go
INSERT "Order Details" VALUES(10540,3,10,60,0)
INSERT "Order Details" VALUES(10540,26,31.23,40,0)
INSERT "Order Details" VALUES(10540,38,263.5,30,0)
INSERT "Order Details" VALUES(10540,68,12.5,35,0)
INSERT "Order Details" VALUES(10541,24,4.5,35,0.1)
INSERT "Order Details" VALUES(10541,38,263.5,4,0.1)
INSERT "Order Details" VALUES(10541,65,21.05,36,0.1)
INSERT "Order Details" VALUES(10541,71,21.5,9,0.1)
INSERT "Order Details" VALUES(10542,11,21,15,0.05)
INSERT "Order Details" VALUES(10542,54,7.45,24,0.05)
go
INSERT "Order Details" VALUES(10543,12,38,30,0.15)
INSERT "Order Details" VALUES(10543,23,9,70,0.15)
INSERT "Order Details" VALUES(10544,28,45.6,7,0)
INSERT "Order Details" VALUES(10544,67,14,7,0)
INSERT "Order Details" VALUES(10545,11,21,10,0)
INSERT "Order Details" VALUES(10546,7,30,10,0)
INSERT "Order Details" VALUES(10546,35,18,30,0)
INSERT "Order Details" VALUES(10546,62,49.3,40,0)
INSERT "Order Details" VALUES(10547,32,32,24,0.15)
INSERT "Order Details" VALUES(10547,36,19,60,0)
go
INSERT "Order Details" VALUES(10548,34,14,10,0.25)
INSERT "Order Details" VALUES(10548,41,9.65,14,0)
INSERT "Order Details" VALUES(10549,31,12.5,55,0.15)
INSERT "Order Details" VALUES(10549,45,9.5,100,0.15)
INSERT "Order Details" VALUES(10549,51,53,48,0.15)
INSERT "Order Details" VALUES(10550,17,39,8,0.1)
INSERT "Order Details" VALUES(10550,19,9.2,10,0)
INSERT "Order Details" VALUES(10550,21,10,6,0.1)
INSERT "Order Details" VALUES(10550,61,28.5,10,0.1)
INSERT "Order Details" VALUES(10551,16,17.45,40,0.15)
go
INSERT "Order Details" VALUES(10551,35,18,20,0.15)
INSERT "Order Details" VALUES(10551,44,19.45,40,0)
INSERT "Order Details" VALUES(10552,69,36,18,0)
INSERT "Order Details" VALUES(10552,75,7.75,30,0)
INSERT "Order Details" VALUES(10553,11,21,15,0)
INSERT "Order Details" VALUES(10553,16,17.45,14,0)
INSERT "Order Details" VALUES(10553,22,21,24,0)
INSERT "Order Details" VALUES(10553,31,12.5,30,0)
INSERT "Order Details" VALUES(10553,35,18,6,0)
INSERT "Order Details" VALUES(10554,16,17.45,30,0.05)
go
INSERT "Order Details" VALUES(10554,23,9,20,0.05)
INSERT "Order Details" VALUES(10554,62,49.3,20,0.05)
INSERT "Order Details" VALUES(10554,77,13,10,0.05)
INSERT "Order Details" VALUES(10555,14,23.25,30,0.2)
INSERT "Order Details" VALUES(10555,19,9.2,35,0.2)
INSERT "Order Details" VALUES(10555,24,4.5,18,0.2)
INSERT "Order Details" VALUES(10555,51,53,20,0.2)
INSERT "Order Details" VALUES(10555,56,38,40,0.2)
INSERT "Order Details" VALUES(10556,72,34.8,24,0)
INSERT "Order Details" VALUES(10557,64,33.25,30,0)
go
INSERT "Order Details" VALUES(10557,75,7.75,20,0)
INSERT "Order Details" VALUES(10558,47,9.5,25,0)
INSERT "Order Details" VALUES(10558,51,53,20,0)
INSERT "Order Details" VALUES(10558,52,7,30,0)
INSERT "Order Details" VALUES(10558,53,32.8,18,0)
INSERT "Order Details" VALUES(10558,73,15,3,0)
INSERT "Order Details" VALUES(10559,41,9.65,12,0.05)
INSERT "Order Details" VALUES(10559,55,24,18,0.05)
INSERT "Order Details" VALUES(10560,30,25.89,20,0)
INSERT "Order Details" VALUES(10560,62,49.3,15,0.25)
go
INSERT "Order Details" VALUES(10561,44,19.45,10,0)
INSERT "Order Details" VALUES(10561,51,53,50,0)
INSERT "Order Details" VALUES(10562,33,2.5,20,0.1)
INSERT "Order Details" VALUES(10562,62,49.3,10,0.1)
INSERT "Order Details" VALUES(10563,36,19,25,0)
INSERT "Order Details" VALUES(10563,52,7,70,0)
INSERT "Order Details" VALUES(10564,17,39,16,0.05)
INSERT "Order Details" VALUES(10564,31,12.5,6,0.05)
INSERT "Order Details" VALUES(10564,55,24,25,0.05)
INSERT "Order Details" VALUES(10565,24,4.5,25,0.1)
go
INSERT "Order Details" VALUES(10565,64,33.25,18,0.1)
INSERT "Order Details" VALUES(10566,11,21,35,0.15)
INSERT "Order Details" VALUES(10566,18,62.5,18,0.15)
INSERT "Order Details" VALUES(10566,76,18,10,0)
INSERT "Order Details" VALUES(10567,31,12.5,60,0.2)
INSERT "Order Details" VALUES(10567,51,53,3,0)
INSERT "Order Details" VALUES(10567,59,55,40,0.2)
INSERT "Order Details" VALUES(10568,10,31,5,0)
INSERT "Order Details" VALUES(10569,31,12.5,35,0.2)
INSERT "Order Details" VALUES(10569,76,18,30,0)
go
INSERT "Order Details" VALUES(10570,11,21,15,0.05)
INSERT "Order Details" VALUES(10570,56,38,60,0.05)
INSERT "Order Details" VALUES(10571,14,23.25,11,0.15)
INSERT "Order Details" VALUES(10571,42,14,28,0.15)
INSERT "Order Details" VALUES(10572,16,17.45,12,0.1)
INSERT "Order Details" VALUES(10572,32,32,10,0.1)
INSERT "Order Details" VALUES(10572,40,18.4,50,0)
INSERT "Order Details" VALUES(10572,75,7.75,15,0.1)
INSERT "Order Details" VALUES(10573,17,39,18,0)
INSERT "Order Details" VALUES(10573,34,14,40,0)
go
INSERT "Order Details" VALUES(10573,53,32.8,25,0)
INSERT "Order Details" VALUES(10574,33,2.5,14,0)
INSERT "Order Details" VALUES(10574,40,18.4,2,0)
INSERT "Order Details" VALUES(10574,62,49.3,10,0)
INSERT "Order Details" VALUES(10574,64,33.25,6,0)
INSERT "Order Details" VALUES(10575,59,55,12,0)
INSERT "Order Details" VALUES(10575,63,43.9,6,0)
INSERT "Order Details" VALUES(10575,72,34.8,30,0)
INSERT "Order Details" VALUES(10575,76,18,10,0)
INSERT "Order Details" VALUES(10576,1,18,10,0)
go
INSERT "Order Details" VALUES(10576,31,12.5,20,0)
INSERT "Order Details" VALUES(10576,44,19.45,21,0)
INSERT "Order Details" VALUES(10577,39,18,10,0)
INSERT "Order Details" VALUES(10577,75,7.75,20,0)
INSERT "Order Details" VALUES(10577,77,13,18,0)
INSERT "Order Details" VALUES(10578,35,18,20,0)
INSERT "Order Details" VALUES(10578,57,19.5,6,0)
INSERT "Order Details" VALUES(10579,15,15.5,10,0)
INSERT "Order Details" VALUES(10579,75,7.75,21,0)
INSERT "Order Details" VALUES(10580,14,23.25,15,0.05)
go
INSERT "Order Details" VALUES(10580,41,9.65,9,0.05)
INSERT "Order Details" VALUES(10580,65,21.05,30,0.05)
INSERT "Order Details" VALUES(10581,75,7.75,50,0.2)
INSERT "Order Details" VALUES(10582,57,19.5,4,0)
INSERT "Order Details" VALUES(10582,76,18,14,0)
INSERT "Order Details" VALUES(10583,29,123.79,10,0)
INSERT "Order Details" VALUES(10583,60,34,24,0.15)
INSERT "Order Details" VALUES(10583,69,36,10,0.15)
INSERT "Order Details" VALUES(10584,31,12.5,50,0.05)
INSERT "Order Details" VALUES(10585,47,9.5,15,0)
go
INSERT "Order Details" VALUES(10586,52,7,4,0.15)
INSERT "Order Details" VALUES(10587,26,31.23,6,0)
INSERT "Order Details" VALUES(10587,35,18,20,0)
INSERT "Order Details" VALUES(10587,77,13,20,0)
INSERT "Order Details" VALUES(10588,18,62.5,40,0.2)
INSERT "Order Details" VALUES(10588,42,14,100,0.2)
INSERT "Order Details" VALUES(10589,35,18,4,0)
INSERT "Order Details" VALUES(10590,1,18,20,0)
INSERT "Order Details" VALUES(10590,77,13,60,0.05)
INSERT "Order Details" VALUES(10591,3,10,14,0)
go
INSERT "Order Details" VALUES(10591,7,30,10,0)
INSERT "Order Details" VALUES(10591,54,7.45,50,0)
INSERT "Order Details" VALUES(10592,15,15.5,25,0.05)
INSERT "Order Details" VALUES(10592,26,31.23,5,0.05)
INSERT "Order Details" VALUES(10593,20,81,21,0.2)
INSERT "Order Details" VALUES(10593,69,36,20,0.2)
INSERT "Order Details" VALUES(10593,76,18,4,0.2)
INSERT "Order Details" VALUES(10594,52,7,24,0)
INSERT "Order Details" VALUES(10594,58,13.25,30,0)
INSERT "Order Details" VALUES(10595,35,18,30,0.25)
go
INSERT "Order Details" VALUES(10595,61,28.5,120,0.25)
INSERT "Order Details" VALUES(10595,69,36,65,0.25)
INSERT "Order Details" VALUES(10596,56,38,5,0.2)
INSERT "Order Details" VALUES(10596,63,43.9,24,0.2)
INSERT "Order Details" VALUES(10596,75,7.75,30,0.2)
INSERT "Order Details" VALUES(10597,24,4.5,35,0.2)
INSERT "Order Details" VALUES(10597,57,19.5,20,0)
INSERT "Order Details" VALUES(10597,65,21.05,12,0.2)
INSERT "Order Details" VALUES(10598,27,43.9,50,0)
INSERT "Order Details" VALUES(10598,71,21.5,9,0)
go
INSERT "Order Details" VALUES(10599,62,49.3,10,0)
INSERT "Order Details" VALUES(10600,54,7.45,4,0)
INSERT "Order Details" VALUES(10600,73,15,30,0)
INSERT "Order Details" VALUES(10601,13,6,60,0)
INSERT "Order Details" VALUES(10601,59,55,35,0)
INSERT "Order Details" VALUES(10602,77,13,5,0.25)
INSERT "Order Details" VALUES(10603,22,21,48,0)
INSERT "Order Details" VALUES(10603,49,20,25,0.05)
INSERT "Order Details" VALUES(10604,48,12.75,6,0.1)
INSERT "Order Details" VALUES(10604,76,18,10,0.1)
go
INSERT "Order Details" VALUES(10605,16,17.45,30,0.05)
INSERT "Order Details" VALUES(10605,59,55,20,0.05)
INSERT "Order Details" VALUES(10605,60,34,70,0.05)
INSERT "Order Details" VALUES(10605,71,21.5,15,0.05)
INSERT "Order Details" VALUES(10606,4,22,20,0.2)
INSERT "Order Details" VALUES(10606,55,24,20,0.2)
INSERT "Order Details" VALUES(10606,62,49.3,10,0.2)
INSERT "Order Details" VALUES(10607,7,30,45,0)
INSERT "Order Details" VALUES(10607,17,39,100,0)
INSERT "Order Details" VALUES(10607,33,2.5,14,0)
go
INSERT "Order Details" VALUES(10607,40,18.4,42,0)
INSERT "Order Details" VALUES(10607,72,34.8,12,0)
INSERT "Order Details" VALUES(10608,56,38,28,0)
INSERT "Order Details" VALUES(10609,1,18,3,0)
INSERT "Order Details" VALUES(10609,10,31,10,0)
INSERT "Order Details" VALUES(10609,21,10,6,0)
INSERT "Order Details" VALUES(10610,36,19,21,0.25)
INSERT "Order Details" VALUES(10611,1,18,6,0)
INSERT "Order Details" VALUES(10611,2,19,10,0)
INSERT "Order Details" VALUES(10611,60,34,15,0)
go
INSERT "Order Details" VALUES(10612,10,31,70,0)
INSERT "Order Details" VALUES(10612,36,19,55,0)
INSERT "Order Details" VALUES(10612,49,20,18,0)
INSERT "Order Details" VALUES(10612,60,34,40,0)
INSERT "Order Details" VALUES(10612,76,18,80,0)
INSERT "Order Details" VALUES(10613,13,6,8,0.1)
INSERT "Order Details" VALUES(10613,75,7.75,40,0)
INSERT "Order Details" VALUES(10614,11,21,14,0)
INSERT "Order Details" VALUES(10614,21,10,8,0)
INSERT "Order Details" VALUES(10614,39,18,5,0)
go
INSERT "Order Details" VALUES(10615,55,24,5,0)
INSERT "Order Details" VALUES(10616,38,263.5,15,0.05)
INSERT "Order Details" VALUES(10616,56,38,14,0)
INSERT "Order Details" VALUES(10616,70,15,15,0.05)
INSERT "Order Details" VALUES(10616,71,21.5,15,0.05)
INSERT "Order Details" VALUES(10617,59,55,30,0.15)
INSERT "Order Details" VALUES(10618,6,25,70,0)
INSERT "Order Details" VALUES(10618,56,38,20,0)
INSERT "Order Details" VALUES(10618,68,12.5,15,0)
INSERT "Order Details" VALUES(10619,21,10,42,0)
go
INSERT "Order Details" VALUES(10619,22,21,40,0)
INSERT "Order Details" VALUES(10620,24,4.5,5,0)
INSERT "Order Details" VALUES(10620,52,7,5,0)
INSERT "Order Details" VALUES(10621,19,9.2,5,0)
INSERT "Order Details" VALUES(10621,23,9,10,0)
INSERT "Order Details" VALUES(10621,70,15,20,0)
INSERT "Order Details" VALUES(10621,71,21.5,15,0)
INSERT "Order Details" VALUES(10622,2,19,20,0)
INSERT "Order Details" VALUES(10622,68,12.5,18,0.2)
INSERT "Order Details" VALUES(10623,14,23.25,21,0)
go
INSERT "Order Details" VALUES(10623,19,9.2,15,0.1)
INSERT "Order Details" VALUES(10623,21,10,25,0.1)
INSERT "Order Details" VALUES(10623,24,4.5,3,0)
INSERT "Order Details" VALUES(10623,35,18,30,0.1)
INSERT "Order Details" VALUES(10624,28,45.6,10,0)
INSERT "Order Details" VALUES(10624,29,123.79,6,0)
INSERT "Order Details" VALUES(10624,44,19.45,10,0)
INSERT "Order Details" VALUES(10625,14,23.25,3,0)
INSERT "Order Details" VALUES(10625,42,14,5,0)
INSERT "Order Details" VALUES(10625,60,34,10,0)
go
INSERT "Order Details" VALUES(10626,53,32.8,12,0)
INSERT "Order Details" VALUES(10626,60,34,20,0)
INSERT "Order Details" VALUES(10626,71,21.5,20,0)
INSERT "Order Details" VALUES(10627,62,49.3,15,0)
INSERT "Order Details" VALUES(10627,73,15,35,0.15)
INSERT "Order Details" VALUES(10628,1,18,25,0)
INSERT "Order Details" VALUES(10629,29,123.79,20,0)
INSERT "Order Details" VALUES(10629,64,33.25,9,0)
INSERT "Order Details" VALUES(10630,55,24,12,0.05)
INSERT "Order Details" VALUES(10630,76,18,35,0)
go
INSERT "Order Details" VALUES(10631,75,7.75,8,0.1)
INSERT "Order Details" VALUES(10632,2,19,30,0.05)
INSERT "Order Details" VALUES(10632,33,2.5,20,0.05)
INSERT "Order Details" VALUES(10633,12,38,36,0.15)
INSERT "Order Details" VALUES(10633,13,6,13,0.15)
INSERT "Order Details" VALUES(10633,26,31.23,35,0.15)
INSERT "Order Details" VALUES(10633,62,49.3,80,0.15)
INSERT "Order Details" VALUES(10634,7,30,35,0)
INSERT "Order Details" VALUES(10634,18,62.5,50,0)
INSERT "Order Details" VALUES(10634,51,53,15,0)
go
INSERT "Order Details" VALUES(10634,75,7.75,2,0)
INSERT "Order Details" VALUES(10635,4,22,10,0.1)
INSERT "Order Details" VALUES(10635,5,21.35,15,0.1)
INSERT "Order Details" VALUES(10635,22,21,40,0)
INSERT "Order Details" VALUES(10636,4,22,25,0)
INSERT "Order Details" VALUES(10636,58,13.25,6,0)
INSERT "Order Details" VALUES(10637,11,21,10,0)
INSERT "Order Details" VALUES(10637,50,16.25,25,0.05)
INSERT "Order Details" VALUES(10637,56,38,60,0.05)
INSERT "Order Details" VALUES(10638,45,9.5,20,0)
go
INSERT "Order Details" VALUES(10638,65,21.05,21,0)
INSERT "Order Details" VALUES(10638,72,34.8,60,0)
INSERT "Order Details" VALUES(10639,18,62.5,8,0)
INSERT "Order Details" VALUES(10640,69,36,20,0.25)
INSERT "Order Details" VALUES(10640,70,15,15,0.25)
INSERT "Order Details" VALUES(10641,2,19,50,0)
INSERT "Order Details" VALUES(10641,40,18.4,60,0)
INSERT "Order Details" VALUES(10642,21,10,30,0.2)
INSERT "Order Details" VALUES(10642,61,28.5,20,0.2)
INSERT "Order Details" VALUES(10643,28,45.6,15,0.25)
go
INSERT "Order Details" VALUES(10643,39,18,21,0.25)
INSERT "Order Details" VALUES(10643,46,12,2,0.25)
INSERT "Order Details" VALUES(10644,18,62.5,4,0.1)
INSERT "Order Details" VALUES(10644,43,46,20,0)
INSERT "Order Details" VALUES(10644,46,12,21,0.1)
INSERT "Order Details" VALUES(10645,18,62.5,20,0)
INSERT "Order Details" VALUES(10645,36,19,15,0)
INSERT "Order Details" VALUES(10646,1,18,15,0.25)
INSERT "Order Details" VALUES(10646,10,31,18,0.25)
INSERT "Order Details" VALUES(10646,71,21.5,30,0.25)
go
INSERT "Order Details" VALUES(10646,77,13,35,0.25)
INSERT "Order Details" VALUES(10647,19,9.2,30,0)
INSERT "Order Details" VALUES(10647,39,18,20,0)
INSERT "Order Details" VALUES(10648,22,21,15,0)
INSERT "Order Details" VALUES(10648,24,4.5,15,0.15)
INSERT "Order Details" VALUES(10649,28,45.6,20,0)
INSERT "Order Details" VALUES(10649,72,34.8,15,0)
INSERT "Order Details" VALUES(10650,30,25.89,30,0)
INSERT "Order Details" VALUES(10650,53,32.8,25,0.05)
INSERT "Order Details" VALUES(10650,54,7.45,30,0)
go
INSERT "Order Details" VALUES(10651,19,9.2,12,0.25)
INSERT "Order Details" VALUES(10651,22,21,20,0.25)
INSERT "Order Details" VALUES(10652,30,25.89,2,0.25)
INSERT "Order Details" VALUES(10652,42,14,20,0)
INSERT "Order Details" VALUES(10653,16,17.45,30,0.1)
INSERT "Order Details" VALUES(10653,60,34,20,0.1)
INSERT "Order Details" VALUES(10654,4,22,12,0.1)
INSERT "Order Details" VALUES(10654,39,18,20,0.1)
INSERT "Order Details" VALUES(10654,54,7.45,6,0.1)
INSERT "Order Details" VALUES(10655,41,9.65,20,0.2)
go
INSERT "Order Details" VALUES(10656,14,23.25,3,0.1)
INSERT "Order Details" VALUES(10656,44,19.45,28,0.1)
INSERT "Order Details" VALUES(10656,47,9.5,6,0.1)
INSERT "Order Details" VALUES(10657,15,15.5,50,0)
INSERT "Order Details" VALUES(10657,41,9.65,24,0)
INSERT "Order Details" VALUES(10657,46,12,45,0)
INSERT "Order Details" VALUES(10657,47,9.5,10,0)
INSERT "Order Details" VALUES(10657,56,38,45,0)
INSERT "Order Details" VALUES(10657,60,34,30,0)
INSERT "Order Details" VALUES(10658,21,10,60,0)
go
INSERT "Order Details" VALUES(10658,40,18.4,70,0.05)
INSERT "Order Details" VALUES(10658,60,34,55,0.05)
INSERT "Order Details" VALUES(10658,77,13,70,0.05)
INSERT "Order Details" VALUES(10659,31,12.5,20,0.05)
INSERT "Order Details" VALUES(10659,40,18.4,24,0.05)
INSERT "Order Details" VALUES(10659,70,15,40,0.05)
INSERT "Order Details" VALUES(10660,20,81,21,0)
INSERT "Order Details" VALUES(10661,39,18,3,0.2)
INSERT "Order Details" VALUES(10661,58,13.25,49,0.2)
INSERT "Order Details" VALUES(10662,68,12.5,10,0)
go
INSERT "Order Details" VALUES(10663,40,18.4,30,0.05)
INSERT "Order Details" VALUES(10663,42,14,30,0.05)
INSERT "Order Details" VALUES(10663,51,53,20,0.05)
INSERT "Order Details" VALUES(10664,10,31,24,0.15)
INSERT "Order Details" VALUES(10664,56,38,12,0.15)
INSERT "Order Details" VALUES(10664,65,21.05,15,0.15)
INSERT "Order Details" VALUES(10665,51,53,20,0)
INSERT "Order Details" VALUES(10665,59,55,1,0)
INSERT "Order Details" VALUES(10665,76,18,10,0)
INSERT "Order Details" VALUES(10666,29,123.79,36,0)
go
INSERT "Order Details" VALUES(10666,65,21.05,10,0)
INSERT "Order Details" VALUES(10667,69,36,45,0.2)
INSERT "Order Details" VALUES(10667,71,21.5,14,0.2)
INSERT "Order Details" VALUES(10668,31,12.5,8,0.1)
INSERT "Order Details" VALUES(10668,55,24,4,0.1)
INSERT "Order Details" VALUES(10668,64,33.25,15,0.1)
INSERT "Order Details" VALUES(10669,36,19,30,0)
INSERT "Order Details" VALUES(10670,23,9,32,0)
INSERT "Order Details" VALUES(10670,46,12,60,0)
INSERT "Order Details" VALUES(10670,67,14,25,0)
go
INSERT "Order Details" VALUES(10670,73,15,50,0)
INSERT "Order Details" VALUES(10670,75,7.75,25,0)
INSERT "Order Details" VALUES(10671,16,17.45,10,0)
INSERT "Order Details" VALUES(10671,62,49.3,10,0)
INSERT "Order Details" VALUES(10671,65,21.05,12,0)
INSERT "Order Details" VALUES(10672,38,263.5,15,0.1)
INSERT "Order Details" VALUES(10672,71,21.5,12,0)
INSERT "Order Details" VALUES(10673,16,17.45,3,0)
INSERT "Order Details" VALUES(10673,42,14,6,0)
INSERT "Order Details" VALUES(10673,43,46,6,0)
go
INSERT "Order Details" VALUES(10674,23,9,5,0)
INSERT "Order Details" VALUES(10675,14,23.25,30,0)
INSERT "Order Details" VALUES(10675,53,32.8,10,0)
INSERT "Order Details" VALUES(10675,58,13.25,30,0)
INSERT "Order Details" VALUES(10676,10,31,2,0)
INSERT "Order Details" VALUES(10676,19,9.2,7,0)
INSERT "Order Details" VALUES(10676,44,19.45,21,0)
INSERT "Order Details" VALUES(10677,26,31.23,30,0.15)
INSERT "Order Details" VALUES(10677,33,2.5,8,0.15)
INSERT "Order Details" VALUES(10678,12,38,100,0)
go
INSERT "Order Details" VALUES(10678,33,2.5,30,0)
INSERT "Order Details" VALUES(10678,41,9.65,120,0)
INSERT "Order Details" VALUES(10678,54,7.45,30,0)
INSERT "Order Details" VALUES(10679,59,55,12,0)
INSERT "Order Details" VALUES(10680,16,17.45,50,0.25)
INSERT "Order Details" VALUES(10680,31,12.5,20,0.25)
INSERT "Order Details" VALUES(10680,42,14,40,0.25)
INSERT "Order Details" VALUES(10681,19,9.2,30,0.1)
INSERT "Order Details" VALUES(10681,21,10,12,0.1)
INSERT "Order Details" VALUES(10681,64,33.25,28,0)
go
INSERT "Order Details" VALUES(10682,33,2.5,30,0)
INSERT "Order Details" VALUES(10682,66,17,4,0)
INSERT "Order Details" VALUES(10682,75,7.75,30,0)
INSERT "Order Details" VALUES(10683,52,7,9,0)
INSERT "Order Details" VALUES(10684,40,18.4,20,0)
INSERT "Order Details" VALUES(10684,47,9.5,40,0)
INSERT "Order Details" VALUES(10684,60,34,30,0)
INSERT "Order Details" VALUES(10685,10,31,20,0)
INSERT "Order Details" VALUES(10685,41,9.65,4,0)
INSERT "Order Details" VALUES(10685,47,9.5,15,0)
go
INSERT "Order Details" VALUES(10686,17,39,30,0.2)
INSERT "Order Details" VALUES(10686,26,31.23,15,0)
INSERT "Order Details" VALUES(10687,9,97,50,0.25)
INSERT "Order Details" VALUES(10687,29,123.79,10,0)
INSERT "Order Details" VALUES(10687,36,19,6,0.25)
INSERT "Order Details" VALUES(10688,10,31,18,0.1)
INSERT "Order Details" VALUES(10688,28,45.6,60,0.1)
INSERT "Order Details" VALUES(10688,34,14,14,0)
INSERT "Order Details" VALUES(10689,1,18,35,0.25)
INSERT "Order Details" VALUES(10690,56,38,20,0.25)
go
INSERT "Order Details" VALUES(10690,77,13,30,0.25)
INSERT "Order Details" VALUES(10691,1,18,30,0)
INSERT "Order Details" VALUES(10691,29,123.79,40,0)
INSERT "Order Details" VALUES(10691,43,46,40,0)
INSERT "Order Details" VALUES(10691,44,19.45,24,0)
INSERT "Order Details" VALUES(10691,62,49.3,48,0)
INSERT "Order Details" VALUES(10692,63,43.9,20,0)
INSERT "Order Details" VALUES(10693,9,97,6,0)
INSERT "Order Details" VALUES(10693,54,7.45,60,0.15)
INSERT "Order Details" VALUES(10693,69,36,30,0.15)
go
INSERT "Order Details" VALUES(10693,73,15,15,0.15)
INSERT "Order Details" VALUES(10694,7,30,90,0)
INSERT "Order Details" VALUES(10694,59,55,25,0)
INSERT "Order Details" VALUES(10694,70,15,50,0)
INSERT "Order Details" VALUES(10695,8,40,10,0)
INSERT "Order Details" VALUES(10695,12,38,4,0)
INSERT "Order Details" VALUES(10695,24,4.5,20,0)
INSERT "Order Details" VALUES(10696,17,39,20,0)
INSERT "Order Details" VALUES(10696,46,12,18,0)
INSERT "Order Details" VALUES(10697,19,9.2,7,0.25)
go
INSERT "Order Details" VALUES(10697,35,18,9,0.25)
INSERT "Order Details" VALUES(10697,58,13.25,30,0.25)
INSERT "Order Details" VALUES(10697,70,15,30,0.25)
INSERT "Order Details" VALUES(10698,11,21,15,0)
INSERT "Order Details" VALUES(10698,17,39,8,0.05)
INSERT "Order Details" VALUES(10698,29,123.79,12,0.05)
INSERT "Order Details" VALUES(10698,65,21.05,65,0.05)
INSERT "Order Details" VALUES(10698,70,15,8,0.05)
INSERT "Order Details" VALUES(10699,47,9.5,12,0)
INSERT "Order Details" VALUES(10700,1,18,5,0.2)
go
INSERT "Order Details" VALUES(10700,34,14,12,0.2)
INSERT "Order Details" VALUES(10700,68,12.5,40,0.2)
INSERT "Order Details" VALUES(10700,71,21.5,60,0.2)
INSERT "Order Details" VALUES(10701,59,55,42,0.15)
INSERT "Order Details" VALUES(10701,71,21.5,20,0.15)
INSERT "Order Details" VALUES(10701,76,18,35,0.15)
INSERT "Order Details" VALUES(10702,3,10,6,0)
INSERT "Order Details" VALUES(10702,76,18,15,0)
INSERT "Order Details" VALUES(10703,2,19,5,0)
INSERT "Order Details" VALUES(10703,59,55,35,0)
go
INSERT "Order Details" VALUES(10703,73,15,35,0)
INSERT "Order Details" VALUES(10704,4,22,6,0)
INSERT "Order Details" VALUES(10704,24,4.5,35,0)
INSERT "Order Details" VALUES(10704,48,12.75,24,0)
INSERT "Order Details" VALUES(10705,31,12.5,20,0)
INSERT "Order Details" VALUES(10705,32,32,4,0)
INSERT "Order Details" VALUES(10706,16,17.45,20,0)
INSERT "Order Details" VALUES(10706,43,46,24,0)
INSERT "Order Details" VALUES(10706,59,55,8,0)
INSERT "Order Details" VALUES(10707,55,24,21,0)
go
INSERT "Order Details" VALUES(10707,57,19.5,40,0)
INSERT "Order Details" VALUES(10707,70,15,28,0.15)
INSERT "Order Details" VALUES(10708,5,21.35,4,0)
INSERT "Order Details" VALUES(10708,36,19,5,0)
INSERT "Order Details" VALUES(10709,8,40,40,0)
INSERT "Order Details" VALUES(10709,51,53,28,0)
INSERT "Order Details" VALUES(10709,60,34,10,0)
INSERT "Order Details" VALUES(10710,19,9.2,5,0)
INSERT "Order Details" VALUES(10710,47,9.5,5,0)
INSERT "Order Details" VALUES(10711,19,9.2,12,0)
go
INSERT "Order Details" VALUES(10711,41,9.65,42,0)
INSERT "Order Details" VALUES(10711,53,32.8,120,0)
INSERT "Order Details" VALUES(10712,53,32.8,3,0.05)
INSERT "Order Details" VALUES(10712,56,38,30,0)
INSERT "Order Details" VALUES(10713,10,31,18,0)
INSERT "Order Details" VALUES(10713,26,31.23,30,0)
INSERT "Order Details" VALUES(10713,45,9.5,110,0)
INSERT "Order Details" VALUES(10713,46,12,24,0)
INSERT "Order Details" VALUES(10714,2,19,30,0.25)
INSERT "Order Details" VALUES(10714,17,39,27,0.25)
go
INSERT "Order Details" VALUES(10714,47,9.5,50,0.25)
INSERT "Order Details" VALUES(10714,56,38,18,0.25)
INSERT "Order Details" VALUES(10714,58,13.25,12,0.25)
INSERT "Order Details" VALUES(10715,10,31,21,0)
INSERT "Order Details" VALUES(10715,71,21.5,30,0)
INSERT "Order Details" VALUES(10716,21,10,5,0)
INSERT "Order Details" VALUES(10716,51,53,7,0)
INSERT "Order Details" VALUES(10716,61,28.5,10,0)
INSERT "Order Details" VALUES(10717,21,10,32,0.05)
INSERT "Order Details" VALUES(10717,54,7.45,15,0)
go
INSERT "Order Details" VALUES(10717,69,36,25,0.05)
INSERT "Order Details" VALUES(10718,12,38,36,0)
INSERT "Order Details" VALUES(10718,16,17.45,20,0)
INSERT "Order Details" VALUES(10718,36,19,40,0)
INSERT "Order Details" VALUES(10718,62,49.3,20,0)
INSERT "Order Details" VALUES(10719,18,62.5,12,0.25)
INSERT "Order Details" VALUES(10719,30,25.89,3,0.25)
INSERT "Order Details" VALUES(10719,54,7.45,40,0.25)
INSERT "Order Details" VALUES(10720,35,18,21,0)
INSERT "Order Details" VALUES(10720,71,21.5,8,0)
go
INSERT "Order Details" VALUES(10721,44,19.45,50,0.05)
INSERT "Order Details" VALUES(10722,2,19,3,0)
INSERT "Order Details" VALUES(10722,31,12.5,50,0)
INSERT "Order Details" VALUES(10722,68,12.5,45,0)
INSERT "Order Details" VALUES(10722,75,7.75,42,0)
INSERT "Order Details" VALUES(10723,26,31.23,15,0)
INSERT "Order Details" VALUES(10724,10,31,16,0)
INSERT "Order Details" VALUES(10724,61,28.5,5,0)
INSERT "Order Details" VALUES(10725,41,9.65,12,0)
INSERT "Order Details" VALUES(10725,52,7,4,0)
go
INSERT "Order Details" VALUES(10725,55,24,6,0)
INSERT "Order Details" VALUES(10726,4,22,25,0)
INSERT "Order Details" VALUES(10726,11,21,5,0)
INSERT "Order Details" VALUES(10727,17,39,20,0.05)
INSERT "Order Details" VALUES(10727,56,38,10,0.05)
INSERT "Order Details" VALUES(10727,59,55,10,0.05)
INSERT "Order Details" VALUES(10728,30,25.89,15,0)
INSERT "Order Details" VALUES(10728,40,18.4,6,0)
INSERT "Order Details" VALUES(10728,55,24,12,0)
INSERT "Order Details" VALUES(10728,60,34,15,0)
go
INSERT "Order Details" VALUES(10729,1,18,50,0)
INSERT "Order Details" VALUES(10729,21,10,30,0)
INSERT "Order Details" VALUES(10729,50,16.25,40,0)
INSERT "Order Details" VALUES(10730,16,17.45,15,0.05)
INSERT "Order Details" VALUES(10730,31,12.5,3,0.05)
INSERT "Order Details" VALUES(10730,65,21.05,10,0.05)
INSERT "Order Details" VALUES(10731,21,10,40,0.05)
INSERT "Order Details" VALUES(10731,51,53,30,0.05)
INSERT "Order Details" VALUES(10732,76,18,20,0)
INSERT "Order Details" VALUES(10733,14,23.25,16,0)
go
INSERT "Order Details" VALUES(10733,28,45.6,20,0)
INSERT "Order Details" VALUES(10733,52,7,25,0)
INSERT "Order Details" VALUES(10734,6,25,30,0)
INSERT "Order Details" VALUES(10734,30,25.89,15,0)
INSERT "Order Details" VALUES(10734,76,18,20,0)
INSERT "Order Details" VALUES(10735,61,28.5,20,0.1)
INSERT "Order Details" VALUES(10735,77,13,2,0.1)
INSERT "Order Details" VALUES(10736,65,21.05,40,0)
INSERT "Order Details" VALUES(10736,75,7.75,20,0)
INSERT "Order Details" VALUES(10737,13,6,4,0)
go
INSERT "Order Details" VALUES(10737,41,9.65,12,0)
INSERT "Order Details" VALUES(10738,16,17.45,3,0)
INSERT "Order Details" VALUES(10739,36,19,6,0)
INSERT "Order Details" VALUES(10739,52,7,18,0)
INSERT "Order Details" VALUES(10740,28,45.6,5,0.2)
INSERT "Order Details" VALUES(10740,35,18,35,0.2)
INSERT "Order Details" VALUES(10740,45,9.5,40,0.2)
INSERT "Order Details" VALUES(10740,56,38,14,0.2)
INSERT "Order Details" VALUES(10741,2,19,15,0.2)
INSERT "Order Details" VALUES(10742,3,10,20,0)
go
INSERT "Order Details" VALUES(10742,60,34,50,0)
INSERT "Order Details" VALUES(10742,72,34.8,35,0)
INSERT "Order Details" VALUES(10743,46,12,28,0.05)
INSERT "Order Details" VALUES(10744,40,18.4,50,0.2)
INSERT "Order Details" VALUES(10745,18,62.5,24,0)
INSERT "Order Details" VALUES(10745,44,19.45,16,0)
INSERT "Order Details" VALUES(10745,59,55,45,0)
INSERT "Order Details" VALUES(10745,72,34.8,7,0)
INSERT "Order Details" VALUES(10746,13,6,6,0)
INSERT "Order Details" VALUES(10746,42,14,28,0)
go
INSERT "Order Details" VALUES(10746,62,49.3,9,0)
INSERT "Order Details" VALUES(10746,69,36,40,0)
INSERT "Order Details" VALUES(10747,31,12.5,8,0)
INSERT "Order Details" VALUES(10747,41,9.65,35,0)
INSERT "Order Details" VALUES(10747,63,43.9,9,0)
INSERT "Order Details" VALUES(10747,69,36,30,0)
INSERT "Order Details" VALUES(10748,23,9,44,0)
INSERT "Order Details" VALUES(10748,40,18.4,40,0)
INSERT "Order Details" VALUES(10748,56,38,28,0)
INSERT "Order Details" VALUES(10749,56,38,15,0)
go
INSERT "Order Details" VALUES(10749,59,55,6,0)
INSERT "Order Details" VALUES(10749,76,18,10,0)
INSERT "Order Details" VALUES(10750,14,23.25,5,0.15)
INSERT "Order Details" VALUES(10750,45,9.5,40,0.15)
INSERT "Order Details" VALUES(10750,59,55,25,0.15)
INSERT "Order Details" VALUES(10751,26,31.23,12,0.1)
INSERT "Order Details" VALUES(10751,30,25.89,30,0)
INSERT "Order Details" VALUES(10751,50,16.25,20,0.1)
INSERT "Order Details" VALUES(10751,73,15,15,0)
INSERT "Order Details" VALUES(10752,1,18,8,0)
go
INSERT "Order Details" VALUES(10752,69,36,3,0)
INSERT "Order Details" VALUES(10753,45,9.5,4,0)
INSERT "Order Details" VALUES(10753,74,10,5,0)
INSERT "Order Details" VALUES(10754,40,18.4,3,0)
INSERT "Order Details" VALUES(10755,47,9.5,30,0.25)
INSERT "Order Details" VALUES(10755,56,38,30,0.25)
INSERT "Order Details" VALUES(10755,57,19.5,14,0.25)
INSERT "Order Details" VALUES(10755,69,36,25,0.25)
INSERT "Order Details" VALUES(10756,18,62.5,21,0.2)
INSERT "Order Details" VALUES(10756,36,19,20,0.2)
go
INSERT "Order Details" VALUES(10756,68,12.5,6,0.2)
INSERT "Order Details" VALUES(10756,69,36,20,0.2)
INSERT "Order Details" VALUES(10757,34,14,30,0)
INSERT "Order Details" VALUES(10757,59,55,7,0)
INSERT "Order Details" VALUES(10757,62,49.3,30,0)
INSERT "Order Details" VALUES(10757,64,33.25,24,0)
INSERT "Order Details" VALUES(10758,26,31.23,20,0)
INSERT "Order Details" VALUES(10758,52,7,60,0)
INSERT "Order Details" VALUES(10758,70,15,40,0)
INSERT "Order Details" VALUES(10759,32,32,10,0)
go
INSERT "Order Details" VALUES(10760,25,14,12,0.25)
INSERT "Order Details" VALUES(10760,27,43.9,40,0)
INSERT "Order Details" VALUES(10760,43,46,30,0.25)
INSERT "Order Details" VALUES(10761,25,14,35,0.25)
INSERT "Order Details" VALUES(10761,75,7.75,18,0)
INSERT "Order Details" VALUES(10762,39,18,16,0)
INSERT "Order Details" VALUES(10762,47,9.5,30,0)
INSERT "Order Details" VALUES(10762,51,53,28,0)
INSERT "Order Details" VALUES(10762,56,38,60,0)
INSERT "Order Details" VALUES(10763,21,10,40,0)
go
INSERT "Order Details" VALUES(10763,22,21,6,0)
INSERT "Order Details" VALUES(10763,24,4.5,20,0)
INSERT "Order Details" VALUES(10764,3,10,20,0.1)
INSERT "Order Details" VALUES(10764,39,18,130,0.1)
INSERT "Order Details" VALUES(10765,65,21.05,80,0.1)
INSERT "Order Details" VALUES(10766,2,19,40,0)
INSERT "Order Details" VALUES(10766,7,30,35,0)
INSERT "Order Details" VALUES(10766,68,12.5,40,0)
INSERT "Order Details" VALUES(10767,42,14,2,0)
INSERT "Order Details" VALUES(10768,22,21,4,0)
go
INSERT "Order Details" VALUES(10768,31,12.5,50,0)
INSERT "Order Details" VALUES(10768,60,34,15,0)
INSERT "Order Details" VALUES(10768,71,21.5,12,0)
INSERT "Order Details" VALUES(10769,41,9.65,30,0.05)
INSERT "Order Details" VALUES(10769,52,7,15,0.05)
INSERT "Order Details" VALUES(10769,61,28.5,20,0)
INSERT "Order Details" VALUES(10769,62,49.3,15,0)
INSERT "Order Details" VALUES(10770,11,21,15,0.25)
INSERT "Order Details" VALUES(10771,71,21.5,16,0)
INSERT "Order Details" VALUES(10772,29,123.79,18,0)
go
INSERT "Order Details" VALUES(10772,59,55,25,0)
INSERT "Order Details" VALUES(10773,17,39,33,0)
INSERT "Order Details" VALUES(10773,31,12.5,70,0.2)
INSERT "Order Details" VALUES(10773,75,7.75,7,0.2)
INSERT "Order Details" VALUES(10774,31,12.5,2,0.25)
INSERT "Order Details" VALUES(10774,66,17,50,0)
INSERT "Order Details" VALUES(10775,10,31,6,0)
INSERT "Order Details" VALUES(10775,67,14,3,0)
INSERT "Order Details" VALUES(10776,31,12.5,16,0.05)
INSERT "Order Details" VALUES(10776,42,14,12,0.05)
go
INSERT "Order Details" VALUES(10776,45,9.5,27,0.05)
INSERT "Order Details" VALUES(10776,51,53,120,0.05)
INSERT "Order Details" VALUES(10777,42,14,20,0.2)
INSERT "Order Details" VALUES(10778,41,9.65,10,0)
INSERT "Order Details" VALUES(10779,16,17.45,20,0)
INSERT "Order Details" VALUES(10779,62,49.3,20,0)
INSERT "Order Details" VALUES(10780,70,15,35,0)
INSERT "Order Details" VALUES(10780,77,13,15,0)
INSERT "Order Details" VALUES(10781,54,7.45,3,0.2)
INSERT "Order Details" VALUES(10781,56,38,20,0.2)
go
INSERT "Order Details" VALUES(10781,74,10,35,0)
INSERT "Order Details" VALUES(10782,31,12.5,1,0)
INSERT "Order Details" VALUES(10783,31,12.5,10,0)
INSERT "Order Details" VALUES(10783,38,263.5,5,0)
INSERT "Order Details" VALUES(10784,36,19,30,0)
INSERT "Order Details" VALUES(10784,39,18,2,0.15)
INSERT "Order Details" VALUES(10784,72,34.8,30,0.15)
INSERT "Order Details" VALUES(10785,10,31,10,0)
INSERT "Order Details" VALUES(10785,75,7.75,10,0)
INSERT "Order Details" VALUES(10786,8,40,30,0.2)
go
INSERT "Order Details" VALUES(10786,30,25.89,15,0.2)
INSERT "Order Details" VALUES(10786,75,7.75,42,0.2)
INSERT "Order Details" VALUES(10787,2,19,15,0.05)
INSERT "Order Details" VALUES(10787,29,123.79,20,0.05)
INSERT "Order Details" VALUES(10788,19,9.2,50,0.05)
INSERT "Order Details" VALUES(10788,75,7.75,40,0.05)
INSERT "Order Details" VALUES(10789,18,62.5,30,0)
INSERT "Order Details" VALUES(10789,35,18,15,0)
INSERT "Order Details" VALUES(10789,63,43.9,30,0)
INSERT "Order Details" VALUES(10789,68,12.5,18,0)
go
INSERT "Order Details" VALUES(10790,7,30,3,0.15)
INSERT "Order Details" VALUES(10790,56,38,20,0.15)
INSERT "Order Details" VALUES(10791,29,123.79,14,0.05)
INSERT "Order Details" VALUES(10791,41,9.65,20,0.05)
INSERT "Order Details" VALUES(10792,2,19,10,0)
INSERT "Order Details" VALUES(10792,54,7.45,3,0)
INSERT "Order Details" VALUES(10792,68,12.5,15,0)
INSERT "Order Details" VALUES(10793,41,9.65,14,0)
INSERT "Order Details" VALUES(10793,52,7,8,0)
INSERT "Order Details" VALUES(10794,14,23.25,15,0.2)
go
INSERT "Order Details" VALUES(10794,54,7.45,6,0.2)
INSERT "Order Details" VALUES(10795,16,17.45,65,0)
INSERT "Order Details" VALUES(10795,17,39,35,0.25)
INSERT "Order Details" VALUES(10796,26,31.23,21,0.2)
INSERT "Order Details" VALUES(10796,44,19.45,10,0)
INSERT "Order Details" VALUES(10796,64,33.25,35,0.2)
INSERT "Order Details" VALUES(10796,69,36,24,0.2)
INSERT "Order Details" VALUES(10797,11,21,20,0)
INSERT "Order Details" VALUES(10798,62,49.3,2,0)
INSERT "Order Details" VALUES(10798,72,34.8,10,0)
go
INSERT "Order Details" VALUES(10799,13,6,20,0.15)
INSERT "Order Details" VALUES(10799,24,4.5,20,0.15)
INSERT "Order Details" VALUES(10799,59,55,25,0)
INSERT "Order Details" VALUES(10800,11,21,50,0.1)
INSERT "Order Details" VALUES(10800,51,53,10,0.1)
INSERT "Order Details" VALUES(10800,54,7.45,7,0.1)
INSERT "Order Details" VALUES(10801,17,39,40,0.25)
INSERT "Order Details" VALUES(10801,29,123.79,20,0.25)
INSERT "Order Details" VALUES(10802,30,25.89,25,0.25)
INSERT "Order Details" VALUES(10802,51,53,30,0.25)
go
INSERT "Order Details" VALUES(10802,55,24,60,0.25)
INSERT "Order Details" VALUES(10802,62,49.3,5,0.25)
INSERT "Order Details" VALUES(10803,19,9.2,24,0.05)
INSERT "Order Details" VALUES(10803,25,14,15,0.05)
INSERT "Order Details" VALUES(10803,59,55,15,0.05)
INSERT "Order Details" VALUES(10804,10,31,36,0)
INSERT "Order Details" VALUES(10804,28,45.6,24,0)
INSERT "Order Details" VALUES(10804,49,20,4,0.15)
INSERT "Order Details" VALUES(10805,34,14,10,0)
INSERT "Order Details" VALUES(10805,38,263.5,10,0)
go
INSERT "Order Details" VALUES(10806,2,19,20,0.25)
INSERT "Order Details" VALUES(10806,65,21.05,2,0)
INSERT "Order Details" VALUES(10806,74,10,15,0.25)
INSERT "Order Details" VALUES(10807,40,18.4,1,0)
INSERT "Order Details" VALUES(10808,56,38,20,0.15)
INSERT "Order Details" VALUES(10808,76,18,50,0.15)
INSERT "Order Details" VALUES(10809,52,7,20,0)
INSERT "Order Details" VALUES(10810,13,6,7,0)
INSERT "Order Details" VALUES(10810,25,14,5,0)
INSERT "Order Details" VALUES(10810,70,15,5,0)
go
INSERT "Order Details" VALUES(10811,19,9.2,15,0)
INSERT "Order Details" VALUES(10811,23,9,18,0)
INSERT "Order Details" VALUES(10811,40,18.4,30,0)
INSERT "Order Details" VALUES(10812,31,12.5,16,0.1)
INSERT "Order Details" VALUES(10812,72,34.8,40,0.1)
INSERT "Order Details" VALUES(10812,77,13,20,0)
INSERT "Order Details" VALUES(10813,2,19,12,0.2)
INSERT "Order Details" VALUES(10813,46,12,35,0)
INSERT "Order Details" VALUES(10814,41,9.65,20,0)
INSERT "Order Details" VALUES(10814,43,46,20,0.15)
go
INSERT "Order Details" VALUES(10814,48,12.75,8,0.15)
INSERT "Order Details" VALUES(10814,61,28.5,30,0.15)
INSERT "Order Details" VALUES(10815,33,2.5,16,0)
INSERT "Order Details" VALUES(10816,38,263.5,30,0.05)
INSERT "Order Details" VALUES(10816,62,49.3,20,0.05)
INSERT "Order Details" VALUES(10817,26,31.23,40,0.15)
INSERT "Order Details" VALUES(10817,38,263.5,30,0)
INSERT "Order Details" VALUES(10817,40,18.4,60,0.15)
INSERT "Order Details" VALUES(10817,62,49.3,25,0.15)
INSERT "Order Details" VALUES(10818,32,32,20,0)
go
INSERT "Order Details" VALUES(10818,41,9.65,20,0)
INSERT "Order Details" VALUES(10819,43,46,7,0)
INSERT "Order Details" VALUES(10819,75,7.75,20,0)
INSERT "Order Details" VALUES(10820,56,38,30,0)
INSERT "Order Details" VALUES(10821,35,18,20,0)
INSERT "Order Details" VALUES(10821,51,53,6,0)
INSERT "Order Details" VALUES(10822,62,49.3,3,0)
INSERT "Order Details" VALUES(10822,70,15,6,0)
INSERT "Order Details" VALUES(10823,11,21,20,0.1)
INSERT "Order Details" VALUES(10823,57,19.5,15,0)
go
INSERT "Order Details" VALUES(10823,59,55,40,0.1)
INSERT "Order Details" VALUES(10823,77,13,15,0.1)
INSERT "Order Details" VALUES(10824,41,9.65,12,0)
INSERT "Order Details" VALUES(10824,70,15,9,0)
INSERT "Order Details" VALUES(10825,26,31.23,12,0)
INSERT "Order Details" VALUES(10825,53,32.8,20,0)
INSERT "Order Details" VALUES(10826,31,12.5,35,0)
INSERT "Order Details" VALUES(10826,57,19.5,15,0)
INSERT "Order Details" VALUES(10827,10,31,15,0)
INSERT "Order Details" VALUES(10827,39,18,21,0)
go
INSERT "Order Details" VALUES(10828,20,81,5,0)
INSERT "Order Details" VALUES(10828,38,263.5,2,0)
INSERT "Order Details" VALUES(10829,2,19,10,0)
INSERT "Order Details" VALUES(10829,8,40,20,0)
INSERT "Order Details" VALUES(10829,13,6,10,0)
INSERT "Order Details" VALUES(10829,60,34,21,0)
INSERT "Order Details" VALUES(10830,6,25,6,0)
INSERT "Order Details" VALUES(10830,39,18,28,0)
INSERT "Order Details" VALUES(10830,60,34,30,0)
INSERT "Order Details" VALUES(10830,68,12.5,24,0)
go
INSERT "Order Details" VALUES(10831,19,9.2,2,0)
INSERT "Order Details" VALUES(10831,35,18,8,0)
INSERT "Order Details" VALUES(10831,38,263.5,8,0)
INSERT "Order Details" VALUES(10831,43,46,9,0)
INSERT "Order Details" VALUES(10832,13,6,3,0.2)
INSERT "Order Details" VALUES(10832,25,14,10,0.2)
INSERT "Order Details" VALUES(10832,44,19.45,16,0.2)
INSERT "Order Details" VALUES(10832,64,33.25,3,0)
INSERT "Order Details" VALUES(10833,7,30,20,0.1)
INSERT "Order Details" VALUES(10833,31,12.5,9,0.1)
go
INSERT "Order Details" VALUES(10833,53,32.8,9,0.1)
INSERT "Order Details" VALUES(10834,29,123.79,8,0.05)
INSERT "Order Details" VALUES(10834,30,25.89,20,0.05)
INSERT "Order Details" VALUES(10835,59,55,15,0)
INSERT "Order Details" VALUES(10835,77,13,2,0.2)
INSERT "Order Details" VALUES(10836,22,21,52,0)
INSERT "Order Details" VALUES(10836,35,18,6,0)
INSERT "Order Details" VALUES(10836,57,19.5,24,0)
INSERT "Order Details" VALUES(10836,60,34,60,0)
INSERT "Order Details" VALUES(10836,64,33.25,30,0)
go
INSERT "Order Details" VALUES(10837,13,6,6,0)
INSERT "Order Details" VALUES(10837,40,18.4,25,0)
INSERT "Order Details" VALUES(10837,47,9.5,40,0.25)
INSERT "Order Details" VALUES(10837,76,18,21,0.25)
INSERT "Order Details" VALUES(10838,1,18,4,0.25)
INSERT "Order Details" VALUES(10838,18,62.5,25,0.25)
INSERT "Order Details" VALUES(10838,36,19,50,0.25)
INSERT "Order Details" VALUES(10839,58,13.25,30,0.1)
INSERT "Order Details" VALUES(10839,72,34.8,15,0.1)
INSERT "Order Details" VALUES(10840,25,14,6,0.2)
go
INSERT "Order Details" VALUES(10840,39,18,10,0.2)
INSERT "Order Details" VALUES(10841,10,31,16,0)
INSERT "Order Details" VALUES(10841,56,38,30,0)
INSERT "Order Details" VALUES(10841,59,55,50,0)
INSERT "Order Details" VALUES(10841,77,13,15,0)
INSERT "Order Details" VALUES(10842,11,21,15,0)
INSERT "Order Details" VALUES(10842,43,46,5,0)
INSERT "Order Details" VALUES(10842,68,12.5,20,0)
INSERT "Order Details" VALUES(10842,70,15,12,0)
INSERT "Order Details" VALUES(10843,51,53,4,0.25)
go
INSERT "Order Details" VALUES(10844,22,21,35,0)
INSERT "Order Details" VALUES(10845,23,9,70,0.1)
INSERT "Order Details" VALUES(10845,35,18,25,0.1)
INSERT "Order Details" VALUES(10845,42,14,42,0.1)
INSERT "Order Details" VALUES(10845,58,13.25,60,0.1)
INSERT "Order Details" VALUES(10845,64,33.25,48,0)
INSERT "Order Details" VALUES(10846,4,22,21,0)
INSERT "Order Details" VALUES(10846,70,15,30,0)
INSERT "Order Details" VALUES(10846,74,10,20,0)
INSERT "Order Details" VALUES(10847,1,18,80,0.2)
go
INSERT "Order Details" VALUES(10847,19,9.2,12,0.2)
INSERT "Order Details" VALUES(10847,37,26,60,0.2)
INSERT "Order Details" VALUES(10847,45,9.5,36,0.2)
INSERT "Order Details" VALUES(10847,60,34,45,0.2)
INSERT "Order Details" VALUES(10847,71,21.5,55,0.2)
INSERT "Order Details" VALUES(10848,5,21.35,30,0)
INSERT "Order Details" VALUES(10848,9,97,3,0)
INSERT "Order Details" VALUES(10849,3,10,49,0)
INSERT "Order Details" VALUES(10849,26,31.23,18,0.15)
INSERT "Order Details" VALUES(10850,25,14,20,0.15)
go
INSERT "Order Details" VALUES(10850,33,2.5,4,0.15)
INSERT "Order Details" VALUES(10850,70,15,30,0.15)
INSERT "Order Details" VALUES(10851,2,19,5,0.05)
INSERT "Order Details" VALUES(10851,25,14,10,0.05)
INSERT "Order Details" VALUES(10851,57,19.5,10,0.05)
INSERT "Order Details" VALUES(10851,59,55,42,0.05)
INSERT "Order Details" VALUES(10852,2,19,15,0)
INSERT "Order Details" VALUES(10852,17,39,6,0)
INSERT "Order Details" VALUES(10852,62,49.3,50,0)
INSERT "Order Details" VALUES(10853,18,62.5,10,0)
go
INSERT "Order Details" VALUES(10854,10,31,100,0.15)
INSERT "Order Details" VALUES(10854,13,6,65,0.15)
INSERT "Order Details" VALUES(10855,16,17.45,50,0)
INSERT "Order Details" VALUES(10855,31,12.5,14,0)
INSERT "Order Details" VALUES(10855,56,38,24,0)
INSERT "Order Details" VALUES(10855,65,21.05,15,0.15)
INSERT "Order Details" VALUES(10856,2,19,20,0)
INSERT "Order Details" VALUES(10856,42,14,20,0)
INSERT "Order Details" VALUES(10857,3,10,30,0)
INSERT "Order Details" VALUES(10857,26,31.23,35,0.25)
go
INSERT "Order Details" VALUES(10857,29,123.79,10,0.25)
INSERT "Order Details" VALUES(10858,7,30,5,0)
INSERT "Order Details" VALUES(10858,27,43.9,10,0)
INSERT "Order Details" VALUES(10858,70,15,4,0)
INSERT "Order Details" VALUES(10859,24,4.5,40,0.25)
INSERT "Order Details" VALUES(10859,54,7.45,35,0.25)
INSERT "Order Details" VALUES(10859,64,33.25,30,0.25)
INSERT "Order Details" VALUES(10860,51,53,3,0)
INSERT "Order Details" VALUES(10860,76,18,20,0)
INSERT "Order Details" VALUES(10861,17,39,42,0)
go
INSERT "Order Details" VALUES(10861,18,62.5,20,0)
INSERT "Order Details" VALUES(10861,21,10,40,0)
INSERT "Order Details" VALUES(10861,33,2.5,35,0)
INSERT "Order Details" VALUES(10861,62,49.3,3,0)
INSERT "Order Details" VALUES(10862,11,21,25,0)
INSERT "Order Details" VALUES(10862,52,7,8,0)
INSERT "Order Details" VALUES(10863,1,18,20,0.15)
INSERT "Order Details" VALUES(10863,58,13.25,12,0.15)
INSERT "Order Details" VALUES(10864,35,18,4,0)
INSERT "Order Details" VALUES(10864,67,14,15,0)
go
INSERT "Order Details" VALUES(10865,38,263.5,60,0.05)
INSERT "Order Details" VALUES(10865,39,18,80,0.05)
INSERT "Order Details" VALUES(10866,2,19,21,0.25)
INSERT "Order Details" VALUES(10866,24,4.5,6,0.25)
INSERT "Order Details" VALUES(10866,30,25.89,40,0.25)
INSERT "Order Details" VALUES(10867,53,32.8,3,0)
INSERT "Order Details" VALUES(10868,26,31.23,20,0)
INSERT "Order Details" VALUES(10868,35,18,30,0)
INSERT "Order Details" VALUES(10868,49,20,42,0.1)
INSERT "Order Details" VALUES(10869,1,18,40,0)
go
INSERT "Order Details" VALUES(10869,11,21,10,0)
INSERT "Order Details" VALUES(10869,23,9,50,0)
INSERT "Order Details" VALUES(10869,68,12.5,20,0)
INSERT "Order Details" VALUES(10870,35,18,3,0)
INSERT "Order Details" VALUES(10870,51,53,2,0)
INSERT "Order Details" VALUES(10871,6,25,50,0.05)
INSERT "Order Details" VALUES(10871,16,17.45,12,0.05)
INSERT "Order Details" VALUES(10871,17,39,16,0.05)
INSERT "Order Details" VALUES(10872,55,24,10,0.05)
INSERT "Order Details" VALUES(10872,62,49.3,20,0.05)
go
INSERT "Order Details" VALUES(10872,64,33.25,15,0.05)
INSERT "Order Details" VALUES(10872,65,21.05,21,0.05)
INSERT "Order Details" VALUES(10873,21,10,20,0)
INSERT "Order Details" VALUES(10873,28,45.6,3,0)
INSERT "Order Details" VALUES(10874,10,31,10,0)
INSERT "Order Details" VALUES(10875,19,9.2,25,0)
INSERT "Order Details" VALUES(10875,47,9.5,21,0.1)
INSERT "Order Details" VALUES(10875,49,20,15,0)
INSERT "Order Details" VALUES(10876,46,12,21,0)
INSERT "Order Details" VALUES(10876,64,33.25,20,0)
go
INSERT "Order Details" VALUES(10877,16,17.45,30,0.25)
INSERT "Order Details" VALUES(10877,18,62.5,25,0)
INSERT "Order Details" VALUES(10878,20,81,20,0.05)
INSERT "Order Details" VALUES(10879,40,18.4,12,0)
INSERT "Order Details" VALUES(10879,65,21.05,10,0)
INSERT "Order Details" VALUES(10879,76,18,10,0)
INSERT "Order Details" VALUES(10880,23,9,30,0.2)
INSERT "Order Details" VALUES(10880,61,28.5,30,0.2)
INSERT "Order Details" VALUES(10880,70,15,50,0.2)
INSERT "Order Details" VALUES(10881,73,15,10,0)
go
INSERT "Order Details" VALUES(10882,42,14,25,0)
INSERT "Order Details" VALUES(10882,49,20,20,0.15)
INSERT "Order Details" VALUES(10882,54,7.45,32,0.15)
INSERT "Order Details" VALUES(10883,24,4.5,8,0)
INSERT "Order Details" VALUES(10884,21,10,40,0.05)
INSERT "Order Details" VALUES(10884,56,38,21,0.05)
INSERT "Order Details" VALUES(10884,65,21.05,12,0.05)
INSERT "Order Details" VALUES(10885,2,19,20,0)
INSERT "Order Details" VALUES(10885,24,4.5,12,0)
INSERT "Order Details" VALUES(10885,70,15,30,0)
go
INSERT "Order Details" VALUES(10885,77,13,25,0)
INSERT "Order Details" VALUES(10886,10,31,70,0)
INSERT "Order Details" VALUES(10886,31,12.5,35,0)
INSERT "Order Details" VALUES(10886,77,13,40,0)
INSERT "Order Details" VALUES(10887,25,14,5,0)
INSERT "Order Details" VALUES(10888,2,19,20,0)
INSERT "Order Details" VALUES(10888,68,12.5,18,0)
INSERT "Order Details" VALUES(10889,11,21,40,0)
INSERT "Order Details" VALUES(10889,38,263.5,40,0)
INSERT "Order Details" VALUES(10890,17,39,15,0)
go
INSERT "Order Details" VALUES(10890,34,14,10,0)
INSERT "Order Details" VALUES(10890,41,9.65,14,0)
INSERT "Order Details" VALUES(10891,30,25.89,15,0.05)
INSERT "Order Details" VALUES(10892,59,55,40,0.05)
INSERT "Order Details" VALUES(10893,8,40,30,0)
INSERT "Order Details" VALUES(10893,24,4.5,10,0)
INSERT "Order Details" VALUES(10893,29,123.79,24,0)
INSERT "Order Details" VALUES(10893,30,25.89,35,0)
INSERT "Order Details" VALUES(10893,36,19,20,0)
INSERT "Order Details" VALUES(10894,13,6,28,0.05)
go
INSERT "Order Details" VALUES(10894,69,36,50,0.05)
INSERT "Order Details" VALUES(10894,75,7.75,120,0.05)
INSERT "Order Details" VALUES(10895,24,4.5,110,0)
INSERT "Order Details" VALUES(10895,39,18,45,0)
INSERT "Order Details" VALUES(10895,40,18.4,91,0)
INSERT "Order Details" VALUES(10895,60,34,100,0)
INSERT "Order Details" VALUES(10896,45,9.5,15,0)
INSERT "Order Details" VALUES(10896,56,38,16,0)
INSERT "Order Details" VALUES(10897,29,123.79,80,0)
INSERT "Order Details" VALUES(10897,30,25.89,36,0)
go
INSERT "Order Details" VALUES(10898,13,6,5,0)
INSERT "Order Details" VALUES(10899,39,18,8,0.15)
INSERT "Order Details" VALUES(10900,70,15,3,0.25)
INSERT "Order Details" VALUES(10901,41,9.65,30,0)
INSERT "Order Details" VALUES(10901,71,21.5,30,0)
INSERT "Order Details" VALUES(10902,55,24,30,0.15)
INSERT "Order Details" VALUES(10902,62,49.3,6,0.15)
INSERT "Order Details" VALUES(10903,13,6,40,0)
INSERT "Order Details" VALUES(10903,65,21.05,21,0)
INSERT "Order Details" VALUES(10903,68,12.5,20,0)
go
INSERT "Order Details" VALUES(10904,58,13.25,15,0)
INSERT "Order Details" VALUES(10904,62,49.3,35,0)
INSERT "Order Details" VALUES(10905,1,18,20,0.05)
INSERT "Order Details" VALUES(10906,61,28.5,15,0)
INSERT "Order Details" VALUES(10907,75,7.75,14,0)
INSERT "Order Details" VALUES(10908,7,30,20,0.05)
INSERT "Order Details" VALUES(10908,52,7,14,0.05)
INSERT "Order Details" VALUES(10909,7,30,12,0)
INSERT "Order Details" VALUES(10909,16,17.45,15,0)
INSERT "Order Details" VALUES(10909,41,9.65,5,0)
go
INSERT "Order Details" VALUES(10910,19,9.2,12,0)
INSERT "Order Details" VALUES(10910,49,20,10,0)
INSERT "Order Details" VALUES(10910,61,28.5,5,0)
INSERT "Order Details" VALUES(10911,1,18,10,0)
INSERT "Order Details" VALUES(10911,17,39,12,0)
INSERT "Order Details" VALUES(10911,67,14,15,0)
INSERT "Order Details" VALUES(10912,11,21,40,0.25)
INSERT "Order Details" VALUES(10912,29,123.79,60,0.25)
INSERT "Order Details" VALUES(10913,4,22,30,0.25)
INSERT "Order Details" VALUES(10913,33,2.5,40,0.25)
go
INSERT "Order Details" VALUES(10913,58,13.25,15,0)
INSERT "Order Details" VALUES(10914,71,21.5,25,0)
INSERT "Order Details" VALUES(10915,17,39,10,0)
INSERT "Order Details" VALUES(10915,33,2.5,30,0)
INSERT "Order Details" VALUES(10915,54,7.45,10,0)
INSERT "Order Details" VALUES(10916,16,17.45,6,0)
INSERT "Order Details" VALUES(10916,32,32,6,0)
INSERT "Order Details" VALUES(10916,57,19.5,20,0)
INSERT "Order Details" VALUES(10917,30,25.89,1,0)
INSERT "Order Details" VALUES(10917,60,34,10,0)
go
INSERT "Order Details" VALUES(10918,1,18,60,0.25)
INSERT "Order Details" VALUES(10918,60,34,25,0.25)
INSERT "Order Details" VALUES(10919,16,17.45,24,0)
INSERT "Order Details" VALUES(10919,25,14,24,0)
INSERT "Order Details" VALUES(10919,40,18.4,20,0)
INSERT "Order Details" VALUES(10920,50,16.25,24,0)
INSERT "Order Details" VALUES(10921,35,18,10,0)
INSERT "Order Details" VALUES(10921,63,43.9,40,0)
INSERT "Order Details" VALUES(10922,17,39,15,0)
INSERT "Order Details" VALUES(10922,24,4.5,35,0)
go
INSERT "Order Details" VALUES(10923,42,14,10,0.2)
INSERT "Order Details" VALUES(10923,43,46,10,0.2)
INSERT "Order Details" VALUES(10923,67,14,24,0.2)
INSERT "Order Details" VALUES(10924,10,31,20,0.1)
INSERT "Order Details" VALUES(10924,28,45.6,30,0.1)
INSERT "Order Details" VALUES(10924,75,7.75,6,0)
INSERT "Order Details" VALUES(10925,36,19,25,0.15)
INSERT "Order Details" VALUES(10925,52,7,12,0.15)
INSERT "Order Details" VALUES(10926,11,21,2,0)
INSERT "Order Details" VALUES(10926,13,6,10,0)
go
INSERT "Order Details" VALUES(10926,19,9.2,7,0)
INSERT "Order Details" VALUES(10926,72,34.8,10,0)
INSERT "Order Details" VALUES(10927,20,81,5,0)
INSERT "Order Details" VALUES(10927,52,7,5,0)
INSERT "Order Details" VALUES(10927,76,18,20,0)
INSERT "Order Details" VALUES(10928,47,9.5,5,0)
INSERT "Order Details" VALUES(10928,76,18,5,0)
INSERT "Order Details" VALUES(10929,21,10,60,0)
INSERT "Order Details" VALUES(10929,75,7.75,49,0)
INSERT "Order Details" VALUES(10929,77,13,15,0)
go
INSERT "Order Details" VALUES(10930,21,10,36,0)
INSERT "Order Details" VALUES(10930,27,43.9,25,0)
INSERT "Order Details" VALUES(10930,55,24,25,0.2)
INSERT "Order Details" VALUES(10930,58,13.25,30,0.2)
INSERT "Order Details" VALUES(10931,13,6,42,0.15)
INSERT "Order Details" VALUES(10931,57,19.5,30,0)
INSERT "Order Details" VALUES(10932,16,17.45,30,0.1)
INSERT "Order Details" VALUES(10932,62,49.3,14,0.1)
INSERT "Order Details" VALUES(10932,72,34.8,16,0)
INSERT "Order Details" VALUES(10932,75,7.75,20,0.1)
go
INSERT "Order Details" VALUES(10933,53,32.8,2,0)
INSERT "Order Details" VALUES(10933,61,28.5,30,0)
INSERT "Order Details" VALUES(10934,6,25,20,0)
INSERT "Order Details" VALUES(10935,1,18,21,0)
INSERT "Order Details" VALUES(10935,18,62.5,4,0.25)
INSERT "Order Details" VALUES(10935,23,9,8,0.25)
INSERT "Order Details" VALUES(10936,36,19,30,0.2)
INSERT "Order Details" VALUES(10937,28,45.6,8,0)
INSERT "Order Details" VALUES(10937,34,14,20,0)
INSERT "Order Details" VALUES(10938,13,6,20,0.25)
go
INSERT "Order Details" VALUES(10938,43,46,24,0.25)
INSERT "Order Details" VALUES(10938,60,34,49,0.25)
INSERT "Order Details" VALUES(10938,71,21.5,35,0.25)
INSERT "Order Details" VALUES(10939,2,19,10,0.15)
INSERT "Order Details" VALUES(10939,67,14,40,0.15)
INSERT "Order Details" VALUES(10940,7,30,8,0)
INSERT "Order Details" VALUES(10940,13,6,20,0)
INSERT "Order Details" VALUES(10941,31,12.5,44,0.25)
INSERT "Order Details" VALUES(10941,62,49.3,30,0.25)
INSERT "Order Details" VALUES(10941,68,12.5,80,0.25)
go
INSERT "Order Details" VALUES(10941,72,34.8,50,0)
INSERT "Order Details" VALUES(10942,49,20,28,0)
INSERT "Order Details" VALUES(10943,13,6,15,0)
INSERT "Order Details" VALUES(10943,22,21,21,0)
INSERT "Order Details" VALUES(10943,46,12,15,0)
INSERT "Order Details" VALUES(10944,11,21,5,0.25)
INSERT "Order Details" VALUES(10944,44,19.45,18,0.25)
INSERT "Order Details" VALUES(10944,56,38,18,0)
INSERT "Order Details" VALUES(10945,13,6,20,0)
INSERT "Order Details" VALUES(10945,31,12.5,10,0)
go
INSERT "Order Details" VALUES(10946,10,31,25,0)
INSERT "Order Details" VALUES(10946,24,4.5,25,0)
INSERT "Order Details" VALUES(10946,77,13,40,0)
INSERT "Order Details" VALUES(10947,59,55,4,0)
INSERT "Order Details" VALUES(10948,50,16.25,9,0)
INSERT "Order Details" VALUES(10948,51,53,40,0)
INSERT "Order Details" VALUES(10948,55,24,4,0)
INSERT "Order Details" VALUES(10949,6,25,12,0)
INSERT "Order Details" VALUES(10949,10,31,30,0)
INSERT "Order Details" VALUES(10949,17,39,6,0)
go
INSERT "Order Details" VALUES(10949,62,49.3,60,0)
INSERT "Order Details" VALUES(10950,4,22,5,0)
INSERT "Order Details" VALUES(10951,33,2.5,15,0.05)
INSERT "Order Details" VALUES(10951,41,9.65,6,0.05)
INSERT "Order Details" VALUES(10951,75,7.75,50,0.05)
INSERT "Order Details" VALUES(10952,6,25,16,0.05)
INSERT "Order Details" VALUES(10952,28,45.6,2,0)
INSERT "Order Details" VALUES(10953,20,81,50,0.05)
INSERT "Order Details" VALUES(10953,31,12.5,50,0.05)
INSERT "Order Details" VALUES(10954,16,17.45,28,0.15)
go
INSERT "Order Details" VALUES(10954,31,12.5,25,0.15)
INSERT "Order Details" VALUES(10954,45,9.5,30,0)
INSERT "Order Details" VALUES(10954,60,34,24,0.15)
INSERT "Order Details" VALUES(10955,75,7.75,12,0.2)
INSERT "Order Details" VALUES(10956,21,10,12,0)
INSERT "Order Details" VALUES(10956,47,9.5,14,0)
INSERT "Order Details" VALUES(10956,51,53,8,0)
INSERT "Order Details" VALUES(10957,30,25.89,30,0)
INSERT "Order Details" VALUES(10957,35,18,40,0)
INSERT "Order Details" VALUES(10957,64,33.25,8,0)
go
INSERT "Order Details" VALUES(10958,5,21.35,20,0)
INSERT "Order Details" VALUES(10958,7,30,6,0)
INSERT "Order Details" VALUES(10958,72,34.8,5,0)
INSERT "Order Details" VALUES(10959,75,7.75,20,0.15)
INSERT "Order Details" VALUES(10960,24,4.5,10,0.25)
INSERT "Order Details" VALUES(10960,41,9.65,24,0)
INSERT "Order Details" VALUES(10961,52,7,6,0.05)
INSERT "Order Details" VALUES(10961,76,18,60,0)
INSERT "Order Details" VALUES(10962,7,30,45,0)
INSERT "Order Details" VALUES(10962,13,6,77,0)
go
INSERT "Order Details" VALUES(10962,53,32.8,20,0)
INSERT "Order Details" VALUES(10962,69,36,9,0)
INSERT "Order Details" VALUES(10962,76,18,44,0)
INSERT "Order Details" VALUES(10963,60,34,2,0.15)
INSERT "Order Details" VALUES(10964,18,62.5,6,0)
INSERT "Order Details" VALUES(10964,38,263.5,5,0)
INSERT "Order Details" VALUES(10964,69,36,10,0)
INSERT "Order Details" VALUES(10965,51,53,16,0)
INSERT "Order Details" VALUES(10966,37,26,8,0)
INSERT "Order Details" VALUES(10966,56,38,12,0.15)
go
INSERT "Order Details" VALUES(10966,62,49.3,12,0.15)
INSERT "Order Details" VALUES(10967,19,9.2,12,0)
INSERT "Order Details" VALUES(10967,49,20,40,0)
INSERT "Order Details" VALUES(10968,12,38,30,0)
INSERT "Order Details" VALUES(10968,24,4.5,30,0)
INSERT "Order Details" VALUES(10968,64,33.25,4,0)
INSERT "Order Details" VALUES(10969,46,12,9,0)
INSERT "Order Details" VALUES(10970,52,7,40,0.2)
INSERT "Order Details" VALUES(10971,29,123.79,14,0)
INSERT "Order Details" VALUES(10972,17,39,6,0)
go
INSERT "Order Details" VALUES(10972,33,2.5,7,0)
INSERT "Order Details" VALUES(10973,26,31.23,5,0)
INSERT "Order Details" VALUES(10973,41,9.65,6,0)
INSERT "Order Details" VALUES(10973,75,7.75,10,0)
INSERT "Order Details" VALUES(10974,63,43.9,10,0)
INSERT "Order Details" VALUES(10975,8,40,16,0)
INSERT "Order Details" VALUES(10975,75,7.75,10,0)
INSERT "Order Details" VALUES(10976,28,45.6,20,0)
INSERT "Order Details" VALUES(10977,39,18,30,0)
INSERT "Order Details" VALUES(10977,47,9.5,30,0)
go
INSERT "Order Details" VALUES(10977,51,53,10,0)
INSERT "Order Details" VALUES(10977,63,43.9,20,0)
INSERT "Order Details" VALUES(10978,8,40,20,0.15)
INSERT "Order Details" VALUES(10978,21,10,40,0.15)
INSERT "Order Details" VALUES(10978,40,18.4,10,0)
INSERT "Order Details" VALUES(10978,44,19.45,6,0.15)
INSERT "Order Details" VALUES(10979,7,30,18,0)
INSERT "Order Details" VALUES(10979,12,38,20,0)
INSERT "Order Details" VALUES(10979,24,4.5,80,0)
INSERT "Order Details" VALUES(10979,27,43.9,30,0)
go
INSERT "Order Details" VALUES(10979,31,12.5,24,0)
INSERT "Order Details" VALUES(10979,63,43.9,35,0)
INSERT "Order Details" VALUES(10980,75,7.75,40,0.2)
INSERT "Order Details" VALUES(10981,38,263.5,60,0)
INSERT "Order Details" VALUES(10982,7,30,20,0)
INSERT "Order Details" VALUES(10982,43,46,9,0)
INSERT "Order Details" VALUES(10983,13,6,84,0.15)
INSERT "Order Details" VALUES(10983,57,19.5,15,0)
INSERT "Order Details" VALUES(10984,16,17.45,55,0)
INSERT "Order Details" VALUES(10984,24,4.5,20,0)
go
INSERT "Order Details" VALUES(10984,36,19,40,0)
INSERT "Order Details" VALUES(10985,16,17.45,36,0.1)
INSERT "Order Details" VALUES(10985,18,62.5,8,0.1)
INSERT "Order Details" VALUES(10985,32,32,35,0.1)
INSERT "Order Details" VALUES(10986,11,21,30,0)
INSERT "Order Details" VALUES(10986,20,81,15,0)
INSERT "Order Details" VALUES(10986,76,18,10,0)
INSERT "Order Details" VALUES(10986,77,13,15,0)
INSERT "Order Details" VALUES(10987,7,30,60,0)
INSERT "Order Details" VALUES(10987,43,46,6,0)
go
INSERT "Order Details" VALUES(10987,72,34.8,20,0)
INSERT "Order Details" VALUES(10988,7,30,60,0)
INSERT "Order Details" VALUES(10988,62,49.3,40,0.1)
INSERT "Order Details" VALUES(10989,6,25,40,0)
INSERT "Order Details" VALUES(10989,11,21,15,0)
INSERT "Order Details" VALUES(10989,41,9.65,4,0)
INSERT "Order Details" VALUES(10990,21,10,65,0)
INSERT "Order Details" VALUES(10990,34,14,60,0.15)
INSERT "Order Details" VALUES(10990,55,24,65,0.15)
INSERT "Order Details" VALUES(10990,61,28.5,66,0.15)
go
INSERT "Order Details" VALUES(10991,2,19,50,0.2)
INSERT "Order Details" VALUES(10991,70,15,20,0.2)
INSERT "Order Details" VALUES(10991,76,18,90,0.2)
INSERT "Order Details" VALUES(10992,72,34.8,2,0)
INSERT "Order Details" VALUES(10993,29,123.79,50,0.25)
INSERT "Order Details" VALUES(10993,41,9.65,35,0.25)
INSERT "Order Details" VALUES(10994,59,55,18,0.05)
INSERT "Order Details" VALUES(10995,51,53,20,0)
INSERT "Order Details" VALUES(10995,60,34,4,0)
INSERT "Order Details" VALUES(10996,42,14,40,0)
go
INSERT "Order Details" VALUES(10997,32,32,50,0)
INSERT "Order Details" VALUES(10997,46,12,20,0.25)
INSERT "Order Details" VALUES(10997,52,7,20,0.25)
INSERT "Order Details" VALUES(10998,24,4.5,12,0)
INSERT "Order Details" VALUES(10998,61,28.5,7,0)
INSERT "Order Details" VALUES(10998,74,10,20,0)
INSERT "Order Details" VALUES(10998,75,7.75,30,0)
INSERT "Order Details" VALUES(10999,41,9.65,20,0.05)
INSERT "Order Details" VALUES(10999,51,53,15,0.05)
INSERT "Order Details" VALUES(10999,77,13,21,0.05)
go
INSERT "Order Details" VALUES(11000,4,22,25,0.25)
INSERT "Order Details" VALUES(11000,24,4.5,30,0.25)
INSERT "Order Details" VALUES(11000,77,13,30,0)
INSERT "Order Details" VALUES(11001,7,30,60,0)
INSERT "Order Details" VALUES(11001,22,21,25,0)
INSERT "Order Details" VALUES(11001,46,12,25,0)
INSERT "Order Details" VALUES(11001,55,24,6,0)
INSERT "Order Details" VALUES(11002,13,6,56,0)
INSERT "Order Details" VALUES(11002,35,18,15,0.15)
INSERT "Order Details" VALUES(11002,42,14,24,0.15)
go
INSERT "Order Details" VALUES(11002,55,24,40,0)
INSERT "Order Details" VALUES(11003,1,18,4,0)
INSERT "Order Details" VALUES(11003,40,18.4,10,0)
INSERT "Order Details" VALUES(11003,52,7,10,0)
INSERT "Order Details" VALUES(11004,26,31.23,6,0)
INSERT "Order Details" VALUES(11004,76,18,6,0)
INSERT "Order Details" VALUES(11005,1,18,2,0)
INSERT "Order Details" VALUES(11005,59,55,10,0)
INSERT "Order Details" VALUES(11006,1,18,8,0)
INSERT "Order Details" VALUES(11006,29,123.79,2,0.25)
go
INSERT "Order Details" VALUES(11007,8,40,30,0)
INSERT "Order Details" VALUES(11007,29,123.79,10,0)
INSERT "Order Details" VALUES(11007,42,14,14,0)
INSERT "Order Details" VALUES(11008,28,45.6,70,0.05)
INSERT "Order Details" VALUES(11008,34,14,90,0.05)
INSERT "Order Details" VALUES(11008,71,21.5,21,0)
INSERT "Order Details" VALUES(11009,24,4.5,12,0)
INSERT "Order Details" VALUES(11009,36,19,18,0.25)
INSERT "Order Details" VALUES(11009,60,34,9,0)
INSERT "Order Details" VALUES(11010,7,30,20,0)
go
INSERT "Order Details" VALUES(11010,24,4.5,10,0)
INSERT "Order Details" VALUES(11011,58,13.25,40,0.05)
INSERT "Order Details" VALUES(11011,71,21.5,20,0)
INSERT "Order Details" VALUES(11012,19,9.2,50,0.05)
INSERT "Order Details" VALUES(11012,60,34,36,0.05)
INSERT "Order Details" VALUES(11012,71,21.5,60,0.05)
INSERT "Order Details" VALUES(11013,23,9,10,0)
INSERT "Order Details" VALUES(11013,42,14,4,0)
INSERT "Order Details" VALUES(11013,45,9.5,20,0)
INSERT "Order Details" VALUES(11013,68,12.5,2,0)
go
INSERT "Order Details" VALUES(11014,41,9.65,28,0.1)
INSERT "Order Details" VALUES(11015,30,25.89,15,0)
INSERT "Order Details" VALUES(11015,77,13,18,0)
INSERT "Order Details" VALUES(11016,31,12.5,15,0)
INSERT "Order Details" VALUES(11016,36,19,16,0)
INSERT "Order Details" VALUES(11017,3,10,25,0)
INSERT "Order Details" VALUES(11017,59,55,110,0)
INSERT "Order Details" VALUES(11017,70,15,30,0)
INSERT "Order Details" VALUES(11018,12,38,20,0)
INSERT "Order Details" VALUES(11018,18,62.5,10,0)
go
INSERT "Order Details" VALUES(11018,56,38,5,0)
INSERT "Order Details" VALUES(11019,46,12,3,0)
INSERT "Order Details" VALUES(11019,49,20,2,0)
INSERT "Order Details" VALUES(11020,10,31,24,0.15)
INSERT "Order Details" VALUES(11021,2,19,11,0.25)
INSERT "Order Details" VALUES(11021,20,81,15,0)
INSERT "Order Details" VALUES(11021,26,31.23,63,0)
INSERT "Order Details" VALUES(11021,51,53,44,0.25)
INSERT "Order Details" VALUES(11021,72,34.8,35,0)
INSERT "Order Details" VALUES(11022,19,9.2,35,0)
go
INSERT "Order Details" VALUES(11022,69,36,30,0)
INSERT "Order Details" VALUES(11023,7,30,4,0)
INSERT "Order Details" VALUES(11023,43,46,30,0)
INSERT "Order Details" VALUES(11024,26,31.23,12,0)
INSERT "Order Details" VALUES(11024,33,2.5,30,0)
INSERT "Order Details" VALUES(11024,65,21.05,21,0)
INSERT "Order Details" VALUES(11024,71,21.5,50,0)
INSERT "Order Details" VALUES(11025,1,18,10,0.1)
INSERT "Order Details" VALUES(11025,13,6,20,0.1)
INSERT "Order Details" VALUES(11026,18,62.5,8,0)
go
INSERT "Order Details" VALUES(11026,51,53,10,0)
INSERT "Order Details" VALUES(11027,24,4.5,30,0.25)
INSERT "Order Details" VALUES(11027,62,49.3,21,0.25)
INSERT "Order Details" VALUES(11028,55,24,35,0)
INSERT "Order Details" VALUES(11028,59,55,24,0)
INSERT "Order Details" VALUES(11029,56,38,20,0)
INSERT "Order Details" VALUES(11029,63,43.9,12,0)
INSERT "Order Details" VALUES(11030,2,19,100,0.25)
INSERT "Order Details" VALUES(11030,5,21.35,70,0)
INSERT "Order Details" VALUES(11030,29,123.79,60,0.25)
go
INSERT "Order Details" VALUES(11030,59,55,100,0.25)
INSERT "Order Details" VALUES(11031,1,18,45,0)
INSERT "Order Details" VALUES(11031,13,6,80,0)
INSERT "Order Details" VALUES(11031,24,4.5,21,0)
INSERT "Order Details" VALUES(11031,64,33.25,20,0)
INSERT "Order Details" VALUES(11031,71,21.5,16,0)
INSERT "Order Details" VALUES(11032,36,19,35,0)
INSERT "Order Details" VALUES(11032,38,263.5,25,0)
INSERT "Order Details" VALUES(11032,59,55,30,0)
INSERT "Order Details" VALUES(11033,53,32.8,70,0.1)
go
INSERT "Order Details" VALUES(11033,69,36,36,0.1)
INSERT "Order Details" VALUES(11034,21,10,15,0.1)
INSERT "Order Details" VALUES(11034,44,19.45,12,0)
INSERT "Order Details" VALUES(11034,61,28.5,6,0)
INSERT "Order Details" VALUES(11035,1,18,10,0)
INSERT "Order Details" VALUES(11035,35,18,60,0)
INSERT "Order Details" VALUES(11035,42,14,30,0)
INSERT "Order Details" VALUES(11035,54,7.45,10,0)
INSERT "Order Details" VALUES(11036,13,6,7,0)
INSERT "Order Details" VALUES(11036,59,55,30,0)
go
INSERT "Order Details" VALUES(11037,70,15,4,0)
INSERT "Order Details" VALUES(11038,40,18.4,5,0.2)
INSERT "Order Details" VALUES(11038,52,7,2,0)
INSERT "Order Details" VALUES(11038,71,21.5,30,0)
INSERT "Order Details" VALUES(11039,28,45.6,20,0)
INSERT "Order Details" VALUES(11039,35,18,24,0)
INSERT "Order Details" VALUES(11039,49,20,60,0)
INSERT "Order Details" VALUES(11039,57,19.5,28,0)
INSERT "Order Details" VALUES(11040,21,10,20,0)
INSERT "Order Details" VALUES(11041,2,19,30,0.2)
go
INSERT "Order Details" VALUES(11041,63,43.9,30,0)
INSERT "Order Details" VALUES(11042,44,19.45,15,0)
INSERT "Order Details" VALUES(11042,61,28.5,4,0)
INSERT "Order Details" VALUES(11043,11,21,10,0)
INSERT "Order Details" VALUES(11044,62,49.3,12,0)
INSERT "Order Details" VALUES(11045,33,2.5,15,0)
INSERT "Order Details" VALUES(11045,51,53,24,0)
INSERT "Order Details" VALUES(11046,12,38,20,0.05)
INSERT "Order Details" VALUES(11046,32,32,15,0.05)
INSERT "Order Details" VALUES(11046,35,18,18,0.05)
go
INSERT "Order Details" VALUES(11047,1,18,25,0.25)
INSERT "Order Details" VALUES(11047,5,21.35,30,0.25)
INSERT "Order Details" VALUES(11048,68,12.5,42,0)
INSERT "Order Details" VALUES(11049,2,19,10,0.2)
INSERT "Order Details" VALUES(11049,12,38,4,0.2)
INSERT "Order Details" VALUES(11050,76,18,50,0.1)
INSERT "Order Details" VALUES(11051,24,4.5,10,0.2)
INSERT "Order Details" VALUES(11052,43,46,30,0.2)
INSERT "Order Details" VALUES(11052,61,28.5,10,0.2)
INSERT "Order Details" VALUES(11053,18,62.5,35,0.2)
go
INSERT "Order Details" VALUES(11053,32,32,20,0)
INSERT "Order Details" VALUES(11053,64,33.25,25,0.2)
INSERT "Order Details" VALUES(11054,33,2.5,10,0)
INSERT "Order Details" VALUES(11054,67,14,20,0)
INSERT "Order Details" VALUES(11055,24,4.5,15,0)
INSERT "Order Details" VALUES(11055,25,14,15,0)
INSERT "Order Details" VALUES(11055,51,53,20,0)
INSERT "Order Details" VALUES(11055,57,19.5,20,0)
INSERT "Order Details" VALUES(11056,7,30,40,0)
INSERT "Order Details" VALUES(11056,55,24,35,0)
go
INSERT "Order Details" VALUES(11056,60,34,50,0)
INSERT "Order Details" VALUES(11057,70,15,3,0)
INSERT "Order Details" VALUES(11058,21,10,3,0)
INSERT "Order Details" VALUES(11058,60,34,21,0)
INSERT "Order Details" VALUES(11058,61,28.5,4,0)
INSERT "Order Details" VALUES(11059,13,6,30,0)
INSERT "Order Details" VALUES(11059,17,39,12,0)
INSERT "Order Details" VALUES(11059,60,34,35,0)
INSERT "Order Details" VALUES(11060,60,34,4,0)
INSERT "Order Details" VALUES(11060,77,13,10,0)
go
INSERT "Order Details" VALUES(11061,60,34,15,0)
INSERT "Order Details" VALUES(11062,53,32.8,10,0.2)
INSERT "Order Details" VALUES(11062,70,15,12,0.2)
INSERT "Order Details" VALUES(11063,34,14,30,0)
INSERT "Order Details" VALUES(11063,40,18.4,40,0.1)
INSERT "Order Details" VALUES(11063,41,9.65,30,0.1)
INSERT "Order Details" VALUES(11064,17,39,77,0.1)
INSERT "Order Details" VALUES(11064,41,9.65,12,0)
INSERT "Order Details" VALUES(11064,53,32.8,25,0.1)
INSERT "Order Details" VALUES(11064,55,24,4,0.1)
go
INSERT "Order Details" VALUES(11064,68,12.5,55,0)
INSERT "Order Details" VALUES(11065,30,25.89,4,0.25)
INSERT "Order Details" VALUES(11065,54,7.45,20,0.25)
INSERT "Order Details" VALUES(11066,16,17.45,3,0)
INSERT "Order Details" VALUES(11066,19,9.2,42,0)
INSERT "Order Details" VALUES(11066,34,14,35,0)
INSERT "Order Details" VALUES(11067,41,9.65,9,0)
INSERT "Order Details" VALUES(11068,28,45.6,8,0.15)
INSERT "Order Details" VALUES(11068,43,46,36,0.15)
INSERT "Order Details" VALUES(11068,77,13,28,0.15)
go
INSERT "Order Details" VALUES(11069,39,18,20,0)
INSERT "Order Details" VALUES(11070,1,18,40,0.15)
INSERT "Order Details" VALUES(11070,2,19,20,0.15)
INSERT "Order Details" VALUES(11070,16,17.45,30,0.15)
INSERT "Order Details" VALUES(11070,31,12.5,20,0)
INSERT "Order Details" VALUES(11071,7,30,15,0.05)
INSERT "Order Details" VALUES(11071,13,6,10,0.05)
INSERT "Order Details" VALUES(11072,2,19,8,0)
INSERT "Order Details" VALUES(11072,41,9.65,40,0)
INSERT "Order Details" VALUES(11072,50,16.25,22,0)
go
INSERT "Order Details" VALUES(11072,64,33.25,130,0)
INSERT "Order Details" VALUES(11073,11,21,10,0)
INSERT "Order Details" VALUES(11073,24,4.5,20,0)
INSERT "Order Details" VALUES(11074,16,17.45,14,0.05)
INSERT "Order Details" VALUES(11075,2,19,10,0.15)
INSERT "Order Details" VALUES(11075,46,12,30,0.15)
INSERT "Order Details" VALUES(11075,76,18,2,0.15)
INSERT "Order Details" VALUES(11076,6,25,20,0.25)
INSERT "Order Details" VALUES(11076,14,23.25,20,0.25)
INSERT "Order Details" VALUES(11076,19,9.2,10,0.25)
go
INSERT "Order Details" VALUES(11077,2,19,24,0.2)
INSERT "Order Details" VALUES(11077,3,10,4,0)
INSERT "Order Details" VALUES(11077,4,22,1,0)
INSERT "Order Details" VALUES(11077,6,25,1,0.02)
INSERT "Order Details" VALUES(11077,7,30,1,0.05)
INSERT "Order Details" VALUES(11077,8,40,2,0.1)
INSERT "Order Details" VALUES(11077,10,31,1,0)
INSERT "Order Details" VALUES(11077,12,38,2,0.05)
INSERT "Order Details" VALUES(11077,13,6,4,0)
INSERT "Order Details" VALUES(11077,14,23.25,1,0.03)
go
INSERT "Order Details" VALUES(11077,16,17.45,2,0.03)
INSERT "Order Details" VALUES(11077,20,81,1,0.04)
INSERT "Order Details" VALUES(11077,23,9,2,0)
INSERT "Order Details" VALUES(11077,32,32,1,0)
INSERT "Order Details" VALUES(11077,39,18,2,0.05)
INSERT "Order Details" VALUES(11077,41,9.65,3,0)
INSERT "Order Details" VALUES(11077,46,12,3,0.02)
INSERT "Order Details" VALUES(11077,52,7,2,0)
INSERT "Order Details" VALUES(11077,55,24,2,0)
INSERT "Order Details" VALUES(11077,60,34,2,0.06)
go
INSERT "Order Details" VALUES(11077,64,33.25,2,0.03)
INSERT "Order Details" VALUES(11077,66,17,1,0)
INSERT "Order Details" VALUES(11077,73,15,2,0.01)
INSERT "Order Details" VALUES(11077,75,7.75,4,0)
INSERT "Order Details" VALUES(11077,77,13,2,0)
go
ALTER TABLE "Order Details" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "Orders" on
go
ALTER TABLE "Orders" NOCHECK CONSTRAINT ALL
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10248,'VINET',5,'07/04/1996','08/01/1996','07/16/1996',3,32.38,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10249,'TOMSP',6,'07/05/1996','08/16/1996','07/10/1996',1,11.61,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10250,'HANAR',4,'07/08/1996','08/05/1996','07/12/1996',2,65.83,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10251,'VICTE',3,'07/08/1996','08/05/1996','07/15/1996',1,41.34,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10252,'SUPRD',4,'07/09/1996','08/06/1996','07/11/1996',2,51.3,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10253,'HANAR',3,'07/10/1996','07/24/1996','07/16/1996',2,58.17,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10254,'CHOPS',5,'07/11/1996','08/08/1996','07/23/1996',2,22.98,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10255,'RICSU',9,'07/12/1996','08/09/1996','07/15/1996',3,148.33,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10256,'WELLI',3,'07/15/1996','08/12/1996','07/17/1996',2,13.97,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10257,'HILAA',4,'07/16/1996','08/13/1996','07/22/1996',3,81.91,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10258,'ERNSH',1,'07/17/1996','08/14/1996','07/23/1996',1,140.51,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10259,'CENTC',4,'07/18/1996','08/15/1996','07/25/1996',3,3.25,'Centro comercial Moctezuma','Sierras de Granada 9993','Mxico D.F.',NULL,'05022','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10260,'OTTIK',4,'07/19/1996','08/16/1996','07/29/1996',1,55.09,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10261,'QUEDE',4,'07/19/1996','08/16/1996','07/30/1996',2,3.05,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10262,'RATTC',8,'07/22/1996','08/19/1996','07/25/1996',3,48.29,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10263,'ERNSH',9,'07/23/1996','08/20/1996','07/31/1996',3,146.06,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10264,'FOLKO',6,'07/24/1996','08/21/1996','08/23/1996',3,3.67,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10265,'BLONP',2,'07/25/1996','08/22/1996','08/12/1996',1,55.28,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10266,'WARTH',3,'07/26/1996','09/06/1996','07/31/1996',3,25.73,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10267,'FRANK',4,'07/29/1996','08/26/1996','08/06/1996',1,208.58,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10268,'GROSR',8,'07/30/1996','08/27/1996','08/02/1996',3,66.29,'GROSELLA-Restaurante','5 Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10269,'WHITC',5,'07/31/1996','08/14/1996','08/09/1996',1,4.56,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10270,'WARTH',1,'08/01/1996','08/29/1996','08/02/1996',1,136.54,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10271,'SPLIR',6,'08/01/1996','08/29/1996','08/30/1996',2,4.54,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10272,'RATTC',6,'08/02/1996','08/30/1996','08/06/1996',2,98.03,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10273,'QUICK',3,'08/05/1996','09/02/1996','08/12/1996',3,76.07,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10274,'VINET',6,'08/06/1996','09/03/1996','08/16/1996',1,6.01,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10275,'MAGAA',1,'08/07/1996','09/04/1996','08/09/1996',1,26.93,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10276,'TORTU',8,'08/08/1996','08/22/1996','08/14/1996',3,13.84,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10277,'MORGK',2,'08/09/1996','09/06/1996','08/13/1996',3,125.77,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10278,'BERGS',8,'08/12/1996','09/09/1996','08/16/1996',2,92.69,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10279,'LEHMS',8,'08/13/1996','09/10/1996','08/16/1996',2,25.83,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10280,'BERGS',2,'08/14/1996','09/11/1996','09/12/1996',1,8.98,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10281,'ROMEY',4,'08/14/1996','08/28/1996','08/21/1996',1,2.94,'Romero y tomillo','Gran Va, 1','Madrid',NULL,'28001','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10282,'ROMEY',4,'08/15/1996','09/12/1996','08/21/1996',1,12.69,'Romero y tomillo','Gran Va, 1','Madrid',NULL,'28001','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10283,'LILAS',3,'08/16/1996','09/13/1996','08/23/1996',3,84.81,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10284,'LEHMS',4,'08/19/1996','09/16/1996','08/27/1996',1,76.56,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10285,'QUICK',1,'08/20/1996','09/17/1996','08/26/1996',2,76.83,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10286,'QUICK',8,'08/21/1996','09/18/1996','08/30/1996',3,229.24,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10287,'RICAR',8,'08/22/1996','09/19/1996','08/28/1996',3,12.76,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10288,'REGGC',4,'08/23/1996','09/20/1996','09/03/1996',1,7.45,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10289,'BSBEV',7,'08/26/1996','09/23/1996','08/28/1996',3,22.77,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10290,'COMMI',8,'08/27/1996','09/24/1996','09/03/1996',1,79.7,'Comrcio Mineiro','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10291,'QUEDE',6,'08/27/1996','09/24/1996','09/04/1996',2,6.4,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10292,'TRADH',1,'08/28/1996','09/25/1996','09/02/1996',2,1.35,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10293,'TORTU',1,'08/29/1996','09/26/1996','09/11/1996',3,21.18,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10294,'RATTC',4,'08/30/1996','09/27/1996','09/05/1996',2,147.26,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10295,'VINET',2,'09/02/1996','09/30/1996','09/10/1996',2,1.15,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10296,'LILAS',6,'09/03/1996','10/01/1996','09/11/1996',1,0.12,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10297,'BLONP',5,'09/04/1996','10/16/1996','09/10/1996',2,5.74,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10298,'HUNGO',6,'09/05/1996','10/03/1996','09/11/1996',2,168.22,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10299,'RICAR',4,'09/06/1996','10/04/1996','09/13/1996',2,29.76,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10300,'MAGAA',2,'09/09/1996','10/07/1996','09/18/1996',2,17.68,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10301,'WANDK',8,'09/09/1996','10/07/1996','09/17/1996',2,45.08,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10302,'SUPRD',4,'09/10/1996','10/08/1996','10/09/1996',2,6.27,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10303,'GODOS',7,'09/11/1996','10/09/1996','09/18/1996',2,107.83,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10304,'TORTU',1,'09/12/1996','10/10/1996','09/17/1996',2,63.79,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10305,'OLDWO',8,'09/13/1996','10/11/1996','10/09/1996',3,257.62,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10306,'ROMEY',1,'09/16/1996','10/14/1996','09/23/1996',3,7.56,'Romero y tomillo','Gran Va, 1','Madrid',NULL,'28001','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10307,'LONEP',2,'09/17/1996','10/15/1996','09/25/1996',2,0.56,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10308,'ANATR',7,'09/18/1996','10/16/1996','09/24/1996',3,1.61,'Ana Trujillo Emparedados y helados','Avda. de la Constitucin 2222','Mxico D.F.',NULL,'05021','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10309,'HUNGO',3,'09/19/1996','10/17/1996','10/23/1996',1,47.3,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10310,'THEBI',8,'09/20/1996','10/18/1996','09/27/1996',2,17.52,'The Big Cheese','89 Jefferson Way
Suite 2','Portland','OR','97201','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10311,'DUMON',1,'09/20/1996','10/04/1996','09/26/1996',3,24.69,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10312,'WANDK',2,'09/23/1996','10/21/1996','10/03/1996',2,40.26,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10313,'QUICK',2,'09/24/1996','10/22/1996','10/04/1996',2,1.96,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10314,'RATTC',1,'09/25/1996','10/23/1996','10/04/1996',2,74.16,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10315,'ISLAT',4,'09/26/1996','10/24/1996','10/03/1996',2,41.76,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10316,'RATTC',1,'09/27/1996','10/25/1996','10/08/1996',3,150.15,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10317,'LONEP',6,'09/30/1996','10/28/1996','10/10/1996',1,12.69,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10318,'ISLAT',8,'10/01/1996','10/29/1996','10/04/1996',2,4.73,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10319,'TORTU',7,'10/02/1996','10/30/1996','10/11/1996',3,64.5,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10320,'WARTH',5,'10/03/1996','10/17/1996','10/18/1996',3,34.57,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10321,'ISLAT',3,'10/03/1996','10/31/1996','10/11/1996',2,3.43,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10322,'PERIC',7,'10/04/1996','11/01/1996','10/23/1996',3,0.4,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10323,'KOENE',4,'10/07/1996','11/04/1996','10/14/1996',1,4.88,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10324,'SAVEA',9,'10/08/1996','11/05/1996','10/10/1996',1,214.27,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10325,'KOENE',1,'10/09/1996','10/23/1996','10/14/1996',3,64.86,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10326,'BOLID',4,'10/10/1996','11/07/1996','10/14/1996',2,77.92,'Blido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10327,'FOLKO',2,'10/11/1996','11/08/1996','10/14/1996',1,63.36,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10328,'FURIB',4,'10/14/1996','11/11/1996','10/17/1996',3,87.03,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10329,'SPLIR',4,'10/15/1996','11/26/1996','10/23/1996',2,191.67,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10330,'LILAS',3,'10/16/1996','11/13/1996','10/28/1996',1,12.75,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10331,'BONAP',9,'10/16/1996','11/27/1996','10/21/1996',1,10.19,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10332,'MEREP',3,'10/17/1996','11/28/1996','10/21/1996',2,52.84,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10333,'WARTH',5,'10/18/1996','11/15/1996','10/25/1996',3,0.59,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10334,'VICTE',8,'10/21/1996','11/18/1996','10/28/1996',2,8.56,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10335,'HUNGO',7,'10/22/1996','11/19/1996','10/24/1996',2,42.11,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10336,'PRINI',7,'10/23/1996','11/20/1996','10/25/1996',2,15.51,'Princesa Isabel Vinhos','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10337,'FRANK',4,'10/24/1996','11/21/1996','10/29/1996',3,108.26,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10338,'OLDWO',4,'10/25/1996','11/22/1996','10/29/1996',3,84.21,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10339,'MEREP',2,'10/28/1996','11/25/1996','11/04/1996',2,15.66,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10340,'BONAP',1,'10/29/1996','11/26/1996','11/08/1996',3,166.31,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10341,'SIMOB',7,'10/29/1996','11/26/1996','11/05/1996',3,26.78,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10342,'FRANK',4,'10/30/1996','11/13/1996','11/04/1996',2,54.83,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10343,'LEHMS',4,'10/31/1996','11/28/1996','11/06/1996',1,110.37,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10344,'WHITC',4,'11/01/1996','11/29/1996','11/05/1996',2,23.29,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10345,'QUICK',2,'11/04/1996','12/02/1996','11/11/1996',2,249.06,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10346,'RATTC',3,'11/05/1996','12/17/1996','11/08/1996',3,142.08,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10347,'FAMIA',4,'11/06/1996','12/04/1996','11/08/1996',3,3.1,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10348,'WANDK',4,'11/07/1996','12/05/1996','11/15/1996',2,0.78,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10349,'SPLIR',7,'11/08/1996','12/06/1996','11/15/1996',1,8.63,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10350,'LAMAI',6,'11/11/1996','12/09/1996','12/03/1996',2,64.19,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10351,'ERNSH',1,'11/11/1996','12/09/1996','11/20/1996',1,162.33,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10352,'FURIB',3,'11/12/1996','11/26/1996','11/18/1996',3,1.3,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10353,'PICCO',7,'11/13/1996','12/11/1996','11/25/1996',3,360.63,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10354,'PERIC',8,'11/14/1996','12/12/1996','11/20/1996',3,53.8,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10355,'AROUT',6,'11/15/1996','12/13/1996','11/20/1996',1,41.95,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10356,'WANDK',6,'11/18/1996','12/16/1996','11/27/1996',2,36.71,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10357,'LILAS',1,'11/19/1996','12/17/1996','12/02/1996',3,34.88,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10358,'LAMAI',5,'11/20/1996','12/18/1996','11/27/1996',1,19.64,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10359,'SEVES',5,'11/21/1996','12/19/1996','11/26/1996',3,288.43,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10360,'BLONP',4,'11/22/1996','12/20/1996','12/02/1996',3,131.7,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10361,'QUICK',1,'11/22/1996','12/20/1996','12/03/1996',2,183.17,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10362,'BONAP',3,'11/25/1996','12/23/1996','11/28/1996',1,96.04,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10363,'DRACD',4,'11/26/1996','12/24/1996','12/04/1996',3,30.54,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10364,'EASTC',1,'11/26/1996','01/07/1997','12/04/1996',1,71.97,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10365,'ANTON',3,'11/27/1996','12/25/1996','12/02/1996',2,22,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10366,'GALED',8,'11/28/1996','01/09/1997','12/30/1996',2,10.14,'Galera del gastronmo','Rambla de Catalua, 23','Barcelona',NULL,'8022','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10367,'VAFFE',7,'11/28/1996','12/26/1996','12/02/1996',3,13.55,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10368,'ERNSH',2,'11/29/1996','12/27/1996','12/02/1996',2,101.95,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10369,'SPLIR',8,'12/02/1996','12/30/1996','12/09/1996',2,195.68,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10370,'CHOPS',6,'12/03/1996','12/31/1996','12/27/1996',2,1.17,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10371,'LAMAI',1,'12/03/1996','12/31/1996','12/24/1996',1,0.45,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10372,'QUEEN',5,'12/04/1996','01/01/1997','12/09/1996',2,890.78,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10373,'HUNGO',4,'12/05/1996','01/02/1997','12/11/1996',3,124.12,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10374,'WOLZA',1,'12/05/1996','01/02/1997','12/09/1996',3,3.94,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10375,'HUNGC',3,'12/06/1996','01/03/1997','12/09/1996',2,20.12,'Hungry Coyote Import Store','City Center Plaza
516 Main St.','Elgin','OR','97827','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10376,'MEREP',1,'12/09/1996','01/06/1997','12/13/1996',2,20.39,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10377,'SEVES',1,'12/09/1996','01/06/1997','12/13/1996',3,22.21,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10378,'FOLKO',5,'12/10/1996','01/07/1997','12/19/1996',3,5.44,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10379,'QUEDE',2,'12/11/1996','01/08/1997','12/13/1996',1,45.03,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10380,'HUNGO',8,'12/12/1996','01/09/1997','01/16/1997',3,35.03,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10381,'LILAS',3,'12/12/1996','01/09/1997','12/13/1996',3,7.99,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10382,'ERNSH',4,'12/13/1996','01/10/1997','12/16/1996',1,94.77,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10383,'AROUT',8,'12/16/1996','01/13/1997','12/18/1996',3,34.24,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10384,'BERGS',3,'12/16/1996','01/13/1997','12/20/1996',3,168.64,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10385,'SPLIR',1,'12/17/1996','01/14/1997','12/23/1996',2,30.96,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10386,'FAMIA',9,'12/18/1996','01/01/1997','12/25/1996',3,13.99,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10387,'SANTG',1,'12/18/1996','01/15/1997','12/20/1996',2,93.63,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10388,'SEVES',2,'12/19/1996','01/16/1997','12/20/1996',1,34.86,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10389,'BOTTM',4,'12/20/1996','01/17/1997','12/24/1996',2,47.42,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10390,'ERNSH',6,'12/23/1996','01/20/1997','12/26/1996',1,126.38,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10391,'DRACD',3,'12/23/1996','01/20/1997','12/31/1996',3,5.45,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10392,'PICCO',2,'12/24/1996','01/21/1997','01/01/1997',3,122.46,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10393,'SAVEA',1,'12/25/1996','01/22/1997','01/03/1997',3,126.56,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10394,'HUNGC',1,'12/25/1996','01/22/1997','01/03/1997',3,30.34,'Hungry Coyote Import Store','City Center Plaza
516 Main St.','Elgin','OR','97827','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10395,'HILAA',6,'12/26/1996','01/23/1997','01/03/1997',1,184.41,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10396,'FRANK',1,'12/27/1996','01/10/1997','01/06/1997',3,135.35,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10397,'PRINI',5,'12/27/1996','01/24/1997','01/02/1997',1,60.26,'Princesa Isabel Vinhos','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10398,'SAVEA',2,'12/30/1996','01/27/1997','01/09/1997',3,89.16,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10399,'VAFFE',8,'12/31/1996','01/14/1997','01/08/1997',3,27.36,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10400,'EASTC',1,'01/01/1997','01/29/1997','01/16/1997',3,83.93,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10401,'RATTC',1,'01/01/1997','01/29/1997','01/10/1997',1,12.51,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10402,'ERNSH',8,'01/02/1997','02/13/1997','01/10/1997',2,67.88,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10403,'ERNSH',4,'01/03/1997','01/31/1997','01/09/1997',3,73.79,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10404,'MAGAA',2,'01/03/1997','01/31/1997','01/08/1997',1,155.97,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10405,'LINOD',1,'01/06/1997','02/03/1997','01/22/1997',1,34.82,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10406,'QUEEN',7,'01/07/1997','02/18/1997','01/13/1997',1,108.04,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10407,'OTTIK',2,'01/07/1997','02/04/1997','01/30/1997',2,91.48,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10408,'FOLIG',8,'01/08/1997','02/05/1997','01/14/1997',1,11.26,'Folies gourmandes','184, chausse de Tournai','Lille',NULL,'59000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10409,'OCEAN',3,'01/09/1997','02/06/1997','01/14/1997',1,29.83,'Ocano Atlntico Ltda.','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10410,'BOTTM',3,'01/10/1997','02/07/1997','01/15/1997',3,2.4,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10411,'BOTTM',9,'01/10/1997','02/07/1997','01/21/1997',3,23.65,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10412,'WARTH',8,'01/13/1997','02/10/1997','01/15/1997',2,3.77,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10413,'LAMAI',3,'01/14/1997','02/11/1997','01/16/1997',2,95.66,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10414,'FAMIA',2,'01/14/1997','02/11/1997','01/17/1997',3,21.48,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10415,'HUNGC',3,'01/15/1997','02/12/1997','01/24/1997',1,0.2,'Hungry Coyote Import Store','City Center Plaza
516 Main St.','Elgin','OR','97827','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10416,'WARTH',8,'01/16/1997','02/13/1997','01/27/1997',3,22.72,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10417,'SIMOB',4,'01/16/1997','02/13/1997','01/28/1997',3,70.29,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10418,'QUICK',4,'01/17/1997','02/14/1997','01/24/1997',1,17.55,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10419,'RICSU',4,'01/20/1997','02/17/1997','01/30/1997',2,137.35,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10420,'WELLI',3,'01/21/1997','02/18/1997','01/27/1997',1,44.12,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10421,'QUEDE',8,'01/21/1997','03/04/1997','01/27/1997',1,99.23,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10422,'FRANS',2,'01/22/1997','02/19/1997','01/31/1997',1,3.02,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10423,'GOURL',6,'01/23/1997','02/06/1997','02/24/1997',3,24.5,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10424,'MEREP',7,'01/23/1997','02/20/1997','01/27/1997',2,370.61,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10425,'LAMAI',6,'01/24/1997','02/21/1997','02/14/1997',2,7.93,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10426,'GALED',4,'01/27/1997','02/24/1997','02/06/1997',1,18.69,'Galera del gastronmo','Rambla de Catalua, 23','Barcelona',NULL,'8022','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10427,'PICCO',4,'01/27/1997','02/24/1997','03/03/1997',2,31.29,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10428,'REGGC',7,'01/28/1997','02/25/1997','02/04/1997',1,11.09,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10429,'HUNGO',3,'01/29/1997','03/12/1997','02/07/1997',2,56.63,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10430,'ERNSH',4,'01/30/1997','02/13/1997','02/03/1997',1,458.78,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10431,'BOTTM',4,'01/30/1997','02/13/1997','02/07/1997',2,44.17,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10432,'SPLIR',3,'01/31/1997','02/14/1997','02/07/1997',2,4.34,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10433,'PRINI',3,'02/03/1997','03/03/1997','03/04/1997',3,73.83,'Princesa Isabel Vinhos','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10434,'FOLKO',3,'02/03/1997','03/03/1997','02/13/1997',2,17.92,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10435,'CONSH',8,'02/04/1997','03/18/1997','02/07/1997',2,9.21,'Consolidated Holdings','Berkeley Gardens
12  Brewery ','London',NULL,'WX1 6LT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10436,'BLONP',3,'02/05/1997','03/05/1997','02/11/1997',2,156.66,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10437,'WARTH',8,'02/05/1997','03/05/1997','02/12/1997',1,19.97,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10438,'TOMSP',3,'02/06/1997','03/06/1997','02/14/1997',2,8.24,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10439,'MEREP',6,'02/07/1997','03/07/1997','02/10/1997',3,4.07,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10440,'SAVEA',4,'02/10/1997','03/10/1997','02/28/1997',2,86.53,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10441,'OLDWO',3,'02/10/1997','03/24/1997','03/14/1997',2,73.02,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10442,'ERNSH',3,'02/11/1997','03/11/1997','02/18/1997',2,47.94,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10443,'REGGC',8,'02/12/1997','03/12/1997','02/14/1997',1,13.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10444,'BERGS',3,'02/12/1997','03/12/1997','02/21/1997',3,3.5,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10445,'BERGS',3,'02/13/1997','03/13/1997','02/20/1997',1,9.3,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10446,'TOMSP',6,'02/14/1997','03/14/1997','02/19/1997',1,14.68,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10447,'RICAR',4,'02/14/1997','03/14/1997','03/07/1997',2,68.66,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10448,'RANCH',4,'02/17/1997','03/17/1997','02/24/1997',2,38.82,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10449,'BLONP',3,'02/18/1997','03/18/1997','02/27/1997',2,53.3,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10450,'VICTE',8,'02/19/1997','03/19/1997','03/11/1997',2,7.23,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10451,'QUICK',4,'02/19/1997','03/05/1997','03/12/1997',3,189.09,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10452,'SAVEA',8,'02/20/1997','03/20/1997','02/26/1997',1,140.26,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10453,'AROUT',1,'02/21/1997','03/21/1997','02/26/1997',2,25.36,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10454,'LAMAI',4,'02/21/1997','03/21/1997','02/25/1997',3,2.74,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10455,'WARTH',8,'02/24/1997','04/07/1997','03/03/1997',2,180.45,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10456,'KOENE',8,'02/25/1997','04/08/1997','02/28/1997',2,8.12,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10457,'KOENE',2,'02/25/1997','03/25/1997','03/03/1997',1,11.57,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10458,'SUPRD',7,'02/26/1997','03/26/1997','03/04/1997',3,147.06,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10459,'VICTE',4,'02/27/1997','03/27/1997','02/28/1997',2,25.09,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10460,'FOLKO',8,'02/28/1997','03/28/1997','03/03/1997',1,16.27,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10461,'LILAS',1,'02/28/1997','03/28/1997','03/05/1997',3,148.61,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10462,'CONSH',2,'03/03/1997','03/31/1997','03/18/1997',1,6.17,'Consolidated Holdings','Berkeley Gardens
12  Brewery ','London',NULL,'WX1 6LT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10463,'SUPRD',5,'03/04/1997','04/01/1997','03/06/1997',3,14.78,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10464,'FURIB',4,'03/04/1997','04/01/1997','03/14/1997',2,89,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10465,'VAFFE',1,'03/05/1997','04/02/1997','03/14/1997',3,145.04,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10466,'COMMI',4,'03/06/1997','04/03/1997','03/13/1997',1,11.93,'Comrcio Mineiro','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10467,'MAGAA',8,'03/06/1997','04/03/1997','03/11/1997',2,4.93,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10468,'KOENE',3,'03/07/1997','04/04/1997','03/12/1997',3,44.12,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10469,'WHITC',1,'03/10/1997','04/07/1997','03/14/1997',1,60.18,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10470,'BONAP',4,'03/11/1997','04/08/1997','03/14/1997',2,64.56,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10471,'BSBEV',2,'03/11/1997','04/08/1997','03/18/1997',3,45.59,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10472,'SEVES',8,'03/12/1997','04/09/1997','03/19/1997',1,4.2,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10473,'ISLAT',1,'03/13/1997','03/27/1997','03/21/1997',3,16.37,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10474,'PERIC',5,'03/13/1997','04/10/1997','03/21/1997',2,83.49,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10475,'SUPRD',9,'03/14/1997','04/11/1997','04/04/1997',1,68.52,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10476,'HILAA',8,'03/17/1997','04/14/1997','03/24/1997',3,4.41,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10477,'PRINI',5,'03/17/1997','04/14/1997','03/25/1997',2,13.02,'Princesa Isabel Vinhos','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10478,'VICTE',2,'03/18/1997','04/01/1997','03/26/1997',3,4.81,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10479,'RATTC',3,'03/19/1997','04/16/1997','03/21/1997',3,708.95,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10480,'FOLIG',6,'03/20/1997','04/17/1997','03/24/1997',2,1.35,'Folies gourmandes','184, chausse de Tournai','Lille',NULL,'59000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10481,'RICAR',8,'03/20/1997','04/17/1997','03/25/1997',2,64.33,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10482,'LAZYK',1,'03/21/1997','04/18/1997','04/10/1997',3,7.48,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10483,'WHITC',7,'03/24/1997','04/21/1997','04/25/1997',2,15.28,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10484,'BSBEV',3,'03/24/1997','04/21/1997','04/01/1997',3,6.88,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10485,'LINOD',4,'03/25/1997','04/08/1997','03/31/1997',2,64.45,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10486,'HILAA',1,'03/26/1997','04/23/1997','04/02/1997',2,30.53,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10487,'QUEEN',2,'03/26/1997','04/23/1997','03/28/1997',2,71.07,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10488,'FRANK',8,'03/27/1997','04/24/1997','04/02/1997',2,4.93,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10489,'PICCO',6,'03/28/1997','04/25/1997','04/09/1997',2,5.29,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10490,'HILAA',7,'03/31/1997','04/28/1997','04/03/1997',2,210.19,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10491,'FURIB',8,'03/31/1997','04/28/1997','04/08/1997',3,16.96,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10492,'BOTTM',3,'04/01/1997','04/29/1997','04/11/1997',1,62.89,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10493,'LAMAI',4,'04/02/1997','04/30/1997','04/10/1997',3,10.64,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10494,'COMMI',4,'04/02/1997','04/30/1997','04/09/1997',2,65.99,'Comrcio Mineiro','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10495,'LAUGB',3,'04/03/1997','05/01/1997','04/11/1997',3,4.65,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10496,'TRADH',7,'04/04/1997','05/02/1997','04/07/1997',2,46.77,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10497,'LEHMS',7,'04/04/1997','05/02/1997','04/07/1997',1,36.21,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10498,'HILAA',8,'04/07/1997','05/05/1997','04/11/1997',2,29.75,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10499,'LILAS',4,'04/08/1997','05/06/1997','04/16/1997',2,102.02,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10500,'LAMAI',6,'04/09/1997','05/07/1997','04/17/1997',1,42.68,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10501,'BLAUS',9,'04/09/1997','05/07/1997','04/16/1997',3,8.85,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10502,'PERIC',2,'04/10/1997','05/08/1997','04/29/1997',1,69.32,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10503,'HUNGO',6,'04/11/1997','05/09/1997','04/16/1997',2,16.74,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10504,'WHITC',4,'04/11/1997','05/09/1997','04/18/1997',3,59.13,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10505,'MEREP',3,'04/14/1997','05/12/1997','04/21/1997',3,7.13,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10506,'KOENE',9,'04/15/1997','05/13/1997','05/02/1997',2,21.19,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10507,'ANTON',7,'04/15/1997','05/13/1997','04/22/1997',1,47.45,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10508,'OTTIK',1,'04/16/1997','05/14/1997','05/13/1997',2,4.99,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10509,'BLAUS',4,'04/17/1997','05/15/1997','04/29/1997',1,0.15,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10510,'SAVEA',6,'04/18/1997','05/16/1997','04/28/1997',3,367.63,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10511,'BONAP',4,'04/18/1997','05/16/1997','04/21/1997',3,350.64,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10512,'FAMIA',7,'04/21/1997','05/19/1997','04/24/1997',2,3.53,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10513,'WANDK',7,'04/22/1997','06/03/1997','04/28/1997',1,105.65,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10514,'ERNSH',3,'04/22/1997','05/20/1997','05/16/1997',2,789.95,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10515,'QUICK',2,'04/23/1997','05/07/1997','05/23/1997',1,204.47,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10516,'HUNGO',2,'04/24/1997','05/22/1997','05/01/1997',3,62.78,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10517,'NORTS',3,'04/24/1997','05/22/1997','04/29/1997',3,32.07,'North/South','South House
300 Queensbridge','London',NULL,'SW7 1RZ','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10518,'TORTU',4,'04/25/1997','05/09/1997','05/05/1997',2,218.15,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10519,'CHOPS',6,'04/28/1997','05/26/1997','05/01/1997',3,91.76,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10520,'SANTG',7,'04/29/1997','05/27/1997','05/01/1997',1,13.37,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10521,'CACTU',8,'04/29/1997','05/27/1997','05/02/1997',2,17.22,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10522,'LEHMS',4,'04/30/1997','05/28/1997','05/06/1997',1,45.33,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10523,'SEVES',7,'05/01/1997','05/29/1997','05/30/1997',2,77.63,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10524,'BERGS',1,'05/01/1997','05/29/1997','05/07/1997',2,244.79,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10525,'BONAP',1,'05/02/1997','05/30/1997','05/23/1997',2,11.06,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10526,'WARTH',4,'05/05/1997','06/02/1997','05/15/1997',2,58.59,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10527,'QUICK',7,'05/05/1997','06/02/1997','05/07/1997',1,41.9,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10528,'GREAL',6,'05/06/1997','05/20/1997','05/09/1997',2,3.35,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10529,'MAISD',5,'05/07/1997','06/04/1997','05/09/1997',2,66.69,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10530,'PICCO',3,'05/08/1997','06/05/1997','05/12/1997',2,339.22,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10531,'OCEAN',7,'05/08/1997','06/05/1997','05/19/1997',1,8.12,'Ocano Atlntico Ltda.','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10532,'EASTC',7,'05/09/1997','06/06/1997','05/12/1997',3,74.46,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10533,'FOLKO',8,'05/12/1997','06/09/1997','05/22/1997',1,188.04,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10534,'LEHMS',8,'05/12/1997','06/09/1997','05/14/1997',2,27.94,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10535,'ANTON',4,'05/13/1997','06/10/1997','05/21/1997',1,15.64,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10536,'LEHMS',3,'05/14/1997','06/11/1997','06/06/1997',2,58.88,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10537,'RICSU',1,'05/14/1997','05/28/1997','05/19/1997',1,78.85,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10538,'BSBEV',9,'05/15/1997','06/12/1997','05/16/1997',3,4.87,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10539,'BSBEV',6,'05/16/1997','06/13/1997','05/23/1997',3,12.36,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10540,'QUICK',3,'05/19/1997','06/16/1997','06/13/1997',3,1007.64,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10541,'HANAR',2,'05/19/1997','06/16/1997','05/29/1997',1,68.65,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10542,'KOENE',1,'05/20/1997','06/17/1997','05/26/1997',3,10.95,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10543,'LILAS',8,'05/21/1997','06/18/1997','05/23/1997',2,48.17,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10544,'LONEP',4,'05/21/1997','06/18/1997','05/30/1997',1,24.91,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10545,'LAZYK',8,'05/22/1997','06/19/1997','06/26/1997',2,11.92,'Lazy K Kountry Store','12 Orchestra Terrace','Walla Walla','WA','99362','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10546,'VICTE',1,'05/23/1997','06/20/1997','05/27/1997',3,194.72,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10547,'SEVES',3,'05/23/1997','06/20/1997','06/02/1997',2,178.43,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10548,'TOMSP',3,'05/26/1997','06/23/1997','06/02/1997',2,1.43,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10549,'QUICK',5,'05/27/1997','06/10/1997','05/30/1997',1,171.24,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10550,'GODOS',7,'05/28/1997','06/25/1997','06/06/1997',3,4.32,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10551,'FURIB',4,'05/28/1997','07/09/1997','06/06/1997',3,72.95,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10552,'HILAA',2,'05/29/1997','06/26/1997','06/05/1997',1,83.22,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10553,'WARTH',2,'05/30/1997','06/27/1997','06/03/1997',2,149.49,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10554,'OTTIK',4,'05/30/1997','06/27/1997','06/05/1997',3,120.97,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10555,'SAVEA',6,'06/02/1997','06/30/1997','06/04/1997',3,252.49,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10556,'SIMOB',2,'06/03/1997','07/15/1997','06/13/1997',1,9.8,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10557,'LEHMS',9,'06/03/1997','06/17/1997','06/06/1997',2,96.72,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10558,'AROUT',1,'06/04/1997','07/02/1997','06/10/1997',2,72.97,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10559,'BLONP',6,'06/05/1997','07/03/1997','06/13/1997',1,8.05,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10560,'FRANK',8,'06/06/1997','07/04/1997','06/09/1997',1,36.65,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10561,'FOLKO',2,'06/06/1997','07/04/1997','06/09/1997',2,242.21,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10562,'REGGC',1,'06/09/1997','07/07/1997','06/12/1997',1,22.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10563,'RICAR',2,'06/10/1997','07/22/1997','06/24/1997',2,60.43,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10564,'RATTC',4,'06/10/1997','07/08/1997','06/16/1997',3,13.75,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10565,'MEREP',8,'06/11/1997','07/09/1997','06/18/1997',2,7.15,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10566,'BLONP',9,'06/12/1997','07/10/1997','06/18/1997',1,88.4,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10567,'HUNGO',1,'06/12/1997','07/10/1997','06/17/1997',1,33.97,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10568,'GALED',3,'06/13/1997','07/11/1997','07/09/1997',3,6.54,'Galera del gastronmo','Rambla de Catalua, 23','Barcelona',NULL,'8022','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10569,'RATTC',5,'06/16/1997','07/14/1997','07/11/1997',1,58.98,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10570,'MEREP',3,'06/17/1997','07/15/1997','06/19/1997',3,188.99,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10571,'ERNSH',8,'06/17/1997','07/29/1997','07/04/1997',3,26.06,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10572,'BERGS',3,'06/18/1997','07/16/1997','06/25/1997',2,116.43,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10573,'ANTON',7,'06/19/1997','07/17/1997','06/20/1997',3,84.84,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10574,'TRAIH',4,'06/19/1997','07/17/1997','06/30/1997',2,37.6,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10575,'MORGK',5,'06/20/1997','07/04/1997','06/30/1997',1,127.34,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10576,'TORTU',3,'06/23/1997','07/07/1997','06/30/1997',3,18.56,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10577,'TRAIH',9,'06/23/1997','08/04/1997','06/30/1997',2,25.41,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10578,'BSBEV',4,'06/24/1997','07/22/1997','07/25/1997',3,29.6,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10579,'LETSS',1,'06/25/1997','07/23/1997','07/04/1997',2,13.73,'Let''s Stop N Shop','87 Polk St.
Suite 5','San Francisco','CA','94117','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10580,'OTTIK',4,'06/26/1997','07/24/1997','07/01/1997',3,75.89,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10581,'FAMIA',3,'06/26/1997','07/24/1997','07/02/1997',1,3.01,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10582,'BLAUS',3,'06/27/1997','07/25/1997','07/14/1997',2,27.71,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10583,'WARTH',2,'06/30/1997','07/28/1997','07/04/1997',2,7.28,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10584,'BLONP',4,'06/30/1997','07/28/1997','07/04/1997',1,59.14,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10585,'WELLI',7,'07/01/1997','07/29/1997','07/10/1997',1,13.41,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10586,'REGGC',9,'07/02/1997','07/30/1997','07/09/1997',1,0.48,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10587,'QUEDE',1,'07/02/1997','07/30/1997','07/09/1997',1,62.52,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10588,'QUICK',2,'07/03/1997','07/31/1997','07/10/1997',3,194.67,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10589,'GREAL',8,'07/04/1997','08/01/1997','07/14/1997',2,4.42,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10590,'MEREP',4,'07/07/1997','08/04/1997','07/14/1997',3,44.77,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10591,'VAFFE',1,'07/07/1997','07/21/1997','07/16/1997',1,55.92,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10592,'LEHMS',3,'07/08/1997','08/05/1997','07/16/1997',1,32.1,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10593,'LEHMS',7,'07/09/1997','08/06/1997','08/13/1997',2,174.2,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10594,'OLDWO',3,'07/09/1997','08/06/1997','07/16/1997',2,5.24,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10595,'ERNSH',2,'07/10/1997','08/07/1997','07/14/1997',1,96.78,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10596,'WHITC',8,'07/11/1997','08/08/1997','08/12/1997',1,16.34,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10597,'PICCO',7,'07/11/1997','08/08/1997','07/18/1997',3,35.12,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10598,'RATTC',1,'07/14/1997','08/11/1997','07/18/1997',3,44.42,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10599,'BSBEV',6,'07/15/1997','08/26/1997','07/21/1997',3,29.98,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10600,'HUNGC',4,'07/16/1997','08/13/1997','07/21/1997',1,45.13,'Hungry Coyote Import Store','City Center Plaza
516 Main St.','Elgin','OR','97827','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10601,'HILAA',7,'07/16/1997','08/27/1997','07/22/1997',1,58.3,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10602,'VAFFE',8,'07/17/1997','08/14/1997','07/22/1997',2,2.92,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10603,'SAVEA',8,'07/18/1997','08/15/1997','08/08/1997',2,48.77,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10604,'FURIB',1,'07/18/1997','08/15/1997','07/29/1997',1,7.46,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10605,'MEREP',1,'07/21/1997','08/18/1997','07/29/1997',2,379.13,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10606,'TRADH',4,'07/22/1997','08/19/1997','07/31/1997',3,79.4,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10607,'SAVEA',5,'07/22/1997','08/19/1997','07/25/1997',1,200.24,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10608,'TOMSP',4,'07/23/1997','08/20/1997','08/01/1997',2,27.79,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10609,'DUMON',7,'07/24/1997','08/21/1997','07/30/1997',2,1.85,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10610,'LAMAI',8,'07/25/1997','08/22/1997','08/06/1997',1,26.78,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10611,'WOLZA',6,'07/25/1997','08/22/1997','08/01/1997',2,80.65,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10612,'SAVEA',1,'07/28/1997','08/25/1997','08/01/1997',2,544.08,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10613,'HILAA',4,'07/29/1997','08/26/1997','08/01/1997',2,8.11,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10614,'BLAUS',8,'07/29/1997','08/26/1997','08/01/1997',3,1.93,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10615,'WILMK',2,'07/30/1997','08/27/1997','08/06/1997',3,0.75,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10616,'GREAL',1,'07/31/1997','08/28/1997','08/05/1997',2,116.53,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10617,'GREAL',4,'07/31/1997','08/28/1997','08/04/1997',2,18.53,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10618,'MEREP',1,'08/01/1997','09/12/1997','08/08/1997',1,154.68,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10619,'MEREP',3,'08/04/1997','09/01/1997','08/07/1997',3,91.05,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10620,'LAUGB',2,'08/05/1997','09/02/1997','08/14/1997',3,0.94,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10621,'ISLAT',4,'08/05/1997','09/02/1997','08/11/1997',2,23.73,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10622,'RICAR',4,'08/06/1997','09/03/1997','08/11/1997',3,50.97,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10623,'FRANK',8,'08/07/1997','09/04/1997','08/12/1997',2,97.18,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10624,'THECR',4,'08/07/1997','09/04/1997','08/19/1997',2,94.8,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10625,'ANATR',3,'08/08/1997','09/05/1997','08/14/1997',1,43.9,'Ana Trujillo Emparedados y helados','Avda. de la Constitucin 2222','Mxico D.F.',NULL,'05021','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10626,'BERGS',1,'08/11/1997','09/08/1997','08/20/1997',2,138.69,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10627,'SAVEA',8,'08/11/1997','09/22/1997','08/21/1997',3,107.46,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10628,'BLONP',4,'08/12/1997','09/09/1997','08/20/1997',3,30.36,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10629,'GODOS',4,'08/12/1997','09/09/1997','08/20/1997',3,85.46,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10630,'KOENE',1,'08/13/1997','09/10/1997','08/19/1997',2,32.35,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10631,'LAMAI',8,'08/14/1997','09/11/1997','08/15/1997',1,0.87,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10632,'WANDK',8,'08/14/1997','09/11/1997','08/19/1997',1,41.38,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10633,'ERNSH',7,'08/15/1997','09/12/1997','08/18/1997',3,477.9,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10634,'FOLIG',4,'08/15/1997','09/12/1997','08/21/1997',3,487.38,'Folies gourmandes','184, chausse de Tournai','Lille',NULL,'59000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10635,'MAGAA',8,'08/18/1997','09/15/1997','08/21/1997',3,47.46,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10636,'WARTH',4,'08/19/1997','09/16/1997','08/26/1997',1,1.15,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10637,'QUEEN',6,'08/19/1997','09/16/1997','08/26/1997',1,201.29,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10638,'LINOD',3,'08/20/1997','09/17/1997','09/01/1997',1,158.44,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10639,'SANTG',7,'08/20/1997','09/17/1997','08/27/1997',3,38.64,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10640,'WANDK',4,'08/21/1997','09/18/1997','08/28/1997',1,23.55,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10641,'HILAA',4,'08/22/1997','09/19/1997','08/26/1997',2,179.61,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10642,'SIMOB',7,'08/22/1997','09/19/1997','09/05/1997',3,41.89,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10643,'ALFKI',6,'08/25/1997','09/22/1997','09/02/1997',1,29.46,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10644,'WELLI',3,'08/25/1997','09/22/1997','09/01/1997',2,0.14,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10645,'HANAR',4,'08/26/1997','09/23/1997','09/02/1997',1,12.41,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10646,'HUNGO',9,'08/27/1997','10/08/1997','09/03/1997',3,142.33,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10647,'QUEDE',4,'08/27/1997','09/10/1997','09/03/1997',2,45.54,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10648,'RICAR',5,'08/28/1997','10/09/1997','09/09/1997',2,14.25,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10649,'MAISD',5,'08/28/1997','09/25/1997','08/29/1997',3,6.2,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10650,'FAMIA',5,'08/29/1997','09/26/1997','09/03/1997',3,176.81,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10651,'WANDK',8,'09/01/1997','09/29/1997','09/11/1997',2,20.6,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10652,'GOURL',4,'09/01/1997','09/29/1997','09/08/1997',2,7.14,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10653,'FRANK',1,'09/02/1997','09/30/1997','09/19/1997',1,93.25,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10654,'BERGS',5,'09/02/1997','09/30/1997','09/11/1997',1,55.26,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10655,'REGGC',1,'09/03/1997','10/01/1997','09/11/1997',2,4.41,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10656,'GREAL',6,'09/04/1997','10/02/1997','09/10/1997',1,57.15,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10657,'SAVEA',2,'09/04/1997','10/02/1997','09/15/1997',2,352.69,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10658,'QUICK',4,'09/05/1997','10/03/1997','09/08/1997',1,364.15,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10659,'QUEEN',7,'09/05/1997','10/03/1997','09/10/1997',2,105.81,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10660,'HUNGC',8,'09/08/1997','10/06/1997','10/15/1997',1,111.29,'Hungry Coyote Import Store','City Center Plaza
516 Main St.','Elgin','OR','97827','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10661,'HUNGO',7,'09/09/1997','10/07/1997','09/15/1997',3,17.55,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10662,'LONEP',3,'09/09/1997','10/07/1997','09/18/1997',2,1.28,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10663,'BONAP',2,'09/10/1997','09/24/1997','10/03/1997',2,113.15,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10664,'FURIB',1,'09/10/1997','10/08/1997','09/19/1997',3,1.27,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10665,'LONEP',1,'09/11/1997','10/09/1997','09/17/1997',2,26.31,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10666,'RICSU',7,'09/12/1997','10/10/1997','09/22/1997',2,232.42,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10667,'ERNSH',7,'09/12/1997','10/10/1997','09/19/1997',1,78.09,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10668,'WANDK',1,'09/15/1997','10/13/1997','09/23/1997',2,47.22,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10669,'SIMOB',2,'09/15/1997','10/13/1997','09/22/1997',1,24.39,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10670,'FRANK',4,'09/16/1997','10/14/1997','09/18/1997',1,203.48,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10671,'FRANR',1,'09/17/1997','10/15/1997','09/24/1997',1,30.34,'France restauration','54, rue Royale','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10672,'BERGS',9,'09/17/1997','10/01/1997','09/26/1997',2,95.75,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10673,'WILMK',2,'09/18/1997','10/16/1997','09/19/1997',1,22.76,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10674,'ISLAT',4,'09/18/1997','10/16/1997','09/30/1997',2,0.9,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10675,'FRANK',5,'09/19/1997','10/17/1997','09/23/1997',2,31.85,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10676,'TORTU',2,'09/22/1997','10/20/1997','09/29/1997',2,2.01,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10677,'ANTON',1,'09/22/1997','10/20/1997','09/26/1997',3,4.03,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10678,'SAVEA',7,'09/23/1997','10/21/1997','10/16/1997',3,388.98,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10679,'BLONP',8,'09/23/1997','10/21/1997','09/30/1997',3,27.94,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10680,'OLDWO',1,'09/24/1997','10/22/1997','09/26/1997',1,26.61,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10681,'GREAL',3,'09/25/1997','10/23/1997','09/30/1997',3,76.13,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10682,'ANTON',3,'09/25/1997','10/23/1997','10/01/1997',2,36.13,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10683,'DUMON',2,'09/26/1997','10/24/1997','10/01/1997',1,4.4,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10684,'OTTIK',3,'09/26/1997','10/24/1997','09/30/1997',1,145.63,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10685,'GOURL',4,'09/29/1997','10/13/1997','10/03/1997',2,33.75,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10686,'PICCO',2,'09/30/1997','10/28/1997','10/08/1997',1,96.5,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10687,'HUNGO',9,'09/30/1997','10/28/1997','10/30/1997',2,296.43,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10688,'VAFFE',4,'10/01/1997','10/15/1997','10/07/1997',2,299.09,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10689,'BERGS',1,'10/01/1997','10/29/1997','10/07/1997',2,13.42,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10690,'HANAR',1,'10/02/1997','10/30/1997','10/03/1997',1,15.8,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10691,'QUICK',2,'10/03/1997','11/14/1997','10/22/1997',2,810.05,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10692,'ALFKI',4,'10/03/1997','10/31/1997','10/13/1997',2,61.02,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10693,'WHITC',3,'10/06/1997','10/20/1997','10/10/1997',3,139.34,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10694,'QUICK',8,'10/06/1997','11/03/1997','10/09/1997',3,398.36,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10695,'WILMK',7,'10/07/1997','11/18/1997','10/14/1997',1,16.72,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10696,'WHITC',8,'10/08/1997','11/19/1997','10/14/1997',3,102.55,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10697,'LINOD',3,'10/08/1997','11/05/1997','10/14/1997',1,45.52,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10698,'ERNSH',4,'10/09/1997','11/06/1997','10/17/1997',1,272.47,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10699,'MORGK',3,'10/09/1997','11/06/1997','10/13/1997',3,0.58,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10700,'SAVEA',3,'10/10/1997','11/07/1997','10/16/1997',1,65.1,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10701,'HUNGO',6,'10/13/1997','10/27/1997','10/15/1997',3,220.31,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10702,'ALFKI',4,'10/13/1997','11/24/1997','10/21/1997',1,23.94,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10703,'FOLKO',6,'10/14/1997','11/11/1997','10/20/1997',2,152.3,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10704,'QUEEN',6,'10/14/1997','11/11/1997','11/07/1997',1,4.78,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10705,'HILAA',9,'10/15/1997','11/12/1997','11/18/1997',2,3.52,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10706,'OLDWO',8,'10/16/1997','11/13/1997','10/21/1997',3,135.63,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10707,'AROUT',4,'10/16/1997','10/30/1997','10/23/1997',3,21.74,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10708,'THEBI',6,'10/17/1997','11/28/1997','11/05/1997',2,2.96,'The Big Cheese','89 Jefferson Way
Suite 2','Portland','OR','97201','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10709,'GOURL',1,'10/17/1997','11/14/1997','11/20/1997',3,210.8,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10710,'FRANS',1,'10/20/1997','11/17/1997','10/23/1997',1,4.98,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10711,'SAVEA',5,'10/21/1997','12/02/1997','10/29/1997',2,52.41,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10712,'HUNGO',3,'10/21/1997','11/18/1997','10/31/1997',1,89.93,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10713,'SAVEA',1,'10/22/1997','11/19/1997','10/24/1997',1,167.05,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10714,'SAVEA',5,'10/22/1997','11/19/1997','10/27/1997',3,24.49,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10715,'BONAP',3,'10/23/1997','11/06/1997','10/29/1997',1,63.2,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10716,'RANCH',4,'10/24/1997','11/21/1997','10/27/1997',2,22.57,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10717,'FRANK',1,'10/24/1997','11/21/1997','10/29/1997',2,59.25,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10718,'KOENE',1,'10/27/1997','11/24/1997','10/29/1997',3,170.88,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10719,'LETSS',8,'10/27/1997','11/24/1997','11/05/1997',2,51.44,'Let''s Stop N Shop','87 Polk St.
Suite 5','San Francisco','CA','94117','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10720,'QUEDE',8,'10/28/1997','11/11/1997','11/05/1997',2,9.53,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10721,'QUICK',5,'10/29/1997','11/26/1997','10/31/1997',3,48.92,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10722,'SAVEA',8,'10/29/1997','12/10/1997','11/04/1997',1,74.58,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10723,'WHITC',3,'10/30/1997','11/27/1997','11/25/1997',1,21.72,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10724,'MEREP',8,'10/30/1997','12/11/1997','11/05/1997',2,57.75,'Mre Paillarde','43 rue St. Laurent','Montral','Qubec','H1J 1C3','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10725,'FAMIA',4,'10/31/1997','11/28/1997','11/05/1997',3,10.83,'Familia Arquibaldo','Rua Ors, 92','So Paulo','SP','05442-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10726,'EASTC',4,'11/03/1997','11/17/1997','12/05/1997',1,16.56,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10727,'REGGC',2,'11/03/1997','12/01/1997','12/05/1997',1,89.9,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10728,'QUEEN',4,'11/04/1997','12/02/1997','11/11/1997',2,58.33,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10729,'LINOD',8,'11/04/1997','12/16/1997','11/14/1997',3,141.06,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10730,'BONAP',5,'11/05/1997','12/03/1997','11/14/1997',1,20.12,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10731,'CHOPS',7,'11/06/1997','12/04/1997','11/14/1997',1,96.65,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10732,'BONAP',3,'11/06/1997','12/04/1997','11/07/1997',1,16.97,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10733,'BERGS',1,'11/07/1997','12/05/1997','11/10/1997',3,110.11,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10734,'GOURL',2,'11/07/1997','12/05/1997','11/12/1997',3,1.63,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10735,'LETSS',6,'11/10/1997','12/08/1997','11/21/1997',2,45.97,'Let''s Stop N Shop','87 Polk St.
Suite 5','San Francisco','CA','94117','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10736,'HUNGO',9,'11/11/1997','12/09/1997','11/21/1997',2,44.1,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10737,'VINET',2,'11/11/1997','12/09/1997','11/18/1997',2,7.79,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10738,'SPECD',2,'11/12/1997','12/10/1997','11/18/1997',1,2.91,'Spcialits du monde','25, rue Lauriston','Paris',NULL,'75016','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10739,'VINET',3,'11/12/1997','12/10/1997','11/17/1997',3,11.08,'Vins et alcools Chevalier','59 rue de l''Abbaye','Reims',NULL,'51100','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10740,'WHITC',4,'11/13/1997','12/11/1997','11/25/1997',2,81.88,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10741,'AROUT',4,'11/14/1997','11/28/1997','11/18/1997',3,10.96,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10742,'BOTTM',3,'11/14/1997','12/12/1997','11/18/1997',3,243.73,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10743,'AROUT',1,'11/17/1997','12/15/1997','11/21/1997',2,23.72,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10744,'VAFFE',6,'11/17/1997','12/15/1997','11/24/1997',1,69.19,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10745,'QUICK',9,'11/18/1997','12/16/1997','11/27/1997',1,3.52,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10746,'CHOPS',1,'11/19/1997','12/17/1997','11/21/1997',3,31.43,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10747,'PICCO',6,'11/19/1997','12/17/1997','11/26/1997',1,117.33,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10748,'SAVEA',3,'11/20/1997','12/18/1997','11/28/1997',1,232.55,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10749,'ISLAT',4,'11/20/1997','12/18/1997','12/19/1997',2,61.53,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10750,'WARTH',9,'11/21/1997','12/19/1997','11/24/1997',1,79.3,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10751,'RICSU',3,'11/24/1997','12/22/1997','12/03/1997',3,130.79,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10752,'NORTS',2,'11/24/1997','12/22/1997','11/28/1997',3,1.39,'North/South','South House
300 Queensbridge','London',NULL,'SW7 1RZ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10753,'FRANS',3,'11/25/1997','12/23/1997','11/27/1997',1,7.7,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10754,'MAGAA',6,'11/25/1997','12/23/1997','11/27/1997',3,2.38,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10755,'BONAP',4,'11/26/1997','12/24/1997','11/28/1997',2,16.71,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10756,'SPLIR',8,'11/27/1997','12/25/1997','12/02/1997',2,73.21,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10757,'SAVEA',6,'11/27/1997','12/25/1997','12/15/1997',1,8.19,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10758,'RICSU',3,'11/28/1997','12/26/1997','12/04/1997',3,138.17,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10759,'ANATR',3,'11/28/1997','12/26/1997','12/12/1997',3,11.99,'Ana Trujillo Emparedados y helados','Avda. de la Constitucin 2222','Mxico D.F.',NULL,'05021','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10760,'MAISD',4,'12/01/1997','12/29/1997','12/10/1997',1,155.64,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10761,'RATTC',5,'12/02/1997','12/30/1997','12/08/1997',2,18.66,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10762,'FOLKO',3,'12/02/1997','12/30/1997','12/09/1997',1,328.74,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10763,'FOLIG',3,'12/03/1997','12/31/1997','12/08/1997',3,37.35,'Folies gourmandes','184, chausse de Tournai','Lille',NULL,'59000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10764,'ERNSH',6,'12/03/1997','12/31/1997','12/08/1997',3,145.45,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10765,'QUICK',3,'12/04/1997','01/01/1998','12/09/1997',3,42.74,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10766,'OTTIK',4,'12/05/1997','01/02/1998','12/09/1997',1,157.55,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10767,'SUPRD',4,'12/05/1997','01/02/1998','12/15/1997',3,1.59,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10768,'AROUT',3,'12/08/1997','01/05/1998','12/15/1997',2,146.32,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10769,'VAFFE',3,'12/08/1997','01/05/1998','12/12/1997',1,65.06,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10770,'HANAR',8,'12/09/1997','01/06/1998','12/17/1997',3,5.32,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10771,'ERNSH',9,'12/10/1997','01/07/1998','01/02/1998',2,11.19,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10772,'LEHMS',3,'12/10/1997','01/07/1998','12/19/1997',2,91.28,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10773,'ERNSH',1,'12/11/1997','01/08/1998','12/16/1997',3,96.43,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10774,'FOLKO',4,'12/11/1997','12/25/1997','12/12/1997',1,48.2,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10775,'THECR',7,'12/12/1997','01/09/1998','12/26/1997',1,20.25,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10776,'ERNSH',1,'12/15/1997','01/12/1998','12/18/1997',3,351.53,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10777,'GOURL',7,'12/15/1997','12/29/1997','01/21/1998',2,3.01,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10778,'BERGS',3,'12/16/1997','01/13/1998','12/24/1997',1,6.79,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10779,'MORGK',3,'12/16/1997','01/13/1998','01/14/1998',2,58.13,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10780,'LILAS',2,'12/16/1997','12/30/1997','12/25/1997',1,42.13,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10781,'WARTH',2,'12/17/1997','01/14/1998','12/19/1997',3,73.16,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10782,'CACTU',9,'12/17/1997','01/14/1998','12/22/1997',3,1.1,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10783,'HANAR',4,'12/18/1997','01/15/1998','12/19/1997',2,124.98,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10784,'MAGAA',4,'12/18/1997','01/15/1998','12/22/1997',3,70.09,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10785,'GROSR',1,'12/18/1997','01/15/1998','12/24/1997',3,1.51,'GROSELLA-Restaurante','5 Ave. Los Palos Grandes','Caracas','DF','1081','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10786,'QUEEN',8,'12/19/1997','01/16/1998','12/23/1997',1,110.87,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10787,'LAMAI',2,'12/19/1997','01/02/1998','12/26/1997',1,249.93,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10788,'QUICK',1,'12/22/1997','01/19/1998','01/19/1998',2,42.7,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10789,'FOLIG',1,'12/22/1997','01/19/1998','12/31/1997',2,100.6,'Folies gourmandes','184, chausse de Tournai','Lille',NULL,'59000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10790,'GOURL',6,'12/22/1997','01/19/1998','12/26/1997',1,28.23,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10791,'FRANK',6,'12/23/1997','01/20/1998','01/01/1998',2,16.85,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10792,'WOLZA',1,'12/23/1997','01/20/1998','12/31/1997',3,23.79,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10793,'AROUT',3,'12/24/1997','01/21/1998','01/08/1998',3,4.52,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10794,'QUEDE',6,'12/24/1997','01/21/1998','01/02/1998',1,21.49,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10795,'ERNSH',8,'12/24/1997','01/21/1998','01/20/1998',2,126.66,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10796,'HILAA',3,'12/25/1997','01/22/1998','01/14/1998',1,26.52,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10797,'DRACD',7,'12/25/1997','01/22/1998','01/05/1998',2,33.35,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10798,'ISLAT',2,'12/26/1997','01/23/1998','01/05/1998',1,2.33,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10799,'KOENE',9,'12/26/1997','02/06/1998','01/05/1998',3,30.76,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10800,'SEVES',1,'12/26/1997','01/23/1998','01/05/1998',3,137.44,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10801,'BOLID',4,'12/29/1997','01/26/1998','12/31/1997',2,97.09,'Blido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10802,'SIMOB',4,'12/29/1997','01/26/1998','01/02/1998',2,257.26,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10803,'WELLI',4,'12/30/1997','01/27/1998','01/06/1998',1,55.23,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10804,'SEVES',6,'12/30/1997','01/27/1998','01/07/1998',2,27.33,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10805,'THEBI',2,'12/30/1997','01/27/1998','01/09/1998',3,237.34,'The Big Cheese','89 Jefferson Way
Suite 2','Portland','OR','97201','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10806,'VICTE',3,'12/31/1997','01/28/1998','01/05/1998',2,22.11,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10807,'FRANS',4,'12/31/1997','01/28/1998','01/30/1998',1,1.36,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10808,'OLDWO',2,'01/01/1998','01/29/1998','01/09/1998',3,45.53,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10809,'WELLI',7,'01/01/1998','01/29/1998','01/07/1998',1,4.87,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10810,'LAUGB',2,'01/01/1998','01/29/1998','01/07/1998',3,4.33,'Laughing Bacchus Wine Cellars','2319 Elm St.','Vancouver','BC','V3F 2K1','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10811,'LINOD',8,'01/02/1998','01/30/1998','01/08/1998',1,31.22,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10812,'REGGC',5,'01/02/1998','01/30/1998','01/12/1998',1,59.78,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10813,'RICAR',1,'01/05/1998','02/02/1998','01/09/1998',1,47.38,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10814,'VICTE',3,'01/05/1998','02/02/1998','01/14/1998',3,130.94,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10815,'SAVEA',2,'01/05/1998','02/02/1998','01/14/1998',3,14.62,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10816,'GREAL',4,'01/06/1998','02/03/1998','02/04/1998',2,719.78,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10817,'KOENE',3,'01/06/1998','01/20/1998','01/13/1998',2,306.07,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10818,'MAGAA',7,'01/07/1998','02/04/1998','01/12/1998',3,65.48,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10819,'CACTU',2,'01/07/1998','02/04/1998','01/16/1998',3,19.76,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10820,'RATTC',3,'01/07/1998','02/04/1998','01/13/1998',2,37.52,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10821,'SPLIR',1,'01/08/1998','02/05/1998','01/15/1998',1,36.68,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10822,'TRAIH',6,'01/08/1998','02/05/1998','01/16/1998',3,7,'Trail''s Head Gourmet Provisioners','722 DaVinci Blvd.','Kirkland','WA','98034','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10823,'LILAS',5,'01/09/1998','02/06/1998','01/13/1998',2,163.97,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10824,'FOLKO',8,'01/09/1998','02/06/1998','01/30/1998',1,1.23,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10825,'DRACD',1,'01/09/1998','02/06/1998','01/14/1998',1,79.25,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10826,'BLONP',6,'01/12/1998','02/09/1998','02/06/1998',1,7.09,'Blondel pre et fils','24, place Klber','Strasbourg',NULL,'67000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10827,'BONAP',1,'01/12/1998','01/26/1998','02/06/1998',2,63.54,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10828,'RANCH',9,'01/13/1998','01/27/1998','02/04/1998',1,90.85,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10829,'ISLAT',9,'01/13/1998','02/10/1998','01/23/1998',1,154.72,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10830,'TRADH',4,'01/13/1998','02/24/1998','01/21/1998',2,81.83,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10831,'SANTG',3,'01/14/1998','02/11/1998','01/23/1998',2,72.19,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10832,'LAMAI',2,'01/14/1998','02/11/1998','01/19/1998',2,43.26,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10833,'OTTIK',6,'01/15/1998','02/12/1998','01/23/1998',2,71.49,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10834,'TRADH',1,'01/15/1998','02/12/1998','01/19/1998',3,29.78,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10835,'ALFKI',1,'01/15/1998','02/12/1998','01/21/1998',3,69.53,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10836,'ERNSH',7,'01/16/1998','02/13/1998','01/21/1998',1,411.88,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10837,'BERGS',9,'01/16/1998','02/13/1998','01/23/1998',3,13.32,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10838,'LINOD',3,'01/19/1998','02/16/1998','01/23/1998',3,59.28,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10839,'TRADH',3,'01/19/1998','02/16/1998','01/22/1998',3,35.43,'Tradio Hipermercados','Av. Ins de Castro, 414','So Paulo','SP','05634-030','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10840,'LINOD',4,'01/19/1998','03/02/1998','02/16/1998',2,2.71,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10841,'SUPRD',5,'01/20/1998','02/17/1998','01/29/1998',2,424.3,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10842,'TORTU',1,'01/20/1998','02/17/1998','01/29/1998',3,54.42,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10843,'VICTE',4,'01/21/1998','02/18/1998','01/26/1998',2,9.26,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10844,'PICCO',8,'01/21/1998','02/18/1998','01/26/1998',2,25.22,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10845,'QUICK',8,'01/21/1998','02/04/1998','01/30/1998',1,212.98,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10846,'SUPRD',2,'01/22/1998','03/05/1998','01/23/1998',3,56.46,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10847,'SAVEA',4,'01/22/1998','02/05/1998','02/10/1998',3,487.57,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10848,'CONSH',7,'01/23/1998','02/20/1998','01/29/1998',2,38.24,'Consolidated Holdings','Berkeley Gardens
12  Brewery ','London',NULL,'WX1 6LT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10849,'KOENE',9,'01/23/1998','02/20/1998','01/30/1998',2,0.56,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10850,'VICTE',1,'01/23/1998','03/06/1998','01/30/1998',1,49.19,'Victuailles en stock','2, rue du Commerce','Lyon',NULL,'69004','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10851,'RICAR',5,'01/26/1998','02/23/1998','02/02/1998',1,160.55,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10852,'RATTC',8,'01/26/1998','02/09/1998','01/30/1998',1,174.05,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10853,'BLAUS',9,'01/27/1998','02/24/1998','02/03/1998',2,53.83,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10854,'ERNSH',3,'01/27/1998','02/24/1998','02/05/1998',2,100.22,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10855,'OLDWO',3,'01/27/1998','02/24/1998','02/04/1998',1,170.97,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10856,'ANTON',3,'01/28/1998','02/25/1998','02/10/1998',2,58.43,'Antonio Moreno Taquera','Mataderos  2312','Mxico D.F.',NULL,'05023','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10857,'BERGS',8,'01/28/1998','02/25/1998','02/06/1998',2,188.85,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10858,'LACOR',2,'01/29/1998','02/26/1998','02/03/1998',1,52.51,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10859,'FRANK',1,'01/29/1998','02/26/1998','02/02/1998',2,76.1,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10860,'FRANR',3,'01/29/1998','02/26/1998','02/04/1998',3,19.26,'France restauration','54, rue Royale','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10861,'WHITC',4,'01/30/1998','02/27/1998','02/17/1998',2,14.93,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10862,'LEHMS',8,'01/30/1998','03/13/1998','02/02/1998',2,53.23,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10863,'HILAA',4,'02/02/1998','03/02/1998','02/17/1998',2,30.26,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10864,'AROUT',4,'02/02/1998','03/02/1998','02/09/1998',2,3.04,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10865,'QUICK',2,'02/02/1998','02/16/1998','02/12/1998',1,348.14,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10866,'BERGS',5,'02/03/1998','03/03/1998','02/12/1998',1,109.11,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10867,'LONEP',6,'02/03/1998','03/17/1998','02/11/1998',1,1.93,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10868,'QUEEN',7,'02/04/1998','03/04/1998','02/23/1998',2,191.27,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10869,'SEVES',5,'02/04/1998','03/04/1998','02/09/1998',1,143.28,'Seven Seas Imports','90 Wadhurst Rd.','London',NULL,'OX15 4NB','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10870,'WOLZA',5,'02/04/1998','03/04/1998','02/13/1998',3,12.04,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10871,'BONAP',9,'02/05/1998','03/05/1998','02/10/1998',2,112.27,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10872,'GODOS',5,'02/05/1998','03/05/1998','02/09/1998',2,175.32,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10873,'WILMK',4,'02/06/1998','03/06/1998','02/09/1998',1,0.82,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10874,'GODOS',5,'02/06/1998','03/06/1998','02/11/1998',2,19.58,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10875,'BERGS',4,'02/06/1998','03/06/1998','03/03/1998',2,32.37,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10876,'BONAP',7,'02/09/1998','03/09/1998','02/12/1998',3,60.42,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10877,'RICAR',1,'02/09/1998','03/09/1998','02/19/1998',1,38.06,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10878,'QUICK',4,'02/10/1998','03/10/1998','02/12/1998',1,46.69,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10879,'WILMK',3,'02/10/1998','03/10/1998','02/12/1998',3,8.5,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10880,'FOLKO',7,'02/10/1998','03/24/1998','02/18/1998',1,88.01,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10881,'CACTU',4,'02/11/1998','03/11/1998','02/18/1998',1,2.84,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10882,'SAVEA',4,'02/11/1998','03/11/1998','02/20/1998',3,23.1,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10883,'LONEP',8,'02/12/1998','03/12/1998','02/20/1998',3,0.53,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10884,'LETSS',4,'02/12/1998','03/12/1998','02/13/1998',2,90.97,'Let''s Stop N Shop','87 Polk St.
Suite 5','San Francisco','CA','94117','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10885,'SUPRD',6,'02/12/1998','03/12/1998','02/18/1998',3,5.64,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10886,'HANAR',1,'02/13/1998','03/13/1998','03/02/1998',1,4.99,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10887,'GALED',8,'02/13/1998','03/13/1998','02/16/1998',3,1.25,'Galera del gastronmo','Rambla de Catalua, 23','Barcelona',NULL,'8022','Spain')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10888,'GODOS',1,'02/16/1998','03/16/1998','02/23/1998',2,51.87,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10889,'RATTC',9,'02/16/1998','03/16/1998','02/23/1998',3,280.61,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10890,'DUMON',7,'02/16/1998','03/16/1998','02/18/1998',1,32.76,'Du monde entier','67, rue des Cinquante Otages','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10891,'LEHMS',7,'02/17/1998','03/17/1998','02/19/1998',2,20.37,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10892,'MAISD',4,'02/17/1998','03/17/1998','02/19/1998',2,120.27,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10893,'KOENE',9,'02/18/1998','03/18/1998','02/20/1998',2,77.78,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10894,'SAVEA',1,'02/18/1998','03/18/1998','02/20/1998',1,116.13,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10895,'ERNSH',3,'02/18/1998','03/18/1998','02/23/1998',1,162.75,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10896,'MAISD',7,'02/19/1998','03/19/1998','02/27/1998',3,32.45,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10897,'HUNGO',3,'02/19/1998','03/19/1998','02/25/1998',2,603.54,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10898,'OCEAN',4,'02/20/1998','03/20/1998','03/06/1998',2,1.27,'Ocano Atlntico Ltda.','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10899,'LILAS',5,'02/20/1998','03/20/1998','02/26/1998',3,1.21,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10900,'WELLI',1,'02/20/1998','03/20/1998','03/04/1998',2,1.66,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10901,'HILAA',4,'02/23/1998','03/23/1998','02/26/1998',1,62.09,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10902,'FOLKO',1,'02/23/1998','03/23/1998','03/03/1998',1,44.15,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10903,'HANAR',3,'02/24/1998','03/24/1998','03/04/1998',3,36.71,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10904,'WHITC',3,'02/24/1998','03/24/1998','02/27/1998',3,162.95,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10905,'WELLI',9,'02/24/1998','03/24/1998','03/06/1998',2,13.72,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10906,'WOLZA',4,'02/25/1998','03/11/1998','03/03/1998',3,26.29,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10907,'SPECD',6,'02/25/1998','03/25/1998','02/27/1998',3,9.19,'Spcialits du monde','25, rue Lauriston','Paris',NULL,'75016','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10908,'REGGC',4,'02/26/1998','03/26/1998','03/06/1998',2,32.96,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10909,'SANTG',1,'02/26/1998','03/26/1998','03/10/1998',2,53.05,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10910,'WILMK',1,'02/26/1998','03/26/1998','03/04/1998',3,38.11,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10911,'GODOS',3,'02/26/1998','03/26/1998','03/05/1998',1,38.19,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10912,'HUNGO',2,'02/26/1998','03/26/1998','03/18/1998',2,580.91,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10913,'QUEEN',4,'02/26/1998','03/26/1998','03/04/1998',1,33.05,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10914,'QUEEN',6,'02/27/1998','03/27/1998','03/02/1998',1,21.19,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10915,'TORTU',2,'02/27/1998','03/27/1998','03/02/1998',2,3.51,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10916,'RANCH',1,'02/27/1998','03/27/1998','03/09/1998',2,63.77,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10917,'ROMEY',4,'03/02/1998','03/30/1998','03/11/1998',2,8.29,'Romero y tomillo','Gran Va, 1','Madrid',NULL,'28001','Spain')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10918,'BOTTM',3,'03/02/1998','03/30/1998','03/11/1998',3,48.83,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10919,'LINOD',2,'03/02/1998','03/30/1998','03/04/1998',2,19.8,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10920,'AROUT',4,'03/03/1998','03/31/1998','03/09/1998',2,29.61,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10921,'VAFFE',1,'03/03/1998','04/14/1998','03/09/1998',1,176.48,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10922,'HANAR',5,'03/03/1998','03/31/1998','03/05/1998',3,62.74,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10923,'LAMAI',7,'03/03/1998','04/14/1998','03/13/1998',3,68.26,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10924,'BERGS',3,'03/04/1998','04/01/1998','04/08/1998',2,151.52,'Berglunds snabbkp','Berguvsvgen  8','Stockholm',NULL,'S-958 22','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10925,'HANAR',3,'03/04/1998','04/01/1998','03/13/1998',1,2.27,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10926,'ANATR',4,'03/04/1998','04/01/1998','03/11/1998',3,39.92,'Ana Trujillo Emparedados y helados','Avda. de la Constitucin 2222','Mxico D.F.',NULL,'05021','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10927,'LACOR',4,'03/05/1998','04/02/1998','04/08/1998',1,19.79,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10928,'GALED',1,'03/05/1998','04/02/1998','03/18/1998',1,1.36,'Galera del gastronmo','Rambla de Catalua, 23','Barcelona',NULL,'8022','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10929,'FRANK',6,'03/05/1998','04/02/1998','03/12/1998',1,33.93,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10930,'SUPRD',4,'03/06/1998','04/17/1998','03/18/1998',3,15.55,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10931,'RICSU',4,'03/06/1998','03/20/1998','03/19/1998',2,13.6,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10932,'BONAP',8,'03/06/1998','04/03/1998','03/24/1998',1,134.64,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10933,'ISLAT',6,'03/06/1998','04/03/1998','03/16/1998',3,54.15,'Island Trading','Garden House
Crowther Way','Cowes','Isle of Wight','PO31 7PJ','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10934,'LEHMS',3,'03/09/1998','04/06/1998','03/12/1998',3,32.01,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10935,'WELLI',4,'03/09/1998','04/06/1998','03/18/1998',3,47.59,'Wellington Importadora','Rua do Mercado, 12','Resende','SP','08737-363','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10936,'GREAL',3,'03/09/1998','04/06/1998','03/18/1998',2,33.68,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10937,'CACTU',7,'03/10/1998','03/24/1998','03/13/1998',3,31.51,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10938,'QUICK',3,'03/10/1998','04/07/1998','03/16/1998',2,31.89,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10939,'MAGAA',2,'03/10/1998','04/07/1998','03/13/1998',2,76.33,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10940,'BONAP',8,'03/11/1998','04/08/1998','03/23/1998',3,19.77,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10941,'SAVEA',7,'03/11/1998','04/08/1998','03/20/1998',2,400.81,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10942,'REGGC',9,'03/11/1998','04/08/1998','03/18/1998',3,17.95,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10943,'BSBEV',4,'03/11/1998','04/08/1998','03/19/1998',2,2.17,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10944,'BOTTM',6,'03/12/1998','03/26/1998','03/13/1998',3,52.92,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10945,'MORGK',4,'03/12/1998','04/09/1998','03/18/1998',1,10.22,'Morgenstern Gesundkost','Heerstr. 22','Leipzig',NULL,'04179','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10946,'VAFFE',1,'03/12/1998','04/09/1998','03/19/1998',2,27.2,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10947,'BSBEV',3,'03/13/1998','04/10/1998','03/16/1998',2,3.26,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10948,'GODOS',3,'03/13/1998','04/10/1998','03/19/1998',3,23.39,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10949,'BOTTM',2,'03/13/1998','04/10/1998','03/17/1998',3,74.44,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10950,'MAGAA',1,'03/16/1998','04/13/1998','03/23/1998',2,2.5,'Magazzini Alimentari Riuniti','Via Ludovico il Moro 22','Bergamo',NULL,'24100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10951,'RICSU',9,'03/16/1998','04/27/1998','04/07/1998',2,30.85,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10952,'ALFKI',1,'03/16/1998','04/27/1998','03/24/1998',1,40.42,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10953,'AROUT',9,'03/16/1998','03/30/1998','03/25/1998',2,23.72,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10954,'LINOD',5,'03/17/1998','04/28/1998','03/20/1998',1,27.91,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10955,'FOLKO',8,'03/17/1998','04/14/1998','03/20/1998',2,3.26,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10956,'BLAUS',6,'03/17/1998','04/28/1998','03/20/1998',2,44.65,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10957,'HILAA',8,'03/18/1998','04/15/1998','03/27/1998',3,105.36,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10958,'OCEAN',7,'03/18/1998','04/15/1998','03/27/1998',2,49.56,'Ocano Atlntico Ltda.','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10959,'GOURL',6,'03/18/1998','04/29/1998','03/23/1998',2,4.98,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10960,'HILAA',3,'03/19/1998','04/02/1998','04/08/1998',1,2.08,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10961,'QUEEN',8,'03/19/1998','04/16/1998','03/30/1998',1,104.47,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10962,'QUICK',8,'03/19/1998','04/16/1998','03/23/1998',2,275.79,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10963,'FURIB',9,'03/19/1998','04/16/1998','03/26/1998',3,2.7,'Furia Bacalhau e Frutos do Mar','Jardim das rosas n. 32','Lisboa',NULL,'1675','Portugal')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10964,'SPECD',3,'03/20/1998','04/17/1998','03/24/1998',2,87.38,'Spcialits du monde','25, rue Lauriston','Paris',NULL,'75016','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10965,'OLDWO',6,'03/20/1998','04/17/1998','03/30/1998',3,144.38,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10966,'CHOPS',4,'03/20/1998','04/17/1998','04/08/1998',1,27.19,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10967,'TOMSP',2,'03/23/1998','04/20/1998','04/02/1998',2,62.22,'Toms Spezialitten','Luisenstr. 48','Mnster',NULL,'44087','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10968,'ERNSH',1,'03/23/1998','04/20/1998','04/01/1998',3,74.6,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10969,'COMMI',1,'03/23/1998','04/20/1998','03/30/1998',2,0.21,'Comrcio Mineiro','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10970,'BOLID',9,'03/24/1998','04/07/1998','04/24/1998',1,16.16,'Blido Comidas preparadas','C/ Araquil, 67','Madrid',NULL,'28023','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10971,'FRANR',2,'03/24/1998','04/21/1998','04/02/1998',2,121.82,'France restauration','54, rue Royale','Nantes',NULL,'44000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10972,'LACOR',4,'03/24/1998','04/21/1998','03/26/1998',2,0.02,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10973,'LACOR',6,'03/24/1998','04/21/1998','03/27/1998',2,15.17,'La corne d''abondance','67, avenue de l''Europe','Versailles',NULL,'78000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10974,'SPLIR',3,'03/25/1998','04/08/1998','04/03/1998',3,12.96,'Split Rail Beer & Ale','P.O. Box 555','Lander','WY','82520','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10975,'BOTTM',1,'03/25/1998','04/22/1998','03/27/1998',3,32.27,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10976,'HILAA',1,'03/25/1998','05/06/1998','04/03/1998',1,37.97,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10977,'FOLKO',8,'03/26/1998','04/23/1998','04/10/1998',3,208.5,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10978,'MAISD',9,'03/26/1998','04/23/1998','04/23/1998',2,32.82,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10979,'ERNSH',8,'03/26/1998','04/23/1998','03/31/1998',2,353.07,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10980,'FOLKO',4,'03/27/1998','05/08/1998','04/17/1998',1,1.26,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10981,'HANAR',1,'03/27/1998','04/24/1998','04/02/1998',2,193.37,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10982,'BOTTM',2,'03/27/1998','04/24/1998','04/08/1998',1,14.01,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10983,'SAVEA',2,'03/27/1998','04/24/1998','04/06/1998',2,657.54,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10984,'SAVEA',1,'03/30/1998','04/27/1998','04/03/1998',3,211.22,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10985,'HUNGO',2,'03/30/1998','04/27/1998','04/02/1998',1,91.51,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10986,'OCEAN',8,'03/30/1998','04/27/1998','04/21/1998',2,217.86,'Ocano Atlntico Ltda.','Ing. Gustavo Moncada 8585
Piso 20-A','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10987,'EASTC',8,'03/31/1998','04/28/1998','04/06/1998',1,185.48,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10988,'RATTC',3,'03/31/1998','04/28/1998','04/10/1998',2,61.14,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10989,'QUEDE',2,'03/31/1998','04/28/1998','04/02/1998',1,34.76,'Que Delcia','Rua da Panificadora, 12','Rio de Janeiro','RJ','02389-673','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10990,'ERNSH',2,'04/01/1998','05/13/1998','04/07/1998',3,117.61,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10991,'QUICK',1,'04/01/1998','04/29/1998','04/07/1998',1,38.51,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10992,'THEBI',1,'04/01/1998','04/29/1998','04/03/1998',3,4.27,'The Big Cheese','89 Jefferson Way
Suite 2','Portland','OR','97201','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10993,'FOLKO',7,'04/01/1998','04/29/1998','04/10/1998',3,8.81,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10994,'VAFFE',2,'04/02/1998','04/16/1998','04/09/1998',3,65.53,'Vaffeljernet','Smagslget 45','rhus',NULL,'8200','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10995,'PERIC',1,'04/02/1998','04/30/1998','04/06/1998',3,46,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10996,'QUICK',4,'04/02/1998','04/30/1998','04/10/1998',2,1.12,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10997,'LILAS',8,'04/03/1998','05/15/1998','04/13/1998',2,73.91,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10998,'WOLZA',8,'04/03/1998','04/17/1998','04/17/1998',2,20.31,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(10999,'OTTIK',6,'04/03/1998','05/01/1998','04/10/1998',2,96.35,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11000,'RATTC',2,'04/06/1998','05/04/1998','04/14/1998',3,55.12,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11001,'FOLKO',2,'04/06/1998','05/04/1998','04/14/1998',2,197.3,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11002,'SAVEA',4,'04/06/1998','05/04/1998','04/16/1998',1,141.16,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11003,'THECR',3,'04/06/1998','05/04/1998','04/08/1998',3,14.91,'The Cracker Box','55 Grizzly Peak Rd.','Butte','MT','59801','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11004,'MAISD',3,'04/07/1998','05/05/1998','04/20/1998',1,44.84,'Maison Dewey','Rue Joseph-Bens 532','Bruxelles',NULL,'B-1180','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11005,'WILMK',2,'04/07/1998','05/05/1998','04/10/1998',1,0.75,'Wilman Kala','Keskuskatu 45','Helsinki',NULL,'21240','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11006,'GREAL',3,'04/07/1998','05/05/1998','04/15/1998',2,25.19,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11007,'PRINI',8,'04/08/1998','05/06/1998','04/13/1998',2,202.24,'Princesa Isabel Vinhos','Estrada da sade n. 58','Lisboa',NULL,'1756','Portugal')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11008,'ERNSH',7,'04/08/1998','05/06/1998',NULL,3,79.46,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11009,'GODOS',2,'04/08/1998','05/06/1998','04/10/1998',1,59.11,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11010,'REGGC',2,'04/09/1998','05/07/1998','04/21/1998',2,28.71,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11011,'ALFKI',3,'04/09/1998','05/07/1998','04/13/1998',1,1.21,'Alfreds Futterkiste','Obere Str. 57','Berlin',NULL,'12209','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11012,'FRANK',1,'04/09/1998','04/23/1998','04/17/1998',3,242.95,'Frankenversand','Berliner Platz 43','Mnchen',NULL,'80805','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11013,'ROMEY',2,'04/09/1998','05/07/1998','04/10/1998',1,32.99,'Romero y tomillo','Gran Va, 1','Madrid',NULL,'28001','Spain')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11014,'LINOD',2,'04/10/1998','05/08/1998','04/15/1998',3,23.6,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11015,'SANTG',2,'04/10/1998','04/24/1998','04/20/1998',2,4.62,'Sant Gourmet','Erling Skakkes gate 78','Stavern',NULL,'4110','Norway')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11016,'AROUT',9,'04/10/1998','05/08/1998','04/13/1998',2,33.8,'Around the Horn','Brook Farm
Stratford St. Mary','Colchester','Essex','CO7 6JX','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11017,'ERNSH',9,'04/13/1998','05/11/1998','04/20/1998',2,754.26,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11018,'LONEP',4,'04/13/1998','05/11/1998','04/16/1998',2,11.65,'Lonesome Pine Restaurant','89 Chiaroscuro Rd.','Portland','OR','97219','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11019,'RANCH',6,'04/13/1998','05/11/1998',NULL,3,3.17,'Rancho grande','Av. del Libertador 900','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11020,'OTTIK',2,'04/14/1998','05/12/1998','04/16/1998',2,43.3,'Ottilies Kseladen','Mehrheimerstr. 369','Kln',NULL,'50739','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11021,'QUICK',3,'04/14/1998','05/12/1998','04/21/1998',1,297.18,'QUICK-Stop','Taucherstrae 10','Cunewalde',NULL,'01307','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11022,'HANAR',9,'04/14/1998','05/12/1998','05/04/1998',2,6.27,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11023,'BSBEV',1,'04/14/1998','04/28/1998','04/24/1998',2,123.83,'B''s Beverages','Fauntleroy Circus','London',NULL,'EC2 5NT','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11024,'EASTC',4,'04/15/1998','05/13/1998','04/20/1998',1,74.36,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11025,'WARTH',6,'04/15/1998','05/13/1998','04/24/1998',3,29.17,'Wartian Herkku','Torikatu 38','Oulu',NULL,'90110','Finland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11026,'FRANS',4,'04/15/1998','05/13/1998','04/28/1998',1,47.09,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11027,'BOTTM',1,'04/16/1998','05/14/1998','04/20/1998',1,52.52,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11028,'KOENE',2,'04/16/1998','05/14/1998','04/22/1998',1,29.59,'Kniglich Essen','Maubelstr. 90','Brandenburg',NULL,'14776','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11029,'CHOPS',4,'04/16/1998','05/14/1998','04/27/1998',1,47.84,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11030,'SAVEA',7,'04/17/1998','05/15/1998','04/27/1998',2,830.75,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11031,'SAVEA',6,'04/17/1998','05/15/1998','04/24/1998',2,227.22,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11032,'WHITC',2,'04/17/1998','05/15/1998','04/23/1998',3,606.19,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11033,'RICSU',7,'04/17/1998','05/15/1998','04/23/1998',3,84.74,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11034,'OLDWO',8,'04/20/1998','06/01/1998','04/27/1998',1,40.32,'Old World Delicatessen','2743 Bering St.','Anchorage','AK','99508','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11035,'SUPRD',2,'04/20/1998','05/18/1998','04/24/1998',2,0.17,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11036,'DRACD',8,'04/20/1998','05/18/1998','04/22/1998',3,149.47,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11037,'GODOS',7,'04/21/1998','05/19/1998','04/27/1998',1,3.2,'Godos Cocina Tpica','C/ Romero, 33','Sevilla',NULL,'41101','Spain')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11038,'SUPRD',1,'04/21/1998','05/19/1998','04/30/1998',2,29.59,'Suprmes dlices','Boulevard Tirou, 255','Charleroi',NULL,'B-6000','Belgium')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11039,'LINOD',1,'04/21/1998','05/19/1998',NULL,2,65,'LINO-Delicateses','Ave. 5 de Mayo Porlamar','I. de Margarita','Nueva Esparta','4980','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11040,'GREAL',4,'04/22/1998','05/20/1998',NULL,3,18.84,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11041,'CHOPS',3,'04/22/1998','05/20/1998','04/28/1998',2,48.22,'Chop-suey Chinese','Hauptstr. 31','Bern',NULL,'3012','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11042,'COMMI',2,'04/22/1998','05/06/1998','05/01/1998',1,29.99,'Comrcio Mineiro','Av. dos Lusadas, 23','So Paulo','SP','05432-043','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11043,'SPECD',5,'04/22/1998','05/20/1998','04/29/1998',2,8.8,'Spcialits du monde','25, rue Lauriston','Paris',NULL,'75016','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11044,'WOLZA',4,'04/23/1998','05/21/1998','05/01/1998',1,8.72,'Wolski Zajazd','ul. Filtrowa 68','Warszawa',NULL,'01-012','Poland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11045,'BOTTM',6,'04/23/1998','05/21/1998',NULL,2,70.58,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11046,'WANDK',8,'04/23/1998','05/21/1998','04/24/1998',2,71.64,'Die Wandernde Kuh','Adenauerallee 900','Stuttgart',NULL,'70563','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11047,'EASTC',7,'04/24/1998','05/22/1998','05/01/1998',3,46.62,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11048,'BOTTM',7,'04/24/1998','05/22/1998','04/30/1998',3,24.12,'Bottom-Dollar Markets','23 Tsawassen Blvd.','Tsawassen','BC','T2F 8M4','Canada')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11049,'GOURL',3,'04/24/1998','05/22/1998','05/04/1998',1,8.34,'Gourmet Lanchonetes','Av. Brasil, 442','Campinas','SP','04876-786','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11050,'FOLKO',8,'04/27/1998','05/25/1998','05/05/1998',2,59.41,'Folk och f HB','kergatan 24','Brcke',NULL,'S-844 67','Sweden')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11051,'LAMAI',7,'04/27/1998','05/25/1998',NULL,3,2.79,'La maison d''Asie','1 rue Alsace-Lorraine','Toulouse',NULL,'31000','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11052,'HANAR',3,'04/27/1998','05/25/1998','05/01/1998',1,67.26,'Hanari Carnes','Rua do Pao, 67','Rio de Janeiro','RJ','05454-876','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11053,'PICCO',2,'04/27/1998','05/25/1998','04/29/1998',2,53.05,'Piccolo und mehr','Geislweg 14','Salzburg',NULL,'5020','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11054,'CACTU',8,'04/28/1998','05/26/1998',NULL,1,0.33,'Cactus Comidas para llevar','Cerrito 333','Buenos Aires',NULL,'1010','Argentina')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11055,'HILAA',7,'04/28/1998','05/26/1998','05/05/1998',2,120.92,'HILARIN-Abastos','Carrera 22 con Ave. Carlos Soublette #8-35','San Cristbal','Tchira','5022','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11056,'EASTC',8,'04/28/1998','05/12/1998','05/01/1998',2,278.96,'Eastern Connection','35 King George','London',NULL,'WX3 6FW','UK')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11057,'NORTS',3,'04/29/1998','05/27/1998','05/01/1998',3,4.13,'North/South','South House
300 Queensbridge','London',NULL,'SW7 1RZ','UK')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11058,'BLAUS',9,'04/29/1998','05/27/1998',NULL,3,31.14,'Blauer See Delikatessen','Forsterstr. 57','Mannheim',NULL,'68306','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11059,'RICAR',2,'04/29/1998','06/10/1998',NULL,2,85.8,'Ricardo Adocicados','Av. Copacabana, 267','Rio de Janeiro','RJ','02389-890','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11060,'FRANS',2,'04/30/1998','05/28/1998','05/04/1998',2,10.98,'Franchi S.p.A.','Via Monte Bianco 34','Torino',NULL,'10100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11061,'GREAL',4,'04/30/1998','06/11/1998',NULL,3,14.01,'Great Lakes Food Market','2732 Baker Blvd.','Eugene','OR','97403','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11062,'REGGC',4,'04/30/1998','05/28/1998',NULL,2,29.93,'Reggiani Caseifici','Strada Provinciale 124','Reggio Emilia',NULL,'42100','Italy')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11063,'HUNGO',3,'04/30/1998','05/28/1998','05/06/1998',2,81.73,'Hungry Owl All-Night Grocers','8 Johnstown Road','Cork','Co. Cork',NULL,'Ireland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11064,'SAVEA',1,'05/01/1998','05/29/1998','05/04/1998',1,30.09,'Save-a-lot Markets','187 Suffolk Ln.','Boise','ID','83720','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11065,'LILAS',8,'05/01/1998','05/29/1998',NULL,1,12.91,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11066,'WHITC',7,'05/01/1998','05/29/1998','05/04/1998',2,44.72,'White Clover Markets','1029 - 12th Ave. S.','Seattle','WA','98124','USA')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11067,'DRACD',1,'05/04/1998','05/18/1998','05/06/1998',2,7.98,'Drachenblut Delikatessen','Walserweg 21','Aachen',NULL,'52066','Germany')
go
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11068,'QUEEN',8,'05/04/1998','06/01/1998',NULL,2,81.75,'Queen Cozinha','Alameda dos Canrios, 891','So Paulo','SP','05487-020','Brazil')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11069,'TORTU',1,'05/04/1998','06/01/1998','05/06/1998',2,15.67,'Tortuga Restaurante','Avda. Azteca 123','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11070,'LEHMS',2,'05/05/1998','06/02/1998',NULL,1,136,'Lehmanns Marktstand','Magazinweg 7','Frankfurt a.M. ',NULL,'60528','Germany')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11071,'LILAS',1,'05/05/1998','06/02/1998',NULL,1,0.93,'LILA-Supermercado','Carrera 52 con Ave. Bolvar #65-98 Llano Largo','Barquisimeto','Lara','3508','Venezuela')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11072,'ERNSH',4,'05/05/1998','06/02/1998',NULL,2,258.64,'Ernst Handel','Kirchgasse 6','Graz',NULL,'8010','Austria')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11073,'PERIC',2,'05/05/1998','06/02/1998',NULL,2,24.95,'Pericles Comidas clsicas','Calle Dr. Jorge Cash 321','Mxico D.F.',NULL,'05033','Mexico')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11074,'SIMOB',7,'05/06/1998','06/03/1998',NULL,2,18.44,'Simons bistro','Vinbltet 34','Kbenhavn',NULL,'1734','Denmark')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11075,'RICSU',8,'05/06/1998','06/03/1998',NULL,2,6.19,'Richter Supermarkt','Starenweg 5','Genve',NULL,'1204','Switzerland')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11076,'BONAP',4,'05/06/1998','06/03/1998',NULL,2,38.28,'Bon app''','12, rue des Bouchers','Marseille',NULL,'13008','France')
INSERT "Orders"("OrderID","CustomerID","EmployeeID","OrderDate","RequiredDate","ShippedDate","ShipVia","Freight","ShipName","ShipAddress","ShipCity","ShipRegion","ShipPostalCode","ShipCountry") VALUES(11077,'RATTC',1,'05/06/1998','06/03/1998',NULL,2,8.53,'Rattlesnake Canyon Grocery','2817 Milton Dr.','Albuquerque','NM','87110','USA')
go
go
set identity_insert "Orders" off
go
ALTER TABLE "Orders" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "Products" on
go
ALTER TABLE "Products" NOCHECK CONSTRAINT ALL
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(1,'Chai',1,1,'10 boxes x 20 bags',18,39,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(2,'Chang',1,1,'24 - 12 oz bottles',19,17,40,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(3,'Aniseed Syrup',1,2,'12 - 550 ml bottles',10,13,70,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(4,'Chef Anton''s Cajun Seasoning',2,2,'48 - 6 oz jars',22,53,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(5,'Chef Anton''s Gumbo Mix',2,2,'36 boxes',21.35,0,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(6,'Grandma''s Boysenberry Spread',3,2,'12 - 8 oz jars',25,120,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(7,'Uncle Bob''s Organic Dried Pears',3,7,'12 - 1 lb pkgs.',30,15,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(8,'Northwoods Cranberry Sauce',3,2,'12 - 12 oz jars',40,6,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(9,'Mishi Kobe Niku',4,6,'18 - 500 g pkgs.',97,29,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(10,'Ikura',4,8,'12 - 200 ml jars',31,31,0,0,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(11,'Queso Cabrales',5,4,'1 kg pkg.',21,22,30,30,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(12,'Queso Manchego La Pastora',5,4,'10 - 500 g pkgs.',38,86,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(13,'Konbu',6,8,'2 kg box',6,24,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(14,'Tofu',6,7,'40 - 100 g pkgs.',23.25,35,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(15,'Genen Shouyu',6,2,'24 - 250 ml bottles',15.5,39,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(16,'Pavlova',7,3,'32 - 500 g boxes',17.45,29,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(17,'Alice Mutton',7,6,'20 - 1 kg tins',39,0,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(18,'Carnarvon Tigers',7,8,'16 kg pkg.',62.5,42,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(19,'Teatime Chocolate Biscuits',8,3,'10 boxes x 12 pieces',9.2,25,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(20,'Sir Rodney''s Marmalade',8,3,'30 gift boxes',81,40,0,0,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(21,'Sir Rodney''s Scones',8,3,'24 pkgs. x 4 pieces',10,3,40,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(22,'Gustaf''s Knckebrd',9,5,'24 - 500 g pkgs.',21,104,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(23,'Tunnbrd',9,5,'12 - 250 g pkgs.',9,61,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(24,'Guaran Fantstica',10,1,'12 - 355 ml cans',4.5,20,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(25,'NuNuCa Nu-Nougat-Creme',11,3,'20 - 450 g glasses',14,76,0,30,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(26,'Gumbr Gummibrchen',11,3,'100 - 250 g bags',31.23,15,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(27,'Schoggi Schokolade',11,3,'100 - 100 g pieces',43.9,49,0,30,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(28,'Rssle Sauerkraut',12,7,'25 - 825 g cans',45.6,26,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(29,'Thringer Rostbratwurst',12,6,'50 bags x 30 sausgs.',123.79,0,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(30,'Nord-Ost Matjeshering',13,8,'10 - 200 g glasses',25.89,10,0,15,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(31,'Gorgonzola Telino',14,4,'12 - 100 g pkgs',12.5,0,70,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(32,'Mascarpone Fabioli',14,4,'24 - 200 g pkgs.',32,9,40,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(33,'Geitost',15,4,'500 g',2.5,112,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(34,'Sasquatch Ale',16,1,'24 - 12 oz bottles',14,111,0,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(35,'Steeleye Stout',16,1,'24 - 12 oz bottles',18,20,0,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(36,'Inlagd Sill',17,8,'24 - 250 g  jars',19,112,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(37,'Gravad lax',17,8,'12 - 500 g pkgs.',26,11,50,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(38,'Cte de Blaye',18,1,'12 - 75 cl bottles',263.5,17,0,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(39,'Chartreuse verte',18,1,'750 cc per bottle',18,69,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(40,'Boston Crab Meat',19,8,'24 - 4 oz tins',18.4,123,0,30,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(41,'Jack''s New England Clam Chowder',19,8,'12 - 12 oz cans',9.65,85,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(42,'Singaporean Hokkien Fried Mee',20,5,'32 - 1 kg pkgs.',14,26,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(43,'Ipoh Coffee',20,1,'16 - 500 g tins',46,17,10,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(44,'Gula Malacca',20,2,'20 - 2 kg bags',19.45,27,0,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(45,'Rgede sild',21,8,'1k pkg.',9.5,5,70,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(46,'Spegesild',21,8,'4 - 450 g glasses',12,95,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(47,'Zaanse koeken',22,3,'10 - 4 oz boxes',9.5,36,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(48,'Chocolade',22,3,'10 pkgs.',12.75,15,70,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(49,'Maxilaku',23,3,'24 - 50 g pkgs.',20,10,60,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(50,'Valkoinen suklaa',23,3,'12 - 100 g bars',16.25,65,0,30,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(51,'Manjimup Dried Apples',24,7,'50 - 300 g pkgs.',53,20,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(52,'Filo Mix',24,5,'16 - 2 kg boxes',7,38,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(53,'Perth Pasties',24,6,'48 pieces',32.8,0,0,0,1)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(54,'Tourtire',25,6,'16 pies',7.45,21,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(55,'Pt chinois',25,6,'24 boxes x 2 pies',24,115,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(56,'Gnocchi di nonna Alice',26,5,'24 - 250 g pkgs.',38,21,10,30,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(57,'Ravioli Angelo',26,5,'24 - 250 g pkgs.',19.5,36,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(58,'Escargots de Bourgogne',27,8,'24 pieces',13.25,62,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(59,'Raclette Courdavault',28,4,'5 kg pkg.',55,79,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(60,'Camembert Pierrot',28,4,'15 - 300 g rounds',34,19,0,0,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(61,'Sirop d''rable',29,2,'24 - 500 ml bottles',28.5,113,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(62,'Tarte au sucre',29,3,'48 pies',49.3,17,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(63,'Vegie-spread',7,2,'15 - 625 g jars',43.9,24,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(64,'Wimmers gute Semmelkndel',12,5,'20 bags x 4 pieces',33.25,22,80,30,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(65,'Louisiana Fiery Hot Pepper Sauce',2,2,'32 - 8 oz bottles',21.05,76,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(66,'Louisiana Hot Spiced Okra',2,2,'24 - 8 oz jars',17,4,100,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(67,'Laughing Lumberjack Lager',16,1,'24 - 12 oz bottles',14,52,0,10,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(68,'Scottish Longbreads',8,3,'10 boxes x 8 pieces',12.5,6,10,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(69,'Gudbrandsdalsost',15,4,'10 kg pkg.',36,26,0,15,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(70,'Outback Lager',7,1,'24 - 355 ml bottles',15,15,10,30,0)
go
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(71,'Fltemysost',15,4,'10 - 500 g pkgs.',21.5,26,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(72,'Mozzarella di Giovanni',14,4,'24 - 200 g pkgs.',34.8,14,0,0,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(73,'Rd Kaviar',17,8,'24 - 150 g jars',15,101,0,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(74,'Longlife Tofu',4,7,'5 kg pkg.',10,4,20,5,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(75,'Rhnbru Klosterbier',12,1,'24 - 0.5 l bottles',7.75,125,0,25,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(76,'Lakkalikri',23,1,'500 ml',18,57,0,20,0)
INSERT "Products"("ProductID","ProductName","SupplierID","CategoryID","QuantityPerUnit","UnitPrice","UnitsInStock","UnitsOnOrder","ReorderLevel","Discontinued") VALUES(77,'Original Frankfurter grne Soe',12,2,'12 boxes',13,32,0,15,0)
go
set identity_insert "Products" off
go
ALTER TABLE "Products" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "Shippers" on
go
ALTER TABLE "Shippers" NOCHECK CONSTRAINT ALL
go
INSERT "Shippers"("ShipperID","CompanyName","Phone") VALUES(1,'Speedy Express','(503) 555-9831')
INSERT "Shippers"("ShipperID","CompanyName","Phone") VALUES(2,'United Package','(503) 555-3199')
INSERT "Shippers"("ShipperID","CompanyName","Phone") VALUES(3,'Federal Shipping','(503) 555-9931')
go
set identity_insert "Shippers" off
go
ALTER TABLE "Shippers" CHECK CONSTRAINT ALL
go
set quoted_identifier on
go
set identity_insert "Suppliers" on
go
ALTER TABLE "Suppliers" NOCHECK CONSTRAINT ALL
go
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(1,'Exotic Liquids','Charlotte Cooper','Purchasing Manager','49 Gilbert St.','London',NULL,'EC1 4SD','UK','(171) 555-2222',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(2,'New Orleans Cajun Delights','Shelley Burke','Order Administrator','P.O. Box 78934','New Orleans','LA','70117','USA','(100) 555-4822',NULL,'#CAJUN.HTM#')
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(3,'Grandma Kelly''s Homestead','Regina Murphy','Sales Representative','707 Oxford Rd.','Ann Arbor','MI','48104','USA','(313) 555-5735','(313) 555-3349',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(4,'Tokyo Traders','Yoshi Nagase','Marketing Manager','9-8 Sekimai
Musashino-shi','Tokyo',NULL,'100','Japan','(03) 3555-5011',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(5,'Cooperativa de Quesos ''Las Cabras''','Antonio del Valle Saavedra ','Export Administrator','Calle del Rosal 4','Oviedo','Asturias','33007','Spain','(98) 598 76 54',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(6,'Mayumi''s','Mayumi Ohno','Marketing Representative','92 Setsuko
Chuo-ku','Osaka',NULL,'545','Japan','(06) 431-7877',NULL,'Mayumi''s (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/mayumi.htm#')
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(7,'Pavlova, Ltd.','Ian Devling','Marketing Manager','74 Rose St.
Moonie Ponds','Melbourne','Victoria','3058','Australia','(03) 444-2343','(03) 444-6588',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(8,'Specialty Biscuits, Ltd.','Peter Wilson','Sales Representative','29 King''s Way','Manchester',NULL,'M14 GSD','UK','(161) 555-4448',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(9,'PB Knckebrd AB','Lars Peterson','Sales Agent','Kaloadagatan 13','Gteborg',NULL,'S-345 67','Sweden ','031-987 65 43','031-987 65 91',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(10,'Refrescos Americanas LTDA','Carlos Diaz','Marketing Manager','Av. das Americanas 12.890','So Paulo',NULL,'5442','Brazil','(11) 555 4640',NULL,NULL)
go
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(11,'Heli Swaren GmbH & Co. KG','Petra Winkler','Sales Manager','Tiergartenstrae 5','Berlin',NULL,'10785','Germany','(010) 9984510',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(12,'Plutzer Lebensmittelgromrkte AG','Martin Bein','International Marketing Mgr.','Bogenallee 51','Frankfurt',NULL,'60439','Germany','(069) 992755',NULL,'Plutzer (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/plutzer.htm#')
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(13,'Nord-Ost-Fisch Handelsgesellschaft mbH','Sven Petersen','Coordinator Foreign Markets','Frahmredder 112a','Cuxhaven',NULL,'27478','Germany','(04721) 8713','(04721) 8714',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(14,'Formaggi Fortini s.r.l.','Elio Rossi','Sales Representative','Viale Dante, 75','Ravenna',NULL,'48100','Italy','(0544) 60323','(0544) 60603','#FORMAGGI.HTM#')
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(15,'Norske Meierier','Beate Vileid','Marketing Manager','Hatlevegen 5','Sandvika',NULL,'1320','Norway','(0)2-953010',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(16,'Bigfoot Breweries','Cheryl Saylor','Regional Account Rep.','3400 - 8th Avenue
Suite 210','Bend','OR','97101','USA','(503) 555-9931',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(17,'Svensk Sjfda AB','Michael Bjrn','Sales Representative','Brovallavgen 231','Stockholm',NULL,'S-123 45','Sweden','08-123 45 67',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(18,'Aux joyeux ecclsiastiques','Guylne Nodier','Sales Manager','203, Rue des Francs-Bourgeois','Paris',NULL,'75004','France','(1) 03.83.00.68','(1) 03.83.00.62',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(19,'New England Seafood Cannery','Robb Merchant','Wholesale Account Agent','Order Processing Dept.
2100 Paul Revere Blvd.','Boston','MA','02134','USA','(617) 555-3267','(617) 555-3389',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(20,'Leka Trading','Chandra Leka','Owner','471 Serangoon Loop, Suite #402','Singapore',NULL,'0512','Singapore','555-8787',NULL,NULL)
go
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(21,'Lyngbysild','Niels Petersen','Sales Manager','Lyngbysild
Fiskebakken 10','Lyngby',NULL,'2800','Denmark','43844108','43844115',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(22,'Zaanse Snoepfabriek','Dirk Luchte','Accounting Manager','Verkoop
Rijnweg 22','Zaandam',NULL,'9999 ZZ','Netherlands','(12345) 1212','(12345) 1210',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(23,'Karkki Oy','Anne Heikkonen','Product Manager','Valtakatu 12','Lappeenranta',NULL,'53120','Finland','(953) 10956',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(24,'G''day, Mate','Wendy Mackenzie','Sales Representative','170 Prince Edward Parade
Hunter''s Hill','Sydney','NSW','2042','Australia','(02) 555-5914','(02) 555-4873','G''day Mate (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/gdaymate.htm#')
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(25,'Ma Maison','Jean-Guy Lauzon','Marketing Manager','2960 Rue St. Laurent','Montral','Qubec','H1J 1C3','Canada','(514) 555-9022',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(26,'Pasta Buttini s.r.l.','Giovanni Giudici','Order Administrator','Via dei Gelsomini, 153','Salerno',NULL,'84100','Italy','(089) 6547665','(089) 6547667',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(27,'Escargots Nouveaux','Marie Delamare','Sales Manager','22, rue H. Voiron','Montceau',NULL,'71300','France','85.57.00.07',NULL,NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(28,'Gai pturage','Eliane Noz','Sales Representative','Bat. B
3, rue des Alpes','Annecy',NULL,'74000','France','38.76.98.06','38.76.98.58',NULL)
INSERT "Suppliers"("SupplierID","CompanyName","ContactName","ContactTitle","Address","City","Region","PostalCode","Country","Phone","Fax","HomePage") VALUES(29,'Forts d''rables','Chantal Goulet','Accounting Manager','148 rue Chasseur','Ste-Hyacinthe','Qubec','J2S 7S8','Canada','(514) 555-2955','(514) 555-2921',NULL)
go
set identity_insert "Suppliers" off
go
ALTER TABLE "Suppliers" CHECK CONSTRAINT ALL
go

declare @version8 binary
declare @sql8 int
select @sql8 = 0x08000000
select @version8 = convert(binary(4),(@sql8 & @@microsoftversion))
if @version8 = 0x08
begin

exec sp_addextendedproperty 'MS_DefaultView', 2, 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_Filter', null, 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_LinkChildFields', null, 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_LinkMasterFields', null, 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_OrderBy', 'CustomerID', 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_OrderByOn', '1', 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_Orientation', 0, 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_SubdatasheetName', '[Auto]', 'user', 'dbo', 'table', 'Orders'

exec sp_addextendedproperty 'MS_Caption', 'Customer Name', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ColumnCount', '2', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ColumnWidth', 2940, 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ColumnWidths', '0.000;2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_DisplayControl', '111', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_LimitToList', '-1', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_ListWidth', '2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_RowSource', 'dbo.Customers', 'user', 'dbo', 'table', 'Orders', 'column', 'CustomerID'

exec sp_addextendedproperty 'MS_Caption', 'Employee Name', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnCount', '2', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnWidth', 2295, 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnWidths', '0.000;2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_DisplayControl', '111', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_LimitToList', '-1', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ListWidth', '2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_RowSource', 'SELECT EmployeeId, LastName + '', '' + FirstName FROM dbo.Employees ORDER BY LastName,FirstName', 'user', 'dbo', 'table', 'Orders', 'column', 'EmployeeID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'Freight'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'Freight'

exec sp_addextendedproperty 'MS_ColumnWidth', 945, 'user', 'dbo', 'table', 'Orders', 'column', 'Freight'

exec sp_addextendedproperty 'MS_Format', 'Currency', 'user', 'dbo', 'table', 'Orders', 'column', 'Freight'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'OrderDate'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'OrderDate'

exec sp_addextendedproperty 'MS_ColumnWidth', 1035, 'user', 'dbo', 'table', 'Orders', 'column', 'OrderDate'

exec sp_addextendedproperty 'MS_Format', 'Short Date', 'user', 'dbo', 'table', 'Orders', 'column', 'OrderDate'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnOrder', 1, 'user', 'dbo', 'table', 'Orders', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnWidth', 810, 'user', 'dbo', 'table', 'Orders', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'RequiredDate'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'RequiredDate'

exec sp_addextendedproperty 'MS_ColumnWidth', 1320, 'user', 'dbo', 'table', 'Orders', 'column', 'RequiredDate'

exec sp_addextendedproperty 'MS_Format', 'Short Date', 'user', 'dbo', 'table', 'Orders', 'column', 'RequiredDate'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipAddress'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipAddress'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipAddress'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCity'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCity'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCity'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCountry'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCountry'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipCountry'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipName'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipName'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipName'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShippedDate'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShippedDate'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShippedDate'

exec sp_addextendedproperty 'MS_Format', 'Short Date', 'user', 'dbo', 'table', 'Orders', 'column', 'ShippedDate'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipPostalCode'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipPostalCode'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipPostalCode'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipRegion'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipRegion'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipRegion'

exec sp_addextendedproperty 'MS_ColumnCount', '2', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_ColumnWidth', 1845, 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_ColumnWidths', '0.000;2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_DisplayControl', '111', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_LimitToList', '-1', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_ListWidth', '2880.000', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_RowSource', 'dbo.Shippers', 'user', 'dbo', 'table', 'Orders', 'column', 'ShipVia'

exec sp_addextendedproperty 'MS_DefaultView', 2, 'user', 'dbo', 'table', 'Order Details'

exec sp_addextendedproperty 'MS_Filter', null, 'user', 'dbo', 'table', 'Order Details'

exec sp_addextendedproperty 'MS_OrderBy', null, 'user', 'dbo', 'table', 'Order Details'

exec sp_addextendedproperty 'MS_OrderByOn', '0', 'user', 'dbo', 'table', 'Order Details'

exec sp_addextendedproperty 'MS_Orientation', 0, 'user', 'dbo', 'table', 'Order Details'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Order Details', 'column', 'Discount'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Order Details', 'column', 'Discount'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Order Details', 'column', 'Discount'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Order Details', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Order Details', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnWidth', 810, 'user', 'dbo', 'table', 'Order Details', 'column', 'OrderID'

exec sp_addextendedproperty 'MS_ColumnCount', '2', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ColumnWidth', 3450, 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ColumnWidths', '0.000;2880.000', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_DisplayControl', '111', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_LimitToList', '-1', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ListWidth', '2880.000', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_RowSource', 'dbo.Products', 'user', 'dbo', 'table', 'Order Details', 'column', 'ProductID'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Order Details', 'column', 'Quantity'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Order Details', 'column', 'Quantity'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Order Details', 'column', 'Quantity'

exec sp_addextendedproperty 'MS_ColumnHidden', '0', 'user', 'dbo', 'table', 'Order Details', 'column', 'UnitPrice'

exec sp_addextendedproperty 'MS_ColumnOrder', 0, 'user', 'dbo', 'table', 'Order Details', 'column', 'UnitPrice'

exec sp_addextendedproperty 'MS_ColumnWidth', 65535, 'user', 'dbo', 'table', 'Order Details', 'column', 'UnitPrice'


end

GO